/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.steam;

import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.TankWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.steam.SteamBoilerMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SteamLiquidBoilerMachine
extends SteamBoilerMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(SteamLiquidBoilerMachine.class, SteamBoilerMachine.MANAGED_FIELD_HOLDER);
    public static final Object2BooleanMap<Fluid> FUEL_CACHE = new Object2BooleanOpenHashMap();
    @Persisted
    public final NotifiableFluidTank fuelTank;

    public SteamLiquidBoilerMachine(IMachineBlockEntity holder, boolean isHighPressure, Object ... args) {
        super(holder, isHighPressure, args);
        this.fuelTank = this.createFuelTank(args).setFilter(fluid -> FUEL_CACHE.computeIfAbsent((Object)fluid.getFluid(), f -> {
            if (this.isRemote()) {
                return true;
            }
            return this.recipeLogic.getRecipeManager().m_44013_((RecipeType)this.getRecipeType()).stream().anyMatch(recipe -> {
                List list = recipe.inputs.getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList());
                if (!list.isEmpty()) {
                    return Arrays.stream(((FluidIngredient)FluidRecipeCapability.CAP.of(((Content)list.get((int)0)).content)).getStacks()).anyMatch(stack -> stack.getFluid() == f);
                }
                return false;
            });
        }));
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected NotifiableFluidTank createFuelTank(Object ... args) {
        return new NotifiableFluidTank((MetaMachine)this, 1, 16000, IO.IN);
    }

    @Override
    protected long getBaseSteamOutput() {
        return this.isHighPressure ? (long)ConfigHolder.INSTANCE.machines.smallBoilers.hpLiquidBoilerBaseOutput : (long)ConfigHolder.INSTANCE.machines.smallBoilers.liquidBoilerBaseOutput;
    }

    @Override
    public ModularUI createUI(Player entityPlayer) {
        return super.createUI(entityPlayer).widget((Widget)new TankWidget(this.fuelTank.getStorages()[0], 119, 26, 10, 54, true, true).setShowAmount(false).setFillDirection(ProgressTexture.FillDirection.DOWN_TO_UP).setBackground((IGuiTexture)GuiTextures.PROGRESS_BAR_BOILER_EMPTY.get(this.isHighPressure)));
    }

    @Override
    protected void randomDisplayTick(RandomSource random, float x, float y, float z) {
        super.randomDisplayTick(random, x, y, z);
        if (random.m_188501_() < 0.3f) {
            this.getLevel().m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)(x + random.m_188501_()), (double)y, (double)(z + random.m_188501_()), 0.0, 0.0, 0.0);
        }
    }
}

