/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.capability.IDataAccessHatch;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.IDataInfoProvider;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.part.MultiblockPartMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.part.TieredPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.common.item.PortableScannerBehavior;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.research.DataBankMachine;
import com.gregtechceu.gtceu.common.recipe.condition.ResearchCondition;
import com.gregtechceu.gtceu.utils.ItemStackHashStrategy;
import com.gregtechceu.gtceu.utils.ResearchManager;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class DataAccessHatchMachine
extends TieredPartMachine
implements IMachineLife,
IDataAccessHatch,
IDataInfoProvider {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(DataAccessHatchMachine.class, MultiblockPartMachine.MANAGED_FIELD_HOLDER);
    private final Set<GTRecipe> recipes;
    private final boolean isCreative;
    @Persisted
    public final NotifiableItemStackHandler importItems;

    public DataAccessHatchMachine(IMachineBlockEntity holder, int tier, boolean isCreative) {
        super(holder, tier);
        this.isCreative = isCreative;
        this.recipes = isCreative ? Collections.emptySet() : new ObjectOpenHashSet();
        this.importItems = this.createImportItemHandler();
    }

    protected NotifiableItemStackHandler createImportItemHandler() {
        if (this.isCreative) {
            return new NotifiableItemStackHandler(this, 0, IO.BOTH);
        }
        return new NotifiableItemStackHandler(this, this.getInventorySize(), IO.BOTH){

            @Override
            public void onContentsChanged() {
                super.onContentsChanged();
                DataAccessHatchMachine.this.rebuildData(DataAccessHatchMachine.this.isFormed() && DataAccessHatchMachine.this.getControllers().first() instanceof DataBankMachine);
            }

            @Override
            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                boolean isDataBank;
                boolean bl = isDataBank = DataAccessHatchMachine.this.isFormed() && DataAccessHatchMachine.this.getControllers().first() instanceof DataBankMachine;
                if (ResearchManager.isStackDataItem(stack, isDataBank) && ResearchManager.hasResearchTag(stack)) {
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }
        };
    }

    @Override
    public Widget createUIWidget() {
        int rowSize = (int)Math.sqrt(this.getInventorySize());
        int xOffset = 18 * rowSize / 2;
        WidgetGroup group = new WidgetGroup(0, 0, 18 * rowSize, 18 * rowSize);
        for (int y = 0; y < rowSize; ++y) {
            for (int x = 0; x < rowSize; ++x) {
                int index = y * rowSize + x;
                group.addWidget((Widget)new SlotWidget(this.importItems, index, rowSize * 9 + x * 18 - xOffset, y * 18, true, true).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT));
            }
        }
        return group;
    }

    @Override
    public boolean shouldOpenUI(Player player, InteractionHand hand, BlockHitResult hit) {
        return !this.isCreative;
    }

    protected int getInventorySize() {
        return this.getTier() == 6 ? 16 : 9;
    }

    @Override
    public void onMachineRemoved() {
        this.clearInventory((IItemHandlerModifiable)this.importItems.storage);
    }

    private void rebuildData(boolean isDataBank) {
        if (this.isCreative || this.getLevel() == null || this.getLevel().f_46443_) {
            return;
        }
        this.recipes.clear();
        for (int i = 0; i < this.importItems.getSlots(); ++i) {
            Collection<GTRecipe> collection;
            ItemStack stack = this.importItems.getStackInSlot(i);
            Pair<GTRecipeType, String> researchData = ResearchManager.readResearchId(stack);
            boolean isValid = ResearchManager.isStackDataItem(stack, isDataBank);
            if (researchData == null || !isValid || (collection = ((GTRecipeType)researchData.getFirst()).getDataStickEntry((String)researchData.getSecond())) == null) continue;
            this.recipes.addAll(collection);
        }
    }

    @Override
    public boolean isRecipeAvailable(@NotNull GTRecipe recipe, @NotNull Collection<IDataAccessHatch> seen) {
        seen.add(this);
        return recipe.conditions.stream().noneMatch(ResearchCondition.class::isInstance) || this.recipes.contains(recipe);
    }

    @Override
    @NotNull
    public List<Component> getDataInfo(PortableScannerBehavior.DisplayMode mode) {
        if (mode == PortableScannerBehavior.DisplayMode.SHOW_ALL || mode == PortableScannerBehavior.DisplayMode.SHOW_RECIPE_INFO) {
            if (this.recipes.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Component> list = new ArrayList<Component>();
            list.add((Component)Component.m_237115_((String)"behavior.data_item.assemblyline.title"));
            list.add((Component)Component.m_237119_());
            ObjectOpenCustomHashSet itemsAdded = new ObjectOpenCustomHashSet((Hash.Strategy)ItemStackHashStrategy.comparingAll());
            for (GTRecipe recipe : this.recipes) {
                ItemStack stack = ((Ingredient)ItemRecipeCapability.CAP.of(recipe.getOutputContents(ItemRecipeCapability.CAP).get((int)0).content)).m_43908_()[0];
                if (itemsAdded.contains(stack)) continue;
                itemsAdded.add(stack);
                list.add((Component)Component.m_237110_((String)"behavior.data_item.assemblyline.data", (Object[])new Object[]{stack.m_41611_()}));
            }
            return list;
        }
        return new ArrayList<Component>();
    }

    @Override
    public boolean canShared() {
        return this.isCreative;
    }

    @Override
    public void addedToController(IMultiController controller) {
        this.rebuildData(controller instanceof DataBankMachine);
        super.addedToController(controller);
    }

    @Override
    public GTRecipe modifyRecipe(GTRecipe recipe) {
        return IDataAccessHatch.super.modifyRecipe(recipe);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public boolean isCreative() {
        return this.isCreative;
    }
}

