/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.generator;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.ITieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IRotorHolderMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.modifier.ModifierFunction;
import com.gregtechceu.gtceu.api.recipe.modifier.ParallelLogic;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifier;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LargeTurbineMachine
extends WorkableElectricMultiblockMachine
implements ITieredMachine {
    public static final int MIN_DURABILITY_TO_WARN = 10;
    private final long BASE_EU_OUTPUT;
    private final int tier;

    public LargeTurbineMachine(IMachineBlockEntity holder, int tier) {
        super(holder, new Object[0]);
        this.tier = tier;
        this.BASE_EU_OUTPUT = GTValues.V[tier] * 2L;
    }

    @Nullable
    private IRotorHolderMachine getRotorHolder() {
        for (IMultiPart part : this.getParts()) {
            if (!(part instanceof IRotorHolderMachine)) continue;
            IRotorHolderMachine rotorHolder = (IRotorHolderMachine)part;
            return rotorHolder;
        }
        return null;
    }

    @Override
    public long getOverclockVoltage() {
        IRotorHolderMachine rotorHolder = this.getRotorHolder();
        if (rotorHolder != null && rotorHolder.hasRotor()) {
            return this.BASE_EU_OUTPUT * (long)rotorHolder.getTotalPower() / 100L;
        }
        return 0L;
    }

    protected double productionBoost() {
        IRotorHolderMachine rotorHolder = this.getRotorHolder();
        if (rotorHolder != null && rotorHolder.hasRotor()) {
            int maxSpeed = rotorHolder.getMaxRotorHolderSpeed();
            int currentSpeed = rotorHolder.getRotorSpeed();
            if (currentSpeed >= maxSpeed) {
                return 1.0;
            }
            return Math.pow(1.0 * (double)currentSpeed / (double)maxSpeed, 2.0);
        }
        return 0.0;
    }

    public static ModifierFunction recipeModifier(@NotNull MetaMachine machine, @NotNull GTRecipe recipe) {
        if (!(machine instanceof LargeTurbineMachine)) {
            return RecipeModifier.nullWrongType(LargeTurbineMachine.class, machine);
        }
        LargeTurbineMachine turbineMachine = (LargeTurbineMachine)machine;
        IRotorHolderMachine rotorHolder = turbineMachine.getRotorHolder();
        if (rotorHolder == null) {
            return ModifierFunction.NULL;
        }
        long EUt = RecipeHelper.getOutputEUt(recipe);
        long turbineMaxVoltage = turbineMachine.getOverclockVoltage();
        double holderEfficiency = (double)rotorHolder.getTotalEfficiency() / 100.0;
        if (EUt <= 0L || turbineMaxVoltage <= EUt || holderEfficiency <= 0.0) {
            return ModifierFunction.NULL;
        }
        int maxParallel = (int)(turbineMaxVoltage / EUt);
        int actualParallel = ParallelLogic.getParallelAmountFast(turbineMachine, recipe, maxParallel);
        double eutMultiplier = turbineMachine.productionBoost() * (double)actualParallel;
        return ModifierFunction.builder().inputModifier(ContentModifier.multiplier(actualParallel)).outputModifier(ContentModifier.multiplier(actualParallel)).eutMultiplier(eutMultiplier).parallels(actualParallel).durationMultiplier(holderEfficiency).build();
    }

    @Override
    public boolean dampingWhenWaiting() {
        return false;
    }

    @Override
    public boolean canVoidRecipeOutputs(RecipeCapability<?> capability) {
        return capability != EURecipeCapability.CAP;
    }

    @Override
    public void addDisplayText(List<Component> textList) {
        IRotorHolderMachine rotorHolder;
        super.addDisplayText(textList);
        if (this.isFormed() && (rotorHolder = this.getRotorHolder()) != null && rotorHolder.getRotorEfficiency() > 0) {
            int rotorDurability;
            textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.turbine.rotor_speed", (Object[])new Object[]{FormattingUtil.formatNumbers(rotorHolder.getRotorSpeed()), FormattingUtil.formatNumbers(rotorHolder.getMaxRotorHolderSpeed())}));
            textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.turbine.efficiency", (Object[])new Object[]{rotorHolder.getTotalEfficiency()}));
            long maxProduction = this.getOverclockVoltage();
            long currentProduction = this.isActive() && this.recipeLogic.getLastRecipe() != null ? RecipeHelper.getOutputEUt(this.recipeLogic.getLastRecipe()) : 0L;
            String voltageName = GTValues.VNF[GTUtil.getTierByVoltage(currentProduction)];
            if (this.isActive()) {
                textList.add(3, (Component)Component.m_237110_((String)"gtceu.multiblock.turbine.energy_per_tick", (Object[])new Object[]{FormattingUtil.formatNumbers(currentProduction), FormattingUtil.formatNumbers(maxProduction)}));
            }
            if ((rotorDurability = rotorHolder.getRotorDurabilityPercent()) > 10) {
                textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.turbine.rotor_durability", (Object[])new Object[]{rotorDurability}));
            } else {
                textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.turbine.rotor_durability", (Object[])new Object[]{rotorDurability}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            }
        }
    }

    @Override
    public int getTier() {
        return this.tier;
    }
}

