/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.fluid.potion;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.common.data.GTFluids;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class PotionFluid
extends ForgeFlowingFluid {
    public PotionFluid(ForgeFlowingFluid.Properties properties) {
        super(properties.bucket(() -> Items.f_41852_).block(() -> (LiquidBlock)Blocks.f_49990_));
        this.m_76142_((FluidState)((FluidState)this.m_76144_().m_61090_()).m_61124_((Property)f_75948_, (Comparable)Integer.valueOf(7)));
    }

    protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
        super.m_7180_(builder);
        builder.m_61104_(new Property[]{f_75948_});
    }

    public static FluidStack of(int amount, Potion potion) {
        FluidStack fluidStack = new FluidStack(((PotionFluid)((Object)GTFluids.POTION.get())).m_5613_(), amount);
        PotionFluid.addPotionToFluidStack(fluidStack, potion);
        return fluidStack;
    }

    public static FluidStack withEffects(int amount, Potion potion, List<MobEffectInstance> customEffects) {
        FluidStack fluidStack = PotionFluid.of(amount, potion);
        PotionFluid.appendEffects(fluidStack, customEffects);
        return fluidStack;
    }

    public static FluidStack addPotionToFluidStack(FluidStack fluidStack, Potion potion) {
        ResourceLocation resourcelocation = BuiltInRegistries.f_256980_.m_7981_((Object)potion);
        if (potion == Potions.f_43598_) {
            fluidStack.removeChildTag("Potion");
            return fluidStack;
        }
        fluidStack.getOrCreateTag().m_128359_("Potion", resourcelocation.toString());
        return fluidStack;
    }

    public static FluidStack appendEffects(FluidStack fluidStack, Collection<MobEffectInstance> customEffects) {
        if (customEffects.isEmpty()) {
            return fluidStack;
        }
        CompoundTag tag = fluidStack.getOrCreateTag();
        ListTag effects = tag.m_128437_("CustomPotionEffects", 9);
        for (MobEffectInstance effect : customEffects) {
            effects.add((Object)effect.m_19555_(new CompoundTag()));
        }
        tag.m_128365_("CustomPotionEffects", (Tag)effects);
        return fluidStack;
    }

    public boolean m_7444_(FluidState state) {
        return this == ((PotionFluid)((Object)GTFluids.POTION.get())).m_5613_();
    }

    public int m_7430_(FluidState state) {
        return (Integer)state.m_61143_((Property)f_75948_);
    }

    public static class PotionFluidType
    extends FluidType {
        private static final ResourceLocation texture = GTCEu.id("block/fluids/fluid.potion");

        public PotionFluidType(FluidType.Properties properties, ResourceLocation still, ResourceLocation flow) {
            super(properties);
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return texture;
                }

                public ResourceLocation getFlowingTexture() {
                    return texture;
                }

                public int getTintColor(FluidStack stack) {
                    CompoundTag tag = stack.getOrCreateTag();
                    return PotionUtils.m_43564_((Collection)PotionUtils.m_43566_((CompoundTag)tag)) | 0xFF000000;
                }
            });
        }

        public String getDescriptionId(FluidStack stack) {
            CompoundTag tag = stack.getOrCreateTag();
            return PotionUtils.m_43577_((CompoundTag)tag).m_43492_(Items.f_42589_.m_5524_() + ".effect.");
        }
    }
}

