/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data.machines;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.pattern.FactoryBlockPattern;
import com.gregtechceu.gtceu.api.pattern.MultiblockShapeInfo;
import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.registry.registrate.MachineBuilder;
import com.gregtechceu.gtceu.api.registry.registrate.MultiblockMachineBuilder;
import com.gregtechceu.gtceu.client.renderer.machine.HPCAPartRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.OverlayTieredActiveMachineRenderer;
import com.gregtechceu.gtceu.client.util.TooltipHelper;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.research.DataBankMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.research.HPCAMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.research.NetworkSwitchMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.research.ResearchStationMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.DataAccessHatchMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.ObjectHolderMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.OpticalComputationHatchMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.OpticalDataHatchMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.hpca.HPCABridgePartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.hpca.HPCAComputationPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.hpca.HPCACoolerPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.hpca.HPCAEmptyPartMachine;
import com.gregtechceu.gtceu.common.registry.GTRegistration;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GTResearchMachines {
    public static final MultiblockMachineDefinition RESEARCH_STATION = ((MultiblockMachineBuilder)GTRegistration.REGISTRATE.multiblock("research_station", x$0 -> new ResearchStationMachine((IMachineBlockEntity)x$0, new Object[0])).rotationState(RotationState.NON_Y_AXIS).recipeType(GTRecipeTypes.RESEARCH_STATION_RECIPES).appearanceBlock((Supplier)GTBlocks.ADVANCED_COMPUTER_CASING)).tooltips((Component[])LangHandler.getMultiLang("gtceu.machine.research_station.tooltip").toArray(Component[]::new)).pattern(defintion -> FactoryBlockPattern.start().aisle("XXX", "VVV", "PPP", "PPP", "PPP", "VVV", "XXX").aisle("XXX", "VAV", "AAA", "AAA", "AAA", "VAV", "XXX").aisle("XXX", "VAV", "XAX", "XSX", "XAX", "VAV", "XXX").aisle("XXX", "XAX", "---", "---", "---", "XAX", "XXX").aisle(" X ", "XAX", "---", "---", "---", "XAX", " X ").aisle(" X ", "XAX", "-A-", "-H-", "-A-", "XAX", " X ").aisle("   ", "XXX", "---", "---", "---", "XXX", "   ").where('S', Predicates.controller(Predicates.blocks(defintion.getBlock()))).where('X', Predicates.blocks((Block)GTBlocks.COMPUTER_CASING.get())).where(' ', Predicates.any()).where('-', Predicates.air()).where('V', Predicates.blocks((Block)GTBlocks.COMPUTER_HEAT_VENT.get())).where('A', Predicates.blocks((Block)GTBlocks.ADVANCED_COMPUTER_CASING.get())).where('P', Predicates.blocks((Block)GTBlocks.COMPUTER_CASING.get()).or(Predicates.abilities(PartAbility.INPUT_ENERGY).setMinGlobalLimited(1).setMaxGlobalLimited(2)).or(Predicates.abilities(PartAbility.MAINTENANCE).setMinGlobalLimited(ConfigHolder.INSTANCE.machines.enableMaintenance ? 1 : 0).setMaxGlobalLimited(1)).or(Predicates.abilities(PartAbility.COMPUTATION_DATA_RECEPTION).setExactLimit(1))).where('H', Predicates.abilities(PartAbility.OBJECT_HOLDER)).build()).shapeInfo(definition -> ((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)MultiblockShapeInfo.builder().aisle(new String[]{"---", "XXX", "---", "---", "---", "XXX", "---"})).aisle(new String[]{"-X-", "XAX", "-A-", "-H-", "-A-", "XAX", "-X-"})).aisle(new String[]{"-X-", "XAX", "---", "---", "---", "XAX", "-X-"})).aisle(new String[]{"XXX", "XAX", "---", "---", "---", "XAX", "XXX"})).aisle(new String[]{"XXX", "VAV", "XAX", "XSX", "XAX", "VAV", "XXX"})).aisle(new String[]{"XXX", "VAV", "AAA", "AAA", "AAA", "VAV", "XXX"})).aisle(new String[]{"XXX", "VVV", "POP", "PEP", "PMP", "VVV", "XXX"})).where('S', RESEARCH_STATION, Direction.NORTH).where('X', (Block)GTBlocks.COMPUTER_CASING.get()).where('-', Blocks.f_50016_).where('V', (Block)GTBlocks.COMPUTER_HEAT_VENT.get()).where('A', (Block)GTBlocks.ADVANCED_COMPUTER_CASING.get()).where('P', (Block)GTBlocks.COMPUTER_CASING.get()).where('O', COMPUTATION_HATCH_RECEIVER, Direction.SOUTH).where('E', GTMachines.ENERGY_INPUT_HATCH[6], Direction.SOUTH).where('M', ConfigHolder.INSTANCE.machines.enableMaintenance ? (BlockState)GTMachines.MAINTENANCE_HATCH.getBlock().m_49966_().m_61124_((Property)GTMachines.MAINTENANCE_HATCH.get().getRotationState().property, (Comparable)Direction.SOUTH) : GTBlocks.COMPUTER_CASING.getDefaultState()).where('H', OBJECT_HOLDER, Direction.SOUTH).build()).sidedWorkableCasingRenderer("block/casings/hpca/advanced_computer_casing", GTCEu.id("block/multiblock/research_station")).register();
    public static final MachineDefinition OBJECT_HOLDER = GTRegistration.REGISTRATE.machine("object_holder", ObjectHolderMachine::new).langValue("Object Holder").tier(7).rotationState(RotationState.ALL).abilities(PartAbility.OBJECT_HOLDER).renderer(() -> new OverlayTieredActiveMachineRenderer(7, GTCEu.id("block/machine/part/object_holder"), GTCEu.id("block/machine/part/object_holder_active"))).register();
    public static final MachineDefinition DATA_BANK = ((MultiblockMachineBuilder)GTRegistration.REGISTRATE.multiblock("data_bank", DataBankMachine::new).langValue("Data Bank").rotationState(RotationState.NON_Y_AXIS).appearanceBlock((Supplier)GTBlocks.COMPUTER_CASING)).recipeType(GTRecipeTypes.DUMMY_RECIPES).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.data_bank.tooltip.0"), Component.m_237115_((String)"gtceu.machine.data_bank.tooltip.1"), Component.m_237115_((String)"gtceu.machine.data_bank.tooltip.2"), Component.m_237110_((String)"gtceu.machine.data_bank.tooltip.3", (Object[])new Object[]{FormattingUtil.formatNumbers(DataBankMachine.EUT_PER_HATCH)}), Component.m_237110_((String)"gtceu.machine.data_bank.tooltip.4", (Object[])new Object[]{FormattingUtil.formatNumbers(DataBankMachine.EUT_PER_HATCH_CHAINED)})}).pattern(definition -> FactoryBlockPattern.start().aisle("XDDDX", "XDDDX", "XDDDX").aisle("XDDDX", "XAAAX", "XDDDX").aisle("XCCCX", "XCSCX", "XCCCX").where('S', Predicates.controller(Predicates.blocks(definition.getBlock()))).where('X', Predicates.blocks((Block)GTBlocks.COMPUTER_HEAT_VENT.get())).where('D', Predicates.blocks((Block)GTBlocks.COMPUTER_CASING.get()).setMinGlobalLimited(3).or(Predicates.abilities(PartAbility.DATA_ACCESS).setPreviewCount(3)).or(Predicates.abilities(PartAbility.OPTICAL_DATA_TRANSMISSION).setMinGlobalLimited(1, 1)).or(Predicates.abilities(PartAbility.OPTICAL_DATA_RECEPTION).setPreviewCount(1))).where('A', Predicates.blocks((Block)GTBlocks.COMPUTER_CASING.get())).where('C', Predicates.blocks((Block)GTBlocks.HIGH_POWER_CASING.get()).setMinGlobalLimited(4).or(Predicates.autoAbilities(new GTRecipeType[0])).or(Predicates.autoAbilities(true, false, false)).or(Predicates.abilities(PartAbility.INPUT_ENERGY).setMinGlobalLimited(1).setMaxGlobalLimited(2).setPreviewCount(1))).build()).workableCasingRenderer(GTCEu.id("block/casings/hpca/high_power_casing"), GTCEu.id("block/multiblock/data_bank")).register();
    public static final MachineDefinition NETWORK_SWITCH = ((MultiblockMachineBuilder)GTRegistration.REGISTRATE.multiblock("network_switch", NetworkSwitchMachine::new).langValue("Network Switch").rotationState(RotationState.NON_Y_AXIS).appearanceBlock((Supplier)GTBlocks.COMPUTER_CASING)).recipeType(GTRecipeTypes.DUMMY_RECIPES).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.network_switch.tooltip.0"), Component.m_237115_((String)"gtceu.machine.network_switch.tooltip.1"), Component.m_237115_((String)"gtceu.machine.network_switch.tooltip.2"), Component.m_237110_((String)"gtceu.machine.network_switch.tooltip.3", (Object[])new Object[]{FormattingUtil.formatNumbers(NetworkSwitchMachine.EUT_PER_HATCH)})}).pattern(definition -> FactoryBlockPattern.start().aisle("XXX", "XXX", "XXX").aisle("XXX", "XAX", "XXX").aisle("XXX", "XSX", "XXX").where('S', Predicates.controller(Predicates.blocks(definition.getBlock()))).where('A', Predicates.blocks((Block)GTBlocks.ADVANCED_COMPUTER_CASING.get())).where('X', Predicates.blocks((Block)GTBlocks.COMPUTER_CASING.get()).setMinGlobalLimited(7).or(Predicates.abilities(PartAbility.INPUT_ENERGY).setMinGlobalLimited(1, 1)).or(Predicates.abilities(PartAbility.MAINTENANCE).setExactLimit(1)).or(Predicates.abilities(PartAbility.COMPUTATION_DATA_RECEPTION).setMinGlobalLimited(1, 2)).or(Predicates.abilities(PartAbility.COMPUTATION_DATA_TRANSMISSION).setMinGlobalLimited(1, 1))).build()).shapeInfo(definition -> ((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)MultiblockShapeInfo.builder().aisle(new String[]{"XMX", "XSX", "XRX"})).aisle(new String[]{"XXX", "XAX", "XXX"})).aisle(new String[]{"XEX", "XXX", "TTT"})).where('S', NETWORK_SWITCH, Direction.NORTH).where('X', (Supplier<? extends Block>)GTBlocks.COMPUTER_CASING).where('A', (Supplier<? extends Block>)GTBlocks.ADVANCED_COMPUTER_CASING).where('R', COMPUTATION_HATCH_RECEIVER, Direction.NORTH).where('T', COMPUTATION_HATCH_TRANSMITTER, Direction.SOUTH).where('M', GTMachines.MAINTENANCE_HATCH, Direction.NORTH).where('E', GTMachines.ENERGY_INPUT_HATCH[6], Direction.NORTH).build()).sidedWorkableCasingRenderer("block/casings/hpca/computer_casing", GTCEu.id("block/multiblock/network_switch")).register();
    public static final MachineDefinition HIGH_PERFORMANCE_COMPUTING_ARRAY = ((MultiblockMachineBuilder)GTRegistration.REGISTRATE.multiblock("high_performance_computation_array", x$0 -> new HPCAMachine((IMachineBlockEntity)x$0, new Object[0])).langValue("High Performance Computation Array (HPCA)").rotationState(RotationState.NON_Y_AXIS).appearanceBlock((Supplier)GTBlocks.COMPUTER_CASING)).recipeType(GTRecipeTypes.DUMMY_RECIPES).tooltips((Component[])LangHandler.getMultiLang("gtceu.machine.high_performance_computation_array.tooltip").toArray(Component[]::new)).pattern(definition -> FactoryBlockPattern.start().aisle("AA", "CC", "CC", "CC", "AA").aisle("VA", "XV", "XV", "XV", "VA").aisle("VA", "XV", "XV", "XV", "VA").aisle("VA", "XV", "XV", "XV", "VA").aisle("SA", "CC", "CC", "CC", "AA").where('S', Predicates.controller(Predicates.blocks(definition.getBlock()))).where('A', Predicates.blocks((Block)GTBlocks.ADVANCED_COMPUTER_CASING.get())).where('V', Predicates.blocks((Block)GTBlocks.COMPUTER_HEAT_VENT.get())).where('X', Predicates.abilities(PartAbility.HPCA_COMPONENT)).where('C', Predicates.blocks((Block)GTBlocks.COMPUTER_CASING.get()).setMinGlobalLimited(5).or(Predicates.abilities(PartAbility.MAINTENANCE).setExactLimit(1)).or(Predicates.abilities(PartAbility.INPUT_ENERGY).setMinGlobalLimited(1)).or(Predicates.abilities(PartAbility.IMPORT_FLUIDS).setMaxGlobalLimited(1)).or(Predicates.abilities(PartAbility.COMPUTATION_DATA_TRANSMISSION).setExactLimit(1))).build()).shapeInfos(definition -> {
        ArrayList<MultiblockShapeInfo> shapeInfo = new ArrayList<MultiblockShapeInfo>();
        MultiblockShapeInfo.ShapeInfoBuilder builder = ((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)MultiblockShapeInfo.builder().aisle(new String[]{"SA", "CC", "CC", "OC", "AA"})).aisle(new String[]{"VA", "8V", "5V", "2V", "VA"})).aisle(new String[]{"VA", "7V", "4V", "1V", "VA"})).aisle(new String[]{"VA", "6V", "3V", "0V", "VA"})).aisle(new String[]{"AA", "EC", "MC", "HC", "AA"})).where('S', HIGH_PERFORMANCE_COMPUTING_ARRAY, Direction.NORTH).where('A', (Supplier<? extends Block>)GTBlocks.ADVANCED_COMPUTER_CASING).where('V', (Supplier<? extends Block>)GTBlocks.COMPUTER_HEAT_VENT).where('C', (Supplier<? extends Block>)GTBlocks.COMPUTER_CASING).where('E', GTMachines.ENERGY_INPUT_HATCH[6], Direction.SOUTH).where('H', GTMachines.FLUID_IMPORT_HATCH[1], Direction.SOUTH).where('O', COMPUTATION_HATCH_TRANSMITTER, Direction.NORTH).where('M', ConfigHolder.INSTANCE.machines.enableMaintenance ? (BlockState)GTMachines.MAINTENANCE_HATCH.defaultBlockState().m_61124_((Property)GTMachines.MAINTENANCE_HATCH.get().getRotationState().property, (Comparable)Direction.SOUTH) : GTBlocks.COMPUTER_CASING.getDefaultState());
        shapeInfo.add(((MultiblockShapeInfo.ShapeInfoBuilder)builder.shallowCopy()).where('0', HPCA_EMPTY_COMPONENT, Direction.WEST).where('1', HPCA_HEAT_SINK_COMPONENT, Direction.WEST).where('2', HPCA_EMPTY_COMPONENT, Direction.WEST).where('3', HPCA_EMPTY_COMPONENT, Direction.WEST).where('4', HPCA_COMPUTATION_COMPONENT, Direction.WEST).where('5', HPCA_EMPTY_COMPONENT, Direction.WEST).where('6', HPCA_EMPTY_COMPONENT, Direction.WEST).where('7', HPCA_HEAT_SINK_COMPONENT, Direction.WEST).where('8', HPCA_EMPTY_COMPONENT, Direction.WEST).build());
        shapeInfo.add(((MultiblockShapeInfo.ShapeInfoBuilder)builder.shallowCopy()).where('0', HPCA_HEAT_SINK_COMPONENT, Direction.WEST).where('1', HPCA_COMPUTATION_COMPONENT, Direction.WEST).where('2', HPCA_HEAT_SINK_COMPONENT, Direction.WEST).where('3', HPCA_ACTIVE_COOLER_COMPONENT, Direction.WEST).where('4', HPCA_COMPUTATION_COMPONENT, Direction.WEST).where('5', HPCA_BRIDGE_COMPONENT, Direction.WEST).where('6', HPCA_HEAT_SINK_COMPONENT, Direction.WEST).where('7', HPCA_COMPUTATION_COMPONENT, Direction.WEST).where('8', HPCA_HEAT_SINK_COMPONENT, Direction.WEST).build());
        shapeInfo.add(((MultiblockShapeInfo.ShapeInfoBuilder)builder.shallowCopy()).where('0', HPCA_HEAT_SINK_COMPONENT, Direction.WEST).where('1', HPCA_COMPUTATION_COMPONENT, Direction.WEST).where('2', HPCA_HEAT_SINK_COMPONENT, Direction.WEST).where('3', HPCA_HEAT_SINK_COMPONENT, Direction.WEST).where('4', HPCA_ADVANCED_COMPUTATION_COMPONENT, Direction.WEST).where('5', HPCA_HEAT_SINK_COMPONENT, Direction.WEST).where('6', HPCA_HEAT_SINK_COMPONENT, Direction.WEST).where('7', HPCA_BRIDGE_COMPONENT, Direction.WEST).where('8', HPCA_HEAT_SINK_COMPONENT, Direction.WEST).build());
        shapeInfo.add(((MultiblockShapeInfo.ShapeInfoBuilder)builder.shallowCopy()).where('0', HPCA_HEAT_SINK_COMPONENT, Direction.WEST).where('1', HPCA_ADVANCED_COMPUTATION_COMPONENT, Direction.WEST).where('2', HPCA_HEAT_SINK_COMPONENT, Direction.WEST).where('3', HPCA_ACTIVE_COOLER_COMPONENT, Direction.WEST).where('4', HPCA_BRIDGE_COMPONENT, Direction.WEST).where('5', HPCA_ACTIVE_COOLER_COMPONENT, Direction.WEST).where('6', HPCA_HEAT_SINK_COMPONENT, Direction.WEST).where('7', HPCA_ADVANCED_COMPUTATION_COMPONENT, Direction.WEST).where('8', HPCA_HEAT_SINK_COMPONENT, Direction.WEST).build());
        return shapeInfo;
    }).sidedWorkableCasingRenderer("block/casings/hpca/computer_casing", GTCEu.id("block/multiblock/hpca")).register();
    public static final MachineDefinition COMPUTATION_HATCH_TRANSMITTER = GTResearchMachines.registerDataHatch("computation_transmitter_hatch", "Computation Data Transmission Hatch", 7, holder -> new OpticalComputationHatchMachine((IMachineBlockEntity)holder, true), "computation_data_hatch", PartAbility.COMPUTATION_DATA_TRANSMISSION).register();
    public static final MachineDefinition COMPUTATION_HATCH_RECEIVER = GTResearchMachines.registerDataHatch("computation_receiver_hatch", "Computation Data Reception Hatch", 7, holder -> new OpticalComputationHatchMachine((IMachineBlockEntity)holder, false), "computation_data_hatch", PartAbility.COMPUTATION_DATA_RECEPTION).register();
    public static final MachineDefinition DATA_HATCH_TRANSMITTER = GTResearchMachines.registerDataHatch("data_transmitter_hatch", "Optical Data Transmission Hatch", 6, holder -> new OpticalDataHatchMachine((IMachineBlockEntity)holder, true), "optical_data_hatch", PartAbility.OPTICAL_DATA_TRANSMISSION).register();
    public static final MachineDefinition DATA_HATCH_RECEIVER = GTResearchMachines.registerDataHatch("data_receiver_hatch", "Optical Data Reception Hatch", 6, holder -> new OpticalDataHatchMachine((IMachineBlockEntity)holder, false), "optical_data_hatch", PartAbility.OPTICAL_DATA_RECEPTION).register();
    public static final MachineDefinition DATA_ACCESS_HATCH = GTRegistration.REGISTRATE.machine("data_access_hatch", holder -> new DataAccessHatchMachine((IMachineBlockEntity)holder, 4, false)).langValue("Data Access Hatch").tier(4).rotationState(RotationState.ALL).abilities(PartAbility.DATA_ACCESS).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.data_access_hatch.tooltip.0"), Component.m_237110_((String)"gtceu.machine.data_access_hatch.tooltip.1", (Object[])new Object[]{9}), Component.m_237115_((String)"gtceu.universal.disabled")}).overlayTieredHullRenderer("data_access_hatch").register();
    public static final MachineDefinition ADVANCED_DATA_ACCESS_HATCH = GTRegistration.REGISTRATE.machine("advanced_data_access_hatch", holder -> new DataAccessHatchMachine((IMachineBlockEntity)holder, 6, false)).langValue("Advanced Data Access Hatch").tier(6).rotationState(RotationState.ALL).abilities(PartAbility.DATA_ACCESS).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.data_access_hatch.tooltip.0"), Component.m_237110_((String)"gtceu.machine.data_access_hatch.tooltip.1", (Object[])new Object[]{16}), Component.m_237115_((String)"gtceu.universal.disabled")}).overlayTieredHullRenderer("data_access_hatch").register();
    public static final MachineDefinition CREATIVE_DATA_ACCESS_HATCH = GTRegistration.REGISTRATE.machine("creative_data_access_hatch", holder -> new DataAccessHatchMachine((IMachineBlockEntity)holder, 14, true)).langValue("Creative Data Access Hatch").tier(14).rotationState(RotationState.ALL).abilities(PartAbility.DATA_ACCESS).tooltipBuilder((s, list) -> {
        list.add(Component.m_237115_((String)"gtceu.machine.data_access_hatch.tooltip.0"));
        GTMachines.CREATIVE_TOOLTIPS.accept((ItemStack)s, (List<Component>)list);
        list.add(Component.m_237115_((String)"gtceu.universal.enabled"));
    }).overlayTieredHullRenderer("data_access_hatch_creative").register();
    public static final BiConsumer<ItemStack, List<Component>> OVERHEAT_TOOLTIPS = (stack, components) -> components.add(Component.m_237115_((String)"gtceu.machine.hpca.component_type.damaged").m_130938_(style -> style.m_131140_(TooltipHelper.BLINKING_ORANGE.getCurrent())));
    public static final MachineDefinition HPCA_EMPTY_COMPONENT = GTResearchMachines.registerHPCAPart("hpca_empty_component", "Empty HPCA Component", HPCAEmptyPartMachine::new, "empty", null, null, false).register();
    public static final MachineDefinition HPCA_COMPUTATION_COMPONENT = GTResearchMachines.registerHPCAPart("hpca_computation_component", "HPCA Computation Component", holder -> new HPCAComputationPartMachine((IMachineBlockEntity)holder, false), "computation", false).tooltips(new Component[]{Component.m_237110_((String)"gtceu.machine.hpca.component_general.upkeep_eut", (Object[])new Object[]{GTValues.VA[4]}), Component.m_237110_((String)"gtceu.machine.hpca.component_general.max_eut", (Object[])new Object[]{GTValues.VA[6]}), Component.m_237110_((String)"gtceu.machine.hpca.component_type.computation_cwut", (Object[])new Object[]{4}), Component.m_237110_((String)"gtceu.machine.hpca.component_type.computation_cooling", (Object[])new Object[]{2})}).tooltipBuilder(OVERHEAT_TOOLTIPS).register();
    public static final MachineDefinition HPCA_ADVANCED_COMPUTATION_COMPONENT = GTResearchMachines.registerHPCAPart("hpca_advanced_computation_component", "HPCA Advanced Computation Component", holder -> new HPCAComputationPartMachine((IMachineBlockEntity)holder, true), "advanced_computation", true).tooltips(new Component[]{Component.m_237110_((String)"gtceu.machine.hpca.component_general.upkeep_eut", (Object[])new Object[]{GTValues.VA[5]}), Component.m_237110_((String)"gtceu.machine.hpca.component_general.max_eut", (Object[])new Object[]{GTValues.VA[7]}), Component.m_237110_((String)"gtceu.machine.hpca.component_type.computation_cwut", (Object[])new Object[]{16}), Component.m_237110_((String)"gtceu.machine.hpca.component_type.computation_cooling", (Object[])new Object[]{4})}).tooltipBuilder(OVERHEAT_TOOLTIPS).register();
    public static final MachineDefinition HPCA_HEAT_SINK_COMPONENT = GTResearchMachines.registerHPCAPart("hpca_heat_sink_component", "HPCA Heat Sink Component", holder -> new HPCACoolerPartMachine((IMachineBlockEntity)holder, false), "heat_sink", null, null, false).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.hpca.component_type.cooler_passive"), Component.m_237110_((String)"gtceu.machine.hpca.component_type.cooler_cooling", (Object[])new Object[]{1})}).register();
    public static final MachineDefinition HPCA_ACTIVE_COOLER_COMPONENT = GTResearchMachines.registerHPCAPart("hpca_active_cooler_component", "HPCA Active Cooling Component", holder -> new HPCACoolerPartMachine((IMachineBlockEntity)holder, true), "active_cooler", true).tooltips(new Component[]{Component.m_237110_((String)"gtceu.machine.hpca.component_general.max_eut", (Object[])new Object[]{GTValues.VA[5]}), Component.m_237115_((String)"gtceu.machine.hpca.component_type.cooler_active"), Component.m_237110_((String)"gtceu.machine.hpca.component_type.cooler_active_coolant", (Object[])new Object[]{8, GTMaterials.PCBCoolant.getLocalizedName()}), Component.m_237110_((String)"gtceu.machine.hpca.component_type.cooler_cooling", (Object[])new Object[]{2})}).register();
    public static final MachineDefinition HPCA_BRIDGE_COMPONENT = GTResearchMachines.registerHPCAPart("hpca_bridge_component", "HPCA Bridge Component", HPCABridgePartMachine::new, "bridge", false).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.hpca.component_type.bridge"), Component.m_237110_((String)"gtceu.machine.hpca.component_general.max_eut", (Object[])new Object[]{GTValues.VA[5]})}).register();

    @NotNull
    private static MachineBuilder<MachineDefinition> registerDataHatch(String name, String displayName, int tier, Function<IMachineBlockEntity, MetaMachine> constructor, String model, PartAbility ... abilities) {
        return GTRegistration.REGISTRATE.machine(name, constructor).langValue(displayName).tier(tier).rotationState(RotationState.ALL).abilities(abilities).overlayTieredHullRenderer(model);
    }

    private static MachineBuilder<MachineDefinition> registerHPCAPart(String name, String displayName, Function<IMachineBlockEntity, MetaMachine> constructor, String texture, boolean isAdvanced) {
        return GTRegistration.REGISTRATE.machine(name, constructor).langValue(displayName).rotationState(RotationState.ALL).abilities(PartAbility.HPCA_COMPONENT).renderer(() -> new HPCAPartRenderer(isAdvanced, GTCEu.id("block/overlay/machine/hpca/" + texture), GTCEu.id("block/overlay/machine/hpca/" + (isAdvanced ? "damaged_advanced" : "damaged"))));
    }

    private static MachineBuilder<MachineDefinition> registerHPCAPart(String name, String displayName, Function<IMachineBlockEntity, MetaMachine> constructor, String texture, @Nullable String activeTexture, @Nullable String damagedTexture, boolean isAdvanced) {
        return GTRegistration.REGISTRATE.machine(name, constructor).langValue(displayName).rotationState(RotationState.ALL).abilities(PartAbility.HPCA_COMPONENT).renderer(() -> new HPCAPartRenderer(isAdvanced, GTCEu.id("block/overlay/machine/hpca/" + texture), activeTexture == null ? null : GTCEu.id("block/overlay/machine/hpca/" + activeTexture), activeTexture == null ? null : GTCEu.id("block/overlay/machine/hpca/" + activeTexture + "_emissive"), damagedTexture == null ? null : GTCEu.id("block/overlay/machine/hpca/" + damagedTexture), damagedTexture == null ? null : GTCEu.id("block/overlay/machine/hpca/" + damagedTexture + "_active"), damagedTexture == null ? null : GTCEu.id("block/overlay/machine/hpca/" + damagedTexture + "_emissive")));
    }

    public static void init() {
    }
}

