/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data;

import com.google.common.collect.ArrayTable;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ToolProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.registry.MaterialRegistry;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.TagPrefixItem;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.MaterialToolTier;
import com.gregtechceu.gtceu.api.registry.registrate.GTRegistrate;
import com.gregtechceu.gtceu.common.data.GTCreativeModeTabs;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.registry.GTRegistration;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class GTMaterialItems {
    static ImmutableTable.Builder<TagPrefix, Material, ItemEntry<TagPrefixItem>> MATERIAL_ITEMS_BUILDER = ImmutableTable.builder();
    public static final Map<UnificationEntry, Supplier<? extends ItemLike>> toUnify = new HashMap<UnificationEntry, Supplier<? extends ItemLike>>();
    public static final Map<TagPrefix, TagPrefix> purifyMap = new HashMap<TagPrefix, TagPrefix>();
    public static Table<TagPrefix, Material, ItemEntry<TagPrefixItem>> MATERIAL_ITEMS;
    public static final Table<Material, GTToolType, ItemProviderEntry<IGTTool>> TOOL_ITEMS;

    public static void generateMaterialItems() {
        GTRegistration.REGISTRATE.creativeModeTab(() -> GTCreativeModeTabs.MATERIAL_ITEM);
        for (TagPrefix tagPrefix : TagPrefix.values()) {
            if (!tagPrefix.doGenerateItem()) continue;
            for (MaterialRegistry registry : GTCEuAPI.materialManager.getRegistries()) {
                GTRegistrate registrate = registry.getRegistrate();
                for (Material material : registry.getAllMaterials()) {
                    if (!tagPrefix.doGenerateItem(material)) continue;
                    GTMaterialItems.generateMaterialItem(tagPrefix, material, registrate);
                }
            }
        }
        MATERIAL_ITEMS = MATERIAL_ITEMS_BUILDER.build();
    }

    private static void generateMaterialItem(TagPrefix tagPrefix, Material material, GTRegistrate registrate) {
        MATERIAL_ITEMS_BUILDER.put((Object)tagPrefix, (Object)material, (Object)((ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)registrate.item(tagPrefix.idPattern().formatted(material.getName()), properties -> new TagPrefixItem((Item.Properties)properties, tagPrefix, material)).onRegister(TagPrefixItem::onRegister)).setData(ProviderType.LANG, NonNullBiConsumer.noop())).transform(GTItems.unificationItem(tagPrefix, material))).properties(p -> p.m_41487_(tagPrefix.maxStackSize())).model(NonNullBiConsumer.noop()).color(() -> TagPrefixItem::tintColor).onRegister(GTItems::cauldronInteraction)).register());
    }

    public static void generateTools() {
        GTRegistration.REGISTRATE.creativeModeTab(() -> GTCreativeModeTabs.TOOL);
        for (GTToolType toolType : GTToolType.getTypes().values()) {
            for (MaterialRegistry registry : GTCEuAPI.materialManager.getRegistries()) {
                GTRegistrate registrate = registry.getRegistrate();
                for (Material material : registry.getAllMaterials()) {
                    ToolProperty property;
                    if (!material.hasProperty(PropertyKey.TOOL) || !(property = material.getProperty(PropertyKey.TOOL)).hasType(toolType)) continue;
                    GTMaterialItems.generateTool(material, toolType, registrate);
                }
            }
        }
    }

    private static void generateTool(Material material, GTToolType toolType, GTRegistrate registrate) {
        MaterialToolTier tier = material.getToolTier();
        TOOL_ITEMS.put((Object)material, (Object)toolType, (Object)((ItemBuilder)registrate.item(toolType.idFormat.formatted(tier.material.getName()), p -> toolType.constructor.apply(toolType, tier, material, toolType.toolDefinition, (Item.Properties)p).m_5456_()).properties(p -> p.m_41495_(Items.f_41852_)).setData(ProviderType.LANG, NonNullBiConsumer.noop())).model(NonNullBiConsumer.noop()).color(() -> IGTTool::tintColor).register());
    }

    static {
        purifyMap.put(TagPrefix.crushed, TagPrefix.crushedPurified);
        purifyMap.put(TagPrefix.dustImpure, TagPrefix.dust);
        purifyMap.put(TagPrefix.dustPure, TagPrefix.dust);
        TOOL_ITEMS = ArrayTable.create(GTCEuAPI.materialManager.getRegisteredMaterials().stream().filter(mat -> mat.hasProperty(PropertyKey.TOOL)).toList(), GTToolType.getTypes().values().stream().toList());
    }
}

