/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover.voiding;

import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.cover.IUICover;
import com.gregtechceu.gtceu.api.cover.filter.ItemFilter;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.common.cover.ConveyorCover;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ItemVoidingCover
extends ConveyorCover
implements IUICover,
IControllable {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ItemVoidingCover.class, ConveyorCover.MANAGED_FIELD_HOLDER);

    public ItemVoidingCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        super(definition, coverHolder, attachedSide, 0);
        this.setWorkingEnabled(false);
    }

    @Override
    protected boolean isSubscriptionActive() {
        return this.isWorkingEnabled();
    }

    @Override
    protected void update() {
        if (this.coverHolder.getOffsetTimer() % 5L != 0L) {
            return;
        }
        this.doVoidItems();
        this.subscriptionHandler.updateSubscription();
    }

    protected void doVoidItems() {
        IItemHandlerModifiable handler = this.getOwnItemHandler();
        if (handler == null) {
            return;
        }
        this.voidAny((IItemHandler)handler);
    }

    void voidAny(IItemHandler handler) {
        ItemFilter filter = (ItemFilter)this.filterHandler.getFilter();
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            ItemStack sourceStack = handler.extractItem(slot, Integer.MAX_VALUE, true);
            if (sourceStack.m_41619_() || !filter.test(sourceStack)) continue;
            handler.extractItem(slot, Integer.MAX_VALUE, false);
        }
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 176, 120);
        group.addWidget((Widget)new LabelWidget(10, 5, this.getUITitle()));
        group.addWidget((Widget)new ToggleButtonWidget(10, 20, 20, 20, (IGuiTexture)GuiTextures.BUTTON_POWER, this::isWorkingEnabled, this::setWorkingEnabled));
        group.addWidget(this.filterHandler.createFilterSlotUI(148, 91));
        group.addWidget(this.filterHandler.createFilterConfigUI(10, 50, 126, 60));
        this.buildAdditionalUI(group);
        return group;
    }

    @Override
    @NotNull
    protected String getUITitle() {
        return "cover.item.voiding.title";
    }

    @Override
    public InteractionResult onSoftMalletClick(Player playerIn, InteractionHand hand, BlockHitResult hitResult) {
        if (!this.isRemote()) {
            this.setWorkingEnabled(!this.isWorkingEnabled);
            playerIn.m_213846_((Component)Component.m_237115_((String)(this.isWorkingEnabled() ? "cover.voiding.message.enabled" : "cover.voiding.message.disabled")));
        }
        playerIn.m_6674_(hand);
        return InteractionResult.CONSUME;
    }

    @Override
    public boolean shouldRenderGrid(Player player, BlockPos pos, BlockState state, ItemStack held, Set<GTToolType> toolTypes) {
        return super.shouldRenderGrid(player, pos, state, held, toolTypes);
    }

    @Override
    public ResourceTexture sideTips(Player player, BlockPos pos, BlockState state, Set<GTToolType> toolTypes, Direction side) {
        ResourceTexture superTips = super.sideTips(player, pos, state, toolTypes, side);
        if (superTips != null) {
            return superTips;
        }
        if (toolTypes.contains(GTToolType.SOFT_MALLET)) {
            return this.isWorkingEnabled() ? GuiTextures.TOOL_START : GuiTextures.TOOL_PAUSE;
        }
        return null;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }
}

