/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.cover.IUICover;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.machine.MachineCoverContainer;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageCover
extends CoverBehavior
implements IUICover {
    @Persisted
    @DescSynced
    public final CustomItemStackHandler inventory = new CustomItemStackHandler(18){

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private final int SIZE = 18;
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(StorageCover.class, CoverBehavior.MANAGED_FIELD_HOLDER);

    public StorageCover(@NotNull CoverDefinition definition, @NotNull ICoverable coverableView, @NotNull Direction attachedSide) {
        super(definition, coverableView, attachedSide);
    }

    @Override
    @NotNull
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    @NotNull
    public List<ItemStack> getAdditionalDrops() {
        List<ItemStack> list = super.getAdditionalDrops();
        for (int slot = 0; slot < 18; ++slot) {
            list.add(this.inventory.getStackInSlot(slot));
        }
        return list;
    }

    @Override
    public boolean canAttach() {
        if (!(this.coverHolder instanceof MachineCoverContainer)) {
            return false;
        }
        for (Direction dir : Direction.values()) {
            if (!this.coverHolder.hasCover(dir) || !(this.coverHolder.getCoverAtSide(dir) instanceof StorageCover)) continue;
            return false;
        }
        return super.canAttach();
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 126, 87);
        group.addWidget((Widget)new LabelWidget(10, 5, LocalizationUtils.format((String)this.getUITitle(), (Object[])new Object[0])));
        for (int slot = 0; slot < 18; ++slot) {
            group.addWidget((Widget)new SlotWidget((IItemHandlerModifiable)this.inventory, slot, 7 + slot % 6 * 18, 21 + slot / 6 * 18));
        }
        return group;
    }

    private String getUITitle() {
        return "cover.storage.title";
    }

    @Override
    @Nullable
    public IFancyConfigurator getConfigurator() {
        return new StorageCoverConfigurator();
    }

    private class StorageCoverConfigurator
    implements IFancyConfigurator {
        private StorageCoverConfigurator() {
        }

        @Override
        public Component getTitle() {
            return Component.m_237115_((String)"cover.storage.title");
        }

        @Override
        public IGuiTexture getIcon() {
            return GuiTextures.MAINTENANCE_ICON;
        }

        @Override
        public Widget createConfigurator() {
            WidgetGroup group = new WidgetGroup(0, 0, 126, 87);
            for (int slot = 0; slot < 18; ++slot) {
                group.addWidget((Widget)new SlotWidget((IItemHandlerModifiable)StorageCover.this.inventory, slot, 7 + slot % 6 * 18, 21 + slot / 6 * 18));
            }
            return group;
        }
    }
}

