/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.cover.IUICover;
import com.gregtechceu.gtceu.api.cover.filter.FluidFilter;
import com.gregtechceu.gtceu.api.gui.widget.EnumSelectorWidget;
import com.gregtechceu.gtceu.api.transfer.fluid.FluidHandlerDelegate;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.common.cover.data.FilterMode;
import com.gregtechceu.gtceu.common.cover.data.ManualIOMode;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FluidFilterCover
extends CoverBehavior
implements IUICover {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(FluidFilterCover.class, CoverBehavior.MANAGED_FIELD_HOLDER);
    protected FluidFilter fluidFilter;
    @Persisted
    @DescSynced
    protected FilterMode filterMode = FilterMode.FILTER_INSERT;
    private FilteredFluidHandlerWrapper fluidFilterWrapper;
    protected ManualIOMode allowFlow = ManualIOMode.DISABLED;

    public FluidFilterCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        super(definition, coverHolder, attachedSide);
    }

    public void setFilterMode(FilterMode filterMode) {
        this.filterMode = filterMode;
        this.coverHolder.markDirty();
    }

    @Override
    public boolean canAttach() {
        return this.coverHolder.getFluidHandlerCap(this.attachedSide, false) != null;
    }

    public FluidFilter getFluidFilter() {
        if (this.fluidFilter == null) {
            this.fluidFilter = FluidFilter.loadFilter(this.attachItem);
        }
        return this.fluidFilter;
    }

    @Override
    @Nullable
    public IFluidHandlerModifiable getFluidHandlerCap(@Nullable IFluidHandlerModifiable defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        if (this.fluidFilterWrapper == null || this.fluidFilterWrapper.delegate != defaultValue) {
            this.fluidFilterWrapper = new FilteredFluidHandlerWrapper(defaultValue);
        }
        return this.fluidFilterWrapper;
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 178, 85);
        group.addWidget((Widget)new LabelWidget(60, 5, this.attachItem.m_41778_()));
        group.addWidget((Widget)new EnumSelectorWidget(35, 25, 18, 18, (Enum[])FilterMode.VALUES, (Enum)this.filterMode, this::setFilterMode));
        group.addWidget((Widget)new EnumSelectorWidget(35, 45, 18, 18, (Enum[])ManualIOMode.VALUES, (Enum)this.allowFlow, this::setAllowFlow));
        group.addWidget((Widget)this.getFluidFilter().openConfigurator(62, 25));
        return group;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public FilterMode getFilterMode() {
        return this.filterMode;
    }

    public void setAllowFlow(ManualIOMode allowFlow) {
        this.allowFlow = allowFlow;
    }

    public ManualIOMode getAllowFlow() {
        return this.allowFlow;
    }

    private class FilteredFluidHandlerWrapper
    extends FluidHandlerDelegate {
        public FilteredFluidHandlerWrapper(IFluidHandlerModifiable delegate) {
            super(delegate);
        }

        @Override
        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (FluidFilterCover.this.filterMode == FilterMode.FILTER_EXTRACT && FluidFilterCover.this.allowFlow == ManualIOMode.UNFILTERED) {
                return super.fill(resource, action);
            }
            if (FluidFilterCover.this.filterMode != FilterMode.FILTER_EXTRACT && FluidFilterCover.this.getFluidFilter().test(resource)) {
                return super.fill(resource, action);
            }
            return 0;
        }

        @Override
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (FluidFilterCover.this.filterMode == FilterMode.FILTER_INSERT && FluidFilterCover.this.allowFlow == ManualIOMode.UNFILTERED) {
                return super.drain(resource, action);
            }
            if (FluidFilterCover.this.filterMode != FilterMode.FILTER_INSERT && FluidFilterCover.this.getFluidFilter().test(resource)) {
                return super.drain(resource, action);
            }
            return FluidStack.EMPTY;
        }
    }
}

