/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.block;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.item.SurfaceRockBlockItem;
import com.gregtechceu.gtceu.client.renderer.block.SurfaceRockRenderer;
import com.gregtechceu.gtceu.integration.map.cache.server.ServerCache;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SurfaceRockBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final VoxelShape AABB_NORTH = Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)3.0);
    private static final VoxelShape AABB_SOUTH = Block.m_49796_((double)2.0, (double)2.0, (double)13.0, (double)14.0, (double)14.0, (double)16.0);
    private static final VoxelShape AABB_WEST = Block.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)3.0, (double)14.0, (double)14.0);
    private static final VoxelShape AABB_EAST = Block.m_49796_((double)13.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
    private static final VoxelShape AABB_UP = Block.m_49796_((double)2.0, (double)13.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape AABB_DOWN = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0);
    private final Material material;

    public SurfaceRockBlock(BlockBehaviour.Properties properties, Material material) {
        super(properties);
        this.material = material;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.DOWN));
        if (GTCEu.isClientSide()) {
            SurfaceRockRenderer.create(this);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!level.f_46443_) {
            ServerCache.instance.prospectSurfaceRockMaterial((ResourceKey<Level>)level.m_46472_(), this.material, pos, (ServerPlayer)player);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_) {
            ServerCache.instance.prospectSurfaceRockMaterial((ResourceKey<Level>)level.m_46472_(), this.material, pos, (ServerPlayer)player);
        }
        if (level.m_46953_(pos, true, (Entity)player)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> AABB_DOWN;
            case Direction.UP -> AABB_UP;
            case Direction.NORTH -> AABB_NORTH;
            case Direction.SOUTH -> AABB_SOUTH;
            case Direction.WEST -> AABB_WEST;
            case Direction.EAST -> AABB_EAST;
        };
    }

    public boolean m_180643_(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public boolean m_222958_(BlockState state, BlockGetter view, BlockPos pos) {
        return false;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos attachedBlock = pos.m_121945_(facing);
        return level.m_8055_(attachedBlock).m_60783_((BlockGetter)level, attachedBlock, facing.m_122424_());
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        super.m_6861_(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            Block.m_49902_((BlockState)state, (BlockState)Blocks.f_50016_.m_49966_(), (LevelAccessor)level, (BlockPos)pos, (int)3);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getStateForDirection(context.m_151260_());
    }

    public BlockState getStateForDirection(Direction direction) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static BlockColor tintedBlockColor() {
        return (state, reader, pos, tintIndex) -> {
            Block patt6139$temp = state.m_60734_();
            if (patt6139$temp instanceof SurfaceRockBlock) {
                SurfaceRockBlock block = (SurfaceRockBlock)patt6139$temp;
                return block.material.getMaterialRGB();
            }
            return -1;
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ItemColor tintedItemColor() {
        return (stack, tintIndex) -> {
            Item patt6431$temp = stack.m_41720_();
            if (patt6431$temp instanceof SurfaceRockBlockItem) {
                SurfaceRockBlockItem surfaceRock = (SurfaceRockBlockItem)patt6431$temp;
                return surfaceRock.getMat().getMaterialRGB();
            }
            return -1;
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    public String m_7705_() {
        return "block.surface_rock";
    }

    public MutableComponent m_49954_() {
        return Component.m_237110_((String)"block.surface_rock", (Object[])new Object[]{this.material.getLocalizedName()});
    }

    public Material getMaterial() {
        return this.material;
    }
}

