/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine.gcym;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.client.renderer.block.FluidBlockRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableCasingMachineRenderer;
import com.gregtechceu.gtceu.client.util.RenderUtil;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.gcym.LargeMixerMachine;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.RenderTypeHelper;
import org.joml.Matrix4f;

public class LargeMixerRenderer
extends WorkableCasingMachineRenderer {
    private final FluidBlockRenderer fluidBlockRenderer = FluidBlockRenderer.Builder.create().setFaceOffset(-0.125f).setForcedLight(0xF000F0).getRenderer();
    private Fluid cachedFluid;
    private ResourceLocation cachedRecipe;

    public LargeMixerRenderer(ResourceLocation baseCasing, ResourceLocation workableModel) {
        super(baseCasing, workableModel);
    }

    public int getViewDistance() {
        return 32;
    }

    public boolean isGlobalRenderer(BlockEntity blockEntity) {
        return true;
    }

    public boolean hasTESR(BlockEntity blockEntity) {
        return true;
    }

    public void render(BlockEntity blockEntity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        super.render(blockEntity, partialTicks, stack, buffer, combinedLight, combinedOverlay);
        if (!ConfigHolder.INSTANCE.client.renderer.renderFluids) {
            return;
        }
        if (blockEntity instanceof MetaMachineBlockEntity) {
            MetaMachineBlockEntity mm = (MetaMachineBlockEntity)blockEntity;
            MetaMachine metaMachine = mm.metaMachine;
            if (metaMachine instanceof LargeMixerMachine) {
                LargeMixerMachine lm = (LargeMixerMachine)metaMachine;
                GTRecipe lastRecipe = lm.recipeLogic.getLastRecipe();
                if (lastRecipe == null) {
                    this.cachedRecipe = null;
                    this.cachedFluid = null;
                } else if (lm.getOffsetTimer() % 20L == 0L || lastRecipe.id != this.cachedRecipe) {
                    this.cachedRecipe = lastRecipe.id;
                    this.cachedFluid = lm.isActive() ? RenderUtil.getRecipeFluidToRender(lastRecipe) : null;
                }
                if (this.cachedFluid == null) {
                    return;
                }
                stack.m_85836_();
                Matrix4f pose = stack.m_85850_().m_252922_();
                RenderType fluidRenderType = ItemBlockRenderTypes.m_109287_((FluidState)this.cachedFluid.m_76145_());
                VertexConsumer consumer = buffer.m_6299_(RenderTypeHelper.getEntityRenderType((RenderType)fluidRenderType, (boolean)false));
                Direction up = RelativeDirection.UP.getRelativeFacing(lm.getFrontFacing(), lm.getUpwardsFacing(), lm.isFlipped());
                if (up != Direction.UP && up != Direction.DOWN) {
                    up = up.m_122424_();
                }
                this.fluidBlockRenderer.drawPlane(up, lm.getFluidBlockOffsets(), pose, consumer, this.cachedFluid, RenderUtil.FluidTextureType.STILL, combinedOverlay, lm.getPos());
                stack.m_85849_();
            }
        }
    }
}

