/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine.gcym;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.client.renderer.block.FluidBlockRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableCasingMachineRenderer;
import com.gregtechceu.gtceu.client.util.RenderUtil;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.gcym.LargeChemicalBathMachine;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.RenderTypeHelper;
import org.joml.Matrix4f;

public class LargeChemicalBathRenderer
extends WorkableCasingMachineRenderer {
    private final FluidBlockRenderer fluidBlockRenderer = FluidBlockRenderer.Builder.create().setFaceOffset(-0.125f).setForcedLight(0xF000F0).getRenderer();
    private Fluid cachedFluid;
    private ResourceLocation cachedRecipe;

    public LargeChemicalBathRenderer(ResourceLocation baseCasing, ResourceLocation workableModel) {
        super(baseCasing, workableModel);
    }

    public int getViewDistance() {
        return 32;
    }

    public boolean isGlobalRenderer(BlockEntity blockEntity) {
        return true;
    }

    public boolean hasTESR(BlockEntity blockEntity) {
        return true;
    }

    public void render(BlockEntity blockEntity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        super.render(blockEntity, partialTicks, stack, buffer, combinedLight, combinedOverlay);
        if (!ConfigHolder.INSTANCE.client.renderer.renderFluids) {
            return;
        }
        if (blockEntity instanceof MetaMachineBlockEntity) {
            MetaMachineBlockEntity mm = (MetaMachineBlockEntity)blockEntity;
            MetaMachine metaMachine = mm.metaMachine;
            if (metaMachine instanceof LargeChemicalBathMachine) {
                LargeChemicalBathMachine lcb = (LargeChemicalBathMachine)metaMachine;
                GTRecipe lastRecipe = lcb.recipeLogic.getLastRecipe();
                if (lastRecipe == null) {
                    this.cachedRecipe = null;
                    this.cachedFluid = null;
                } else if (lcb.getOffsetTimer() % 20L == 0L || lastRecipe.id != this.cachedRecipe) {
                    this.cachedRecipe = lastRecipe.id;
                    this.cachedFluid = lcb.isActive() ? RenderUtil.getRecipeFluidToRender(lastRecipe) : null;
                }
                if (this.cachedFluid == null) {
                    return;
                }
                stack.m_85836_();
                Matrix4f pose = stack.m_85850_().m_252922_();
                RenderType fluidRenderType = ItemBlockRenderTypes.m_109287_((FluidState)this.cachedFluid.m_76145_());
                VertexConsumer consumer = buffer.m_6299_(RenderTypeHelper.getEntityRenderType((RenderType)fluidRenderType, (boolean)false));
                Direction up = RelativeDirection.UP.getRelativeFacing(lcb.getFrontFacing(), lcb.getUpwardsFacing(), lcb.isFlipped());
                if (up.m_122434_() != Direction.Axis.Y) {
                    up = up.m_122424_();
                }
                this.fluidBlockRenderer.drawPlane(up, lcb.getFluidBlockOffsets(), pose, consumer, this.cachedFluid, RenderUtil.FluidTextureType.STILL, combinedOverlay, lcb.getPos());
                stack.m_85849_();
            }
        }
    }
}

