/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.client.renderer.block.FluidBlockRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableCasingMachineRenderer;
import com.gregtechceu.gtceu.client.util.RenderUtil;
import com.gregtechceu.gtceu.common.machine.multiblock.primitive.PrimitiveBlastFurnaceMachine;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.RenderTypeHelper;
import org.joml.Matrix4f;

public class PrimitiveBlastFurnaceRenderer
extends WorkableCasingMachineRenderer {
    private final FluidBlockRenderer fluidBlockRenderer = FluidBlockRenderer.Builder.create().setFaceOffset(-0.125f).setForcedLight(0xF000F0).getRenderer();

    public PrimitiveBlastFurnaceRenderer(ResourceLocation base, ResourceLocation overlay) {
        super(base, overlay);
    }

    public boolean hasTESR(BlockEntity blockEntity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(BlockEntity blockEntity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        super.render(blockEntity, partialTicks, stack, buffer, combinedLight, combinedOverlay);
        if (!ConfigHolder.INSTANCE.client.renderer.renderFluids) {
            return;
        }
        if (blockEntity instanceof MetaMachineBlockEntity) {
            PrimitiveBlastFurnaceMachine pbf;
            MetaMachineBlockEntity mm = (MetaMachineBlockEntity)blockEntity;
            MetaMachine metaMachine = mm.metaMachine;
            if (metaMachine instanceof PrimitiveBlastFurnaceMachine && (pbf = (PrimitiveBlastFurnaceMachine)metaMachine).isFormed()) {
                Direction opposite = pbf.getFrontFacing().m_122424_();
                RenderType lavaRenderType = ItemBlockRenderTypes.m_109287_((FluidState)Fluids.f_76195_.m_76145_());
                stack.m_85836_();
                Matrix4f pose = stack.m_85850_().m_252922_();
                pose.translate((float)opposite.m_122429_(), (float)opposite.m_122430_(), (float)opposite.m_122431_());
                VertexConsumer consumer = buffer.m_6299_(RenderTypeHelper.getEntityRenderType((RenderType)lavaRenderType, (boolean)true));
                Direction up = RelativeDirection.UP.getRelativeFacing(pbf.getFrontFacing(), pbf.getUpwardsFacing(), pbf.isFlipped());
                if (up != Direction.UP && up != Direction.DOWN) {
                    up = up.m_122424_();
                }
                this.fluidBlockRenderer.drawFace(up, pose, consumer, Fluids.f_76195_.m_5613_(), RenderUtil.FluidTextureType.STILL, combinedOverlay, combinedLight);
                stack.m_85849_();
            }
        }
    }
}

