/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.block;

import com.gregtechceu.gtceu.client.util.RenderUtil;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class FluidBlockRenderer {
    private final Properties properties;

    protected FluidBlockRenderer(Properties properties) {
        this.properties = properties;
    }

    public Vector3f[] transformVertices(Vector3f[] vertices, Direction face) {
        Vector3f[] newVertices = new Vector3f[4];
        float offsetX = this.properties.offsetX;
        float offsetY = this.properties.offsetY;
        float offsetZ = this.properties.offsetZ;
        switch (face) {
            case DOWN: 
            case UP: {
                offsetY += this.properties.offsetFace;
                break;
            }
            case NORTH: 
            case SOUTH: {
                offsetZ += this.properties.offsetFace;
                break;
            }
            case WEST: 
            case EAST: {
                offsetX += this.properties.offsetFace;
            }
        }
        for (int i = 0; i < 4; ++i) {
            newVertices[i] = RenderUtil.transformVertex(vertices[i], face, offsetX, offsetY, offsetZ);
        }
        return newVertices;
    }

    public void drawBlocks(Set<BlockPos> offsets, Matrix4f pose, VertexConsumer consumer, Fluid fluid, RenderUtil.FluidTextureType texture, int combinedOverlay, int combinedLight) {
        IClientFluidTypeExtensions fluidClientInfo = IClientFluidTypeExtensions.of((Fluid)fluid);
        TextureAtlasSprite sprite = texture.map(fluidClientInfo);
        float u0 = sprite.m_118409_();
        float v0 = sprite.m_118411_();
        float u1 = sprite.m_118410_();
        float v1 = sprite.m_118412_();
        int color = fluidClientInfo.getTintColor();
        int r = FastColor.ARGB32.m_13665_((int)color);
        int g = FastColor.ARGB32.m_13667_((int)color);
        int b = FastColor.ARGB32.m_13669_((int)color);
        int a = FastColor.ARGB32.m_13655_((int)color);
        for (BlockPos pos : offsets) {
            pose.translate((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
            for (Direction direction : Direction.values()) {
                if (offsets.contains(pos.m_121945_(direction))) continue;
                if (direction != Direction.UP && direction != Direction.DOWN) {
                    direction = direction.m_122424_();
                }
                this.drawFace(pose, consumer, this.transformVertices(RenderUtil.getVertices(direction), direction), RenderUtil.getNormal(direction), u0, u1, v0, v1, r, g, b, a, combinedOverlay, combinedLight);
            }
            pose.translate((float)(-pos.m_123341_()), (float)(-pos.m_123342_()), (float)(-pos.m_123343_()));
        }
    }

    public void drawPlanes(Direction[] faces, Map<Direction, Collection<BlockPos>> directionalOffsets, Matrix4f pose, VertexConsumer consumer, Fluid fluid, RenderUtil.FluidTextureType texture, int combinedOverlay, int combinedLight) {
        for (Direction face : faces) {
            if (!directionalOffsets.containsKey(face)) continue;
            this.drawPlane(face, directionalOffsets.get(face), pose, consumer, fluid, texture, combinedOverlay, combinedLight);
        }
    }

    public void drawPlane(Direction face, Collection<BlockPos> offsets, Matrix4f pose, VertexConsumer consumer, Fluid fluid, RenderUtil.FluidTextureType texture, int combinedOverlay, BlockPos origin) {
        IClientFluidTypeExtensions fluidClientInfo = IClientFluidTypeExtensions.of((Fluid)fluid);
        TextureAtlasSprite sprite = texture.map(fluidClientInfo);
        float u0 = sprite.m_118409_();
        float v0 = sprite.m_118411_();
        float u1 = sprite.m_118410_();
        float v1 = sprite.m_118412_();
        int color = fluidClientInfo.getTintColor();
        int r = FastColor.ARGB32.m_13665_((int)color);
        int g = FastColor.ARGB32.m_13667_((int)color);
        int b = FastColor.ARGB32.m_13669_((int)color);
        int a = FastColor.ARGB32.m_13655_((int)color);
        Vector3f normal = RenderUtil.getNormal(face);
        Vector3f[] vertices = this.transformVertices(RenderUtil.getVertices(face), face);
        BlockPos prevOffset = null;
        for (BlockPos offset : offsets) {
            BlockPos currOffset = prevOffset == null ? offset : offset.m_121996_(prevOffset);
            pose.translate((float)currOffset.m_123341_(), (float)currOffset.m_123342_(), (float)currOffset.m_123343_());
            this.drawFace(pose, consumer, vertices, normal, u0, u1, v0, v1, r, g, b, a, combinedOverlay, RenderUtil.getFluidLight(fluid, origin.m_121955_((Vec3i)currOffset)));
            prevOffset = offset;
        }
    }

    public void drawPlane(Direction face, Collection<BlockPos> offsets, Matrix4f pose, VertexConsumer consumer, Fluid fluid, RenderUtil.FluidTextureType texture, int combinedOverlay, int combinedLight) {
        IClientFluidTypeExtensions fluidClientInfo = IClientFluidTypeExtensions.of((Fluid)fluid);
        TextureAtlasSprite sprite = texture.map(fluidClientInfo);
        float u0 = sprite.m_118409_();
        float v0 = sprite.m_118411_();
        float u1 = sprite.m_118410_();
        float v1 = sprite.m_118412_();
        int color = fluidClientInfo.getTintColor();
        int r = FastColor.ARGB32.m_13665_((int)color);
        int g = FastColor.ARGB32.m_13667_((int)color);
        int b = FastColor.ARGB32.m_13669_((int)color);
        int a = FastColor.ARGB32.m_13655_((int)color);
        Vector3f normal = RenderUtil.getNormal(face);
        Vector3f[] vertices = this.transformVertices(RenderUtil.getVertices(face), face);
        BlockPos prevOffset = null;
        for (BlockPos offset : offsets) {
            BlockPos currOffset = prevOffset == null ? offset : offset.m_121996_(prevOffset);
            pose.translate((float)currOffset.m_123341_(), (float)currOffset.m_123342_(), (float)currOffset.m_123343_());
            this.drawFace(pose, consumer, vertices, normal, u0, u1, v0, v1, r, g, b, a, combinedOverlay, combinedLight);
            prevOffset = offset;
        }
    }

    public void drawFace(Direction face, Matrix4f pose, VertexConsumer consumer, Fluid fluid, RenderUtil.FluidTextureType texture, int combinedOverlay, int combinedLight) {
        IClientFluidTypeExtensions fluidClientInfo = IClientFluidTypeExtensions.of((Fluid)fluid);
        TextureAtlasSprite sprite = texture.map(fluidClientInfo);
        float u0 = sprite.m_118409_();
        float v0 = sprite.m_118411_();
        float u1 = sprite.m_118410_();
        float v1 = sprite.m_118412_();
        int color = fluidClientInfo.getTintColor();
        int r = FastColor.ARGB32.m_13665_((int)color);
        int g = FastColor.ARGB32.m_13667_((int)color);
        int b = FastColor.ARGB32.m_13669_((int)color);
        int a = FastColor.ARGB32.m_13655_((int)color);
        Vector3f normal = RenderUtil.getNormal(face);
        Vector3f[] vertices = this.transformVertices(RenderUtil.getVertices(face), face);
        this.drawFace(pose, consumer, vertices, normal, u0, u1, v0, v1, r, g, b, a, combinedOverlay, combinedLight);
    }

    public void drawFace(Matrix4f pose, VertexConsumer consumer, Vector3f[] vertices, Vector3f normal, float u0, float u1, float v0, float v1, int r, int g, int b, int a, int combinedOverlay, int combinedLight) {
        if (this.properties.isOverwriteLight()) {
            combinedLight = this.properties.getLight();
        }
        Vector3f vert = vertices[0];
        RenderUtil.vertex(pose, consumer, vert.x, vert.y, vert.z, r, g, b, a, u0, v1, combinedOverlay, combinedLight, normal.x, normal.y, normal.z);
        vert = vertices[1];
        RenderUtil.vertex(pose, consumer, vert.x, vert.y, vert.z, r, g, b, a, u0, v0, combinedOverlay, combinedLight, normal.x, normal.y, normal.z);
        vert = vertices[2];
        RenderUtil.vertex(pose, consumer, vert.x, vert.y, vert.z, r, g, b, a, u1, v0, combinedOverlay, combinedLight, normal.x, normal.y, normal.z);
        vert = vertices[3];
        RenderUtil.vertex(pose, consumer, vert.x, vert.y, vert.z, r, g, b, a, u1, v1, combinedOverlay, combinedLight, normal.x, normal.y, normal.z);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public static class Properties {
        private float offsetX = 0.0f;
        private float offsetY = 0.0f;
        private float offsetZ = 0.0f;
        private float offsetFace = 0.0f;
        private boolean overwriteLight = false;
        private int light = 0;
        private Direction[] drawFaces = Direction.values();

        public float getOffsetX() {
            return this.offsetX;
        }

        public float getOffsetY() {
            return this.offsetY;
        }

        public float getOffsetZ() {
            return this.offsetZ;
        }

        public float getOffsetFace() {
            return this.offsetFace;
        }

        public boolean isOverwriteLight() {
            return this.overwriteLight;
        }

        public int getLight() {
            return this.light;
        }

        public Direction[] getDrawFaces() {
            return this.drawFaces;
        }

        public void setOffsetX(float offsetX) {
            this.offsetX = offsetX;
        }

        public void setOffsetY(float offsetY) {
            this.offsetY = offsetY;
        }

        public void setOffsetZ(float offsetZ) {
            this.offsetZ = offsetZ;
        }

        public void setOffsetFace(float offsetFace) {
            this.offsetFace = offsetFace;
        }

        public void setOverwriteLight(boolean overwriteLight) {
            this.overwriteLight = overwriteLight;
        }

        public void setLight(int light) {
            this.light = light;
        }

        public void setDrawFaces(Direction[] drawFaces) {
            this.drawFaces = drawFaces;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Properties)) {
                return false;
            }
            Properties other = (Properties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Float.compare(this.getOffsetX(), other.getOffsetX()) != 0) {
                return false;
            }
            if (Float.compare(this.getOffsetY(), other.getOffsetY()) != 0) {
                return false;
            }
            if (Float.compare(this.getOffsetZ(), other.getOffsetZ()) != 0) {
                return false;
            }
            if (Float.compare(this.getOffsetFace(), other.getOffsetFace()) != 0) {
                return false;
            }
            if (this.isOverwriteLight() != other.isOverwriteLight()) {
                return false;
            }
            if (this.getLight() != other.getLight()) {
                return false;
            }
            return Arrays.deepEquals(this.getDrawFaces(), other.getDrawFaces());
        }

        protected boolean canEqual(Object other) {
            return other instanceof Properties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.getOffsetX());
            result = result * 59 + Float.floatToIntBits(this.getOffsetY());
            result = result * 59 + Float.floatToIntBits(this.getOffsetZ());
            result = result * 59 + Float.floatToIntBits(this.getOffsetFace());
            result = result * 59 + (this.isOverwriteLight() ? 79 : 97);
            result = result * 59 + this.getLight();
            result = result * 59 + Arrays.deepHashCode(this.getDrawFaces());
            return result;
        }

        public String toString() {
            return "FluidBlockRenderer.Properties(offsetX=" + this.getOffsetX() + ", offsetY=" + this.getOffsetY() + ", offsetZ=" + this.getOffsetZ() + ", offsetFace=" + this.getOffsetFace() + ", overwriteLight=" + this.isOverwriteLight() + ", light=" + this.getLight() + ", drawFaces=" + Arrays.deepToString(this.getDrawFaces()) + ")";
        }
    }

    public static class Builder {
        private final Properties properties = new Properties();

        public static Builder create() {
            return new Builder();
        }

        public Builder setFaceOffset(float offset) {
            this.properties.setOffsetFace(offset);
            return this;
        }

        public Builder setOffset(Vector3f offset) {
            return this.setOffset(offset.x, offset.y, offset.z);
        }

        public Builder setOffset(float offsetX, float offsetY, float offsetZ) {
            this.properties.setOffsetX(offsetX);
            this.properties.setOffsetY(offsetY);
            this.properties.setOffsetZ(offsetZ);
            return this;
        }

        public Builder setForcedLight(int light) {
            this.properties.setLight(light);
            this.properties.setOverwriteLight(true);
            return this;
        }

        public FluidBlockRenderer getRenderer() {
            return new FluidBlockRenderer(this.properties);
        }
    }
}

