/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.content;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.gregtechceu.gtceu.api.recipe.content.IContentSerializer;
import com.mojang.serialization.Codec;
import net.minecraft.network.FriendlyByteBuf;
import org.apache.commons.lang3.math.NumberUtils;

public class SerializerFloat
implements IContentSerializer<Float> {
    public static SerializerFloat INSTANCE = new SerializerFloat();

    private SerializerFloat() {
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf, Float content) {
        buf.writeFloat(content.floatValue());
    }

    @Override
    public Float fromNetwork(FriendlyByteBuf buf) {
        return Float.valueOf(buf.readFloat());
    }

    @Override
    public Float fromJson(JsonElement json) {
        return Float.valueOf(json.getAsFloat());
    }

    @Override
    public JsonElement toJson(Float content) {
        return new JsonPrimitive((Number)content);
    }

    @Override
    public Float of(Object o) {
        if (o instanceof Float) {
            return (Float)o;
        }
        if (o instanceof Number) {
            return Float.valueOf(((Number)o).floatValue());
        }
        if (o instanceof CharSequence) {
            return Float.valueOf(NumberUtils.toFloat((String)o.toString(), (float)1.0f));
        }
        return Float.valueOf(0.0f);
    }

    @Override
    public Float defaultValue() {
        return Float.valueOf(0.0f);
    }

    @Override
    public Codec<Float> codec() {
        return Codec.FLOAT;
    }
}

