/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.content;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.recipe.chance.logic.ChanceLogic;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.lowdragmc.lowdraglib.LDLib;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.RegistryOps;
import org.slf4j.Logger;

public interface IContentSerializer<T> {
    default public void toNetwork(FriendlyByteBuf buf, T content) {
        RegistryOps ops = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)GTRegistries.builtinRegistry());
        buf.m_130070_(((JsonElement)this.codec().encodeStart((DynamicOps)ops, content).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0))).toString());
    }

    default public T fromNetwork(FriendlyByteBuf buf) {
        RegistryOps ops = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)GTRegistries.builtinRegistry());
        return (T)this.codec().parse((DynamicOps)ops, (Object)((JsonElement)LDLib.GSON.fromJson(buf.m_130277_(), JsonElement.class))).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0));
    }

    public T fromJson(JsonElement var1);

    public JsonElement toJson(T var1);

    public T of(Object var1);

    public T defaultValue();

    default public void toNetworkContent(FriendlyByteBuf buf, Content content) {
        Object inner = content.getContent();
        this.toNetwork(buf, inner);
        buf.m_130130_(content.chance);
        buf.m_130130_(content.maxChance);
        buf.m_130130_(content.tierChanceBoost);
        buf.writeBoolean(content.slotName != null);
        if (content.slotName != null) {
            buf.m_130070_(content.slotName);
        }
        buf.writeBoolean(content.uiName != null);
        if (content.uiName != null) {
            buf.m_130070_(content.uiName);
        }
    }

    default public Content fromNetworkContent(FriendlyByteBuf buf) {
        T inner = this.fromNetwork(buf);
        int chance = buf.m_130242_();
        int maxChance = buf.m_130242_();
        int tierChanceBoost = buf.m_130242_();
        String slotName = null;
        if (buf.readBoolean()) {
            slotName = buf.m_130277_();
        }
        String uiName = null;
        if (buf.readBoolean()) {
            uiName = buf.m_130277_();
        }
        return new Content(inner, chance, maxChance, tierChanceBoost, slotName, uiName);
    }

    public Codec<T> codec();

    default public T fromJson(JsonElement json, HolderLookup.Provider provider) {
        RegistryOps ops = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)provider);
        return (T)this.codec().parse((DynamicOps)ops, (Object)json).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0));
    }

    default public JsonElement toJson(T content, HolderLookup.Provider provider) {
        RegistryOps ops = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)provider);
        return (JsonElement)this.codec().encodeStart((DynamicOps)ops, content).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0));
    }

    default public JsonElement toJsonContent(Content content) {
        JsonObject json = new JsonObject();
        json.add("content", this.toJson(content.getContent()));
        json.addProperty("chance", (Number)content.chance);
        json.addProperty("maxChance", (Number)content.maxChance);
        json.addProperty("tierChanceBoost", (Number)content.tierChanceBoost);
        if (content.slotName != null) {
            json.addProperty("slotName", content.slotName);
        }
        if (content.uiName != null) {
            json.addProperty("uiName", content.uiName);
        }
        return json;
    }

    default public Content fromJsonContent(JsonElement json) {
        JsonObject jsonObject = json.getAsJsonObject();
        T inner = this.fromJson(jsonObject.get("content"));
        int chance = jsonObject.has("chance") ? jsonObject.get("chance").getAsInt() : ChanceLogic.getMaxChancedValue();
        int maxChance = jsonObject.has("maxChance") ? jsonObject.get("maxChance").getAsInt() : ChanceLogic.getMaxChancedValue();
        int tierChanceBoost = jsonObject.has("tierChanceBoost") ? jsonObject.get("tierChanceBoost").getAsInt() : 0;
        String slotName = jsonObject.has("slotName") ? jsonObject.get("slotName").getAsString() : null;
        String uiName = jsonObject.has("uiName") ? jsonObject.get("uiName").getAsString() : null;
        return new Content(inner, chance, maxChance, tierChanceBoost, slotName, uiName);
    }

    default public Tag toNbt(T content) {
        return (Tag)JsonOps.INSTANCE.convertTo((DynamicOps)NbtOps.f_128958_, this.toJson(content));
    }

    default public Tag toNbtGeneric(Object content) {
        return this.toNbt(content);
    }

    default public T fromNbt(Tag tag) {
        JsonElement json = (JsonElement)NbtOps.f_128958_.convertTo((DynamicOps)JsonOps.INSTANCE, tag);
        return this.fromJson(json);
    }
}

