/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.tool;

import com.google.common.collect.Multimap;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.IGTToolDefinition;
import com.gregtechceu.gtceu.api.item.tool.MaterialToolTier;
import com.gregtechceu.gtceu.api.sound.SoundEntry;
import com.gregtechceu.gtceu.client.renderer.item.ToolItemRenderer;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GTToolItem
extends DiggerItem
implements IGTTool {
    protected final GTToolType toolType;
    protected final int electricTier;
    protected final Material material;
    private IGTToolDefinition toolStats;

    protected GTToolItem(GTToolType toolType, MaterialToolTier tier, Material material, IGTToolDefinition definition, Item.Properties properties) {
        super(0.0f, 0.0f, (Tier)tier, toolType.harvestTags.isEmpty() ? null : toolType.harvestTags.get(0), properties);
        this.toolType = toolType;
        this.material = material;
        this.electricTier = toolType.electricTier;
        this.toolStats = definition;
        if (GTCEu.isClientSide()) {
            ToolItemRenderer.create((Item)this, toolType);
        }
        this.definition$init();
    }

    public static GTToolItem create(GTToolType toolType, MaterialToolTier tier, Material material, IGTToolDefinition definition, Item.Properties properties) {
        return new GTToolItem(toolType, tier, material, definition, properties);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return this.definition$initCapabilities(stack, nbt);
    }

    public ItemStack m_7968_() {
        return this.get();
    }

    public boolean m_41470_() {
        return super.m_41470_();
    }

    public InteractionResult onItemUseFirst(ItemStack itemStack, UseOnContext context) {
        return this.definition$onItemUseFirst(itemStack, context);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return this.definition$onItemUse(context);
    }

    public String m_5524_() {
        return this.toolType.getUnlocalizedName();
    }

    public Component m_41466_() {
        return Component.m_237110_((String)this.toolType.getUnlocalizedName(), (Object[])new Object[]{this.material.getLocalizedName()});
    }

    public Component m_7626_(ItemStack stack) {
        return this.m_41466_();
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        return this.definition$mineBlock(stack, level, state, pos, miningEntity);
    }

    @Override
    public boolean isElectric() {
        return this.electricTier > -1;
    }

    @Override
    @Nullable
    public SoundEntry getSound() {
        return this.toolType.soundEntry;
    }

    @Override
    public boolean playSoundOnBlockDestroy() {
        return this.toolType.playSoundOnBlockDestroy;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return this.definition$getDestroySpeed(stack, state);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return this.definition$hurtEnemy(stack, target, attacker);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        return this.definition$onBlockStartBreak(stack, pos, player);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        this.definition$appendHoverText(stack, level, tooltipComponents, isAdvanced);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return this.definition$canApplyAtEnchantingTable(stack, enchantment);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return this.getTotalEnchantability(stack);
    }

    public boolean m_6832_(ItemStack stack, ItemStack repairCandidate) {
        return this.definition$isValidRepairItem(stack, repairCandidate);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return this.definition$getDefaultAttributeModifiers(slot, stack);
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return this.definition$canDisableShield(shield, shield, entity, attacker);
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        return this.definition$doesSneakBypassUse(stack, (BlockGetter)level, pos, player);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return this.definition$shouldCauseBlockBreakReset(oldStack, newStack);
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return this.definition$hasCraftingRemainingItem(stack);
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        return this.definition$getCraftingRemainingItem(itemStack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return this.definition$shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean isDamaged(ItemStack stack) {
        return this.definition$isDamaged(stack);
    }

    public int getDamage(ItemStack stack) {
        return this.definition$getDamage(stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return this.definition$getMaxDamage(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
        this.definition$setDamage(stack, damage);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        return this.definition$use(level, player, usedHand);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return this.definition$isCorrectToolForDrops(stack, state);
    }

    @Override
    public GTToolType getToolType() {
        return this.toolType;
    }

    @Override
    public int getElectricTier() {
        return this.electricTier;
    }

    @Override
    public Material getMaterial() {
        return this.material;
    }

    @Override
    public IGTToolDefinition getToolStats() {
        return this.toolStats;
    }
}

