/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.widget;

import com.google.common.collect.Lists;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.ingredient.IGhostIngredientTarget;
import com.lowdragmc.lowdraglib.gui.ingredient.Target;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.util.TextFormattingUtil;
import com.lowdragmc.lowdraglib.side.fluid.forge.FluidHelperImpl;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.fluid.FluidStack;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

@LDLRegister(name="phantom_fluid_slot", group="widget.container", priority=50)
public class PhantomFluidWidget
extends TankWidget
implements IGhostIngredientTarget,
IConfigurableWidget {
    private final Supplier<net.minecraftforge.fluids.FluidStack> phantomFluidGetter;
    private final Consumer<net.minecraftforge.fluids.FluidStack> phantomFluidSetter;
    @Nullable
    protected net.minecraftforge.fluids.FluidStack lastPhantomStack;

    public PhantomFluidWidget(@Nullable IFluidHandler fluidTank, int tank, int x, int y, int width, int height, Supplier<net.minecraftforge.fluids.FluidStack> phantomFluidGetter, Consumer<net.minecraftforge.fluids.FluidStack> phantomFluidSetter) {
        super(fluidTank, tank, x, y, width, height, false, false);
        this.phantomFluidGetter = phantomFluidGetter;
        this.phantomFluidSetter = phantomFluidSetter;
    }

    @Override
    @ConfigSetter(field="allowClickFilled")
    public PhantomFluidWidget setAllowClickFilled(boolean v) {
        return this;
    }

    @Override
    @ConfigSetter(field="allowClickDrained")
    public PhantomFluidWidget setAllowClickDrained(boolean v) {
        return this;
    }

    protected void setLastPhantomStack(net.minecraftforge.fluids.FluidStack fluid) {
        if (fluid != null) {
            this.lastPhantomStack = fluid.copy();
            this.lastPhantomStack.setAmount(1);
        } else {
            this.lastPhantomStack = null;
        }
    }

    public static net.minecraftforge.fluids.FluidStack drainFrom(Object ingredient) {
        Ingredient ing;
        ItemStack[] items;
        if (ingredient instanceof Ingredient && (items = (ing = (Ingredient)ingredient).m_43908_()).length > 0) {
            ingredient = items[0];
        }
        if (ingredient instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)ingredient;
            return FluidUtil.getFluidHandler((ItemStack)itemStack).map(h -> h.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE)).orElse(net.minecraftforge.fluids.FluidStack.EMPTY);
        }
        return net.minecraftforge.fluids.FluidStack.EMPTY;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Target> getPhantomTargets(Object ingredient) {
        if (GTCEu.Mods.isREILoaded() && ingredient instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)ingredient;
            ingredient = new net.minecraftforge.fluids.FluidStack(fluidStack.getFluid(), (int)fluidStack.getAmount(), fluidStack.getTag());
        } else if (GTCEu.Mods.isEMILoaded() && ingredient instanceof EmiStack) {
            EmiStack emiStack = (EmiStack)ingredient;
            Object key = emiStack.getKey();
            if (key instanceof Fluid) {
                Fluid f = (Fluid)key;
                int amount = emiStack.getAmount() == 0L ? 1000 : (int)emiStack.getAmount();
                ingredient = new net.minecraftforge.fluids.FluidStack(f, amount, emiStack.getNbt());
            } else if (key instanceof Item) {
                Item i = (Item)key;
                ingredient = new ItemStack((ItemLike)i, (int)emiStack.getAmount());
                ((ItemStack)ingredient).m_41751_(emiStack.getNbt());
            } else {
                ingredient = null;
            }
        } else if (GTCEu.Mods.isJEILoaded() && ingredient instanceof ITypedIngredient) {
            ITypedIngredient jeiStack = (ITypedIngredient)ingredient;
            ingredient = jeiStack.getIngredient();
        }
        if (!(ingredient instanceof net.minecraftforge.fluids.FluidStack) && PhantomFluidWidget.drainFrom(ingredient).isEmpty()) {
            return Collections.emptyList();
        }
        final Rect2i rectangle = this.toRectangleBox();
        return Lists.newArrayList((Object[])new Target[]{new Target(){

            @Nonnull
            public Rect2i getArea() {
                return rectangle;
            }

            public void accept(@Nonnull Object ingredient) {
                net.minecraftforge.fluids.FluidStack fluidStack;
                if (GTCEu.Mods.isREILoaded() && ingredient instanceof FluidStack) {
                    FluidStack fluidStack2 = (FluidStack)ingredient;
                    ingredient = new net.minecraftforge.fluids.FluidStack(fluidStack2.getFluid(), (int)fluidStack2.getAmount(), fluidStack2.getTag());
                } else if (GTCEu.Mods.isEMILoaded() && ingredient instanceof EmiStack) {
                    EmiStack emiStack = (EmiStack)ingredient;
                    Object key = emiStack.getKey();
                    if (key instanceof Fluid) {
                        Fluid f = (Fluid)key;
                        int amount = emiStack.getAmount() == 0L ? 1000 : (int)emiStack.getAmount();
                        ingredient = new net.minecraftforge.fluids.FluidStack(f, amount, emiStack.getNbt());
                    } else if (key instanceof Item) {
                        Item i = (Item)key;
                        ingredient = new ItemStack((ItemLike)i, (int)emiStack.getAmount());
                        ((ItemStack)ingredient).m_41751_(emiStack.getNbt());
                    } else {
                        ingredient = null;
                    }
                }
                net.minecraftforge.fluids.FluidStack ingredientStack = ingredient instanceof net.minecraftforge.fluids.FluidStack ? (fluidStack = (net.minecraftforge.fluids.FluidStack)ingredient) : PhantomFluidWidget.drainFrom(ingredient);
                if (!ingredientStack.isEmpty()) {
                    PhantomFluidWidget.this.writeClientAction(2, arg_0 -> ((net.minecraftforge.fluids.FluidStack)ingredientStack).writeToPacket(arg_0));
                }
                if (PhantomFluidWidget.this.isClientSideWidget && PhantomFluidWidget.this.phantomFluidSetter != null) {
                    PhantomFluidWidget.this.phantomFluidSetter.accept(ingredientStack);
                }
            }
        }});
    }

    @Override
    public void handleClientAction(int id, FriendlyByteBuf buffer) {
        if (id == 1) {
            this.handlePhantomClick();
        } else if (id == 2) {
            if (this.phantomFluidSetter != null) {
                this.phantomFluidSetter.accept(net.minecraftforge.fluids.FluidStack.readFromPacket((FriendlyByteBuf)buffer));
            }
        } else if (id == 4) {
            this.phantomFluidSetter.accept(net.minecraftforge.fluids.FluidStack.EMPTY);
        } else if (id == 5) {
            this.phantomFluidSetter.accept(net.minecraftforge.fluids.FluidStack.readFromPacket((FriendlyByteBuf)buffer));
        }
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        net.minecraftforge.fluids.FluidStack stack = this.phantomFluidGetter.get();
        if (stack == null || stack.isEmpty()) {
            if (this.lastPhantomStack != null) {
                this.setLastPhantomStack(null);
                this.writeUpdateInfo(4, buf -> {});
            }
        } else if (this.lastPhantomStack == null || !stack.isFluidEqual(this.lastPhantomStack)) {
            this.setLastPhantomStack(stack);
            this.writeUpdateInfo(5, arg_0 -> ((net.minecraftforge.fluids.FluidStack)stack).writeToPacket(arg_0));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            if (this.isClientSideWidget) {
                this.handlePhantomClick();
            } else {
                this.writeClientAction(1, buffer -> {});
            }
            return true;
        }
        return false;
    }

    private void handlePhantomClick() {
        ItemStack itemStack = this.gui.getModularUIContainer().m_142621_();
        net.minecraftforge.fluids.FluidStack fluid = FluidUtil.getFluidContained((ItemStack)itemStack).map(f -> new net.minecraftforge.fluids.FluidStack(f, 1000)).orElse(net.minecraftforge.fluids.FluidStack.EMPTY);
        if (this.phantomFluidSetter != null) {
            this.phantomFluidSetter.accept(fluid);
        }
    }

    @Override
    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.lastFluidInTank != null) {
            super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
            return;
        }
        Position pos = this.getPosition();
        Size size = this.getSize();
        net.minecraftforge.fluids.FluidStack stack = this.phantomFluidGetter.get();
        if (stack != null && !stack.isEmpty()) {
            RenderSystem.disableBlend();
            double progress = (double)stack.getAmount() * 1.0 / (double)Math.max(Math.max(stack.getAmount(), this.lastTankCapacity), 1);
            float drawnU = (float)this.fillDirection.getDrawnU(progress);
            float drawnV = (float)this.fillDirection.getDrawnV(progress);
            float drawnWidth = (float)this.fillDirection.getDrawnWidth(progress);
            float drawnHeight = (float)this.fillDirection.getDrawnHeight(progress);
            int width = size.width - 2;
            int height = size.height - 2;
            int x = pos.x + 1;
            int y = pos.y + 1;
            DrawerHelper.drawFluidForGui((GuiGraphics)graphics, (com.lowdragmc.lowdraglib.side.fluid.FluidStack)FluidHelperImpl.toFluidStack((net.minecraftforge.fluids.FluidStack)stack), (long)stack.getAmount(), (int)((int)((float)x + drawnU * (float)width)), (int)((int)((float)y + drawnV * (float)height)), (int)((int)((float)width * drawnWidth)), (int)((int)((float)height * drawnHeight)));
            if (this.showAmount) {
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
                String s = TextFormattingUtil.formatLongToCompactStringBuckets((long)stack.getAmount(), (int)3) + "B";
                Font fontRenderer = Minecraft.m_91087_().f_91062_;
                graphics.m_280056_(fontRenderer, s, (int)(((float)pos.x + (float)size.width / 3.0f) * 2.0f - (float)fontRenderer.m_92895_(s) + 21.0f), (int)(((float)pos.y + (float)size.height / 3.0f + 6.0f) * 2.0f), 0xFFFFFF, true);
                graphics.m_280168_().m_85849_();
            }
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Nullable
    public net.minecraftforge.fluids.FluidStack getLastPhantomStack() {
        return this.lastPhantomStack;
    }
}

