/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.ores;

import com.gregtechceu.gtceu.api.data.worldgen.ores.OreIndicatorPlacer;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.level.ChunkPos;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GeneratedIndicators {
    private final ChunkPos origin;
    private final Map<ChunkPos, List<OreIndicatorPlacer>> generatedIndicators;

    public GeneratedIndicators(ChunkPos origin, Map<ChunkPos, List<OreIndicatorPlacer>> indicators) {
        this.origin = origin;
        this.generatedIndicators = indicators;
    }

    public List<OreIndicatorPlacer> consumeIndicators(ChunkPos chunk) {
        return this.generatedIndicators.getOrDefault(chunk, List.of());
    }

    public String toString() {
        return "GeneratedIndicators[origin=" + this.origin + ", chunks={" + this.generatedIndicators.keySet().stream().map(ChunkPos::toString).collect(Collectors.joining(", ")) + "}]";
    }

    public ChunkPos getOrigin() {
        return this.origin;
    }
}

