/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.addon.AddonFinder;
import com.gregtechceu.gtceu.api.addon.IGTAddon;
import com.gregtechceu.gtceu.api.data.worldgen.IWorldGenLayer;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGeneratorUtils;
import com.gregtechceu.gtceu.integration.kjs.GTRegistryInfo;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import org.jetbrains.annotations.NotNull;

public enum WorldGenLayers implements IWorldGenLayer,
StringRepresentable
{
    STONE("stone", (RuleTest)new TagMatchTest(BlockTags.f_144266_), Set.of(Level.f_46428_.m_135782_())),
    DEEPSLATE("deepslate", (RuleTest)new TagMatchTest(BlockTags.f_144267_), Set.of(Level.f_46428_.m_135782_())),
    NETHERRACK("netherrack", (RuleTest)new TagMatchTest(BlockTags.f_215835_), Set.of(Level.f_46429_.m_135782_())),
    ENDSTONE("endstone", WorldGeneratorUtils.END_ORE_REPLACEABLES, Set.of(Level.f_46430_.m_135782_()));

    private final String name;
    private Set<ResourceLocation> levels;
    private RuleTest target;

    private WorldGenLayers(String name, RuleTest target, Set<ResourceLocation> levels) {
        this.name = name;
        this.target = target;
        this.levels = levels;
        WorldGeneratorUtils.WORLD_GEN_LAYERS.put(name, this);
    }

    public static void registerAll() {
        AddonFinder.getAddons().forEach(IGTAddon::registerWorldgenLayers);
        if (GTCEu.Mods.isKubeJSLoaded()) {
            GTRegistryInfo.registerFor(GTRegistryInfo.WORLD_GEN_LAYER.registryKey);
        }
    }

    public static IWorldGenLayer getByName(String name) {
        return (IWorldGenLayer)WorldGeneratorUtils.WORLD_GEN_LAYERS.get(name);
    }

    @NotNull
    public String m_7912_() {
        return this.name;
    }

    @Override
    public boolean isApplicableForLevel(ResourceLocation level) {
        return this.levels.contains(level);
    }

    @Override
    public Set<ResourceLocation> getLevels() {
        return this.levels;
    }

    public void setLevels(Set<ResourceLocation> levels) {
        this.levels = levels;
    }

    @Override
    public RuleTest getTarget() {
        return this.target;
    }

    public void setTarget(RuleTest target) {
        this.target = target;
    }
}

