/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.chemical.material;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.Element;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlag;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconSet;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.AlloyBlastProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.BlastProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.DustProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidPipeProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.HazardProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IMaterialProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ItemPipeProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.MaterialProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.OreProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.RotorProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ToolProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.WireProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.medicalcondition.MedicalCondition;
import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.api.fluids.FluidBuilder;
import com.gregtechceu.gtceu.api.fluids.FluidState;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKey;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.api.item.tool.MaterialToolTier;
import com.gregtechceu.gtceu.api.registry.registrate.BuilderBase;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTMedicalConditions;
import com.gregtechceu.gtceu.integration.kjs.helpers.MaterialStackWrapper;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTMath;
import dev.latvian.mods.rhino.util.HideFromJS;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Material
implements Comparable<Material> {
    @NotNull
    private final MaterialInfo materialInfo;
    @NotNull
    private final MaterialProperties properties;
    @NotNull
    private final MaterialFlags flags;
    private String chemicalFormula;

    private String calculateChemicalFormula() {
        if (this.chemicalFormula != null) {
            return this.chemicalFormula;
        }
        if (this.materialInfo.element != null) {
            Object result;
            String[] split = this.materialInfo.element.symbol().split("-");
            if (split.length > 1) {
                split[1] = FormattingUtil.toSmallUpNumbers(split[1]);
                result = split[0] + split[1];
            } else {
                result = this.materialInfo.element.symbol();
            }
            return result;
        }
        if (!this.materialInfo.componentList.isEmpty()) {
            StringBuilder components = new StringBuilder();
            for (MaterialStack component : this.materialInfo.componentList) {
                components.append(component.toString());
            }
            return components.toString();
        }
        return "";
    }

    public String getChemicalFormula() {
        return this.chemicalFormula;
    }

    public Material setFormula(String formula) {
        return this.setFormula(formula, true);
    }

    public Material setFormula(String formula, boolean withFormatting) {
        this.chemicalFormula = withFormatting ? FormattingUtil.toSmallDownNumbers(formula) : formula;
        return this;
    }

    public ImmutableList<MaterialStack> getMaterialComponents() {
        return this.materialInfo.componentList;
    }

    public Material setComponents(MaterialStack ... components) {
        this.materialInfo.setComponents(components);
        this.chemicalFormula = this.calculateChemicalFormula();
        return this;
    }

    private Material(@NotNull MaterialInfo materialInfo, @NotNull MaterialProperties properties, @NotNull MaterialFlags flags) {
        this.materialInfo = materialInfo;
        this.properties = properties;
        this.flags = flags;
        this.properties.setMaterial(this);
        this.verifyMaterial();
    }

    protected Material(ResourceLocation resourceLocation) {
        this.materialInfo = new MaterialInfo(resourceLocation);
        this.materialInfo.iconSet = MaterialIconSet.DULL;
        this.properties = new MaterialProperties();
        this.flags = new MaterialFlags();
    }

    protected void registerMaterial() {
        GTCEuAPI.materialManager.getRegistry(this.getModid()).register(this);
    }

    public String getName() {
        return this.materialInfo.resourceLocation.m_135815_();
    }

    public String getModid() {
        return this.materialInfo.resourceLocation.m_135827_();
    }

    public void addFlags(MaterialFlag ... flags) {
        if (!GTCEuAPI.materialManager.canModifyMaterials()) {
            throw new IllegalStateException("Cannot add flag to material when registry is frozen!");
        }
        this.flags.addFlags(flags).verify(this);
    }

    public boolean hasFlag(MaterialFlag flag) {
        return this.flags.hasFlag(flag);
    }

    public boolean isElement() {
        return this.materialInfo.element != null;
    }

    @Nullable
    public Element getElement() {
        return this.materialInfo.element;
    }

    public boolean hasFlags(MaterialFlag ... flags) {
        return Arrays.stream(flags).allMatch(this::hasFlag);
    }

    public boolean hasAnyOfFlags(MaterialFlag ... flags) {
        return Arrays.stream(flags).anyMatch(this::hasFlag);
    }

    protected void calculateDecompositionType() {
        if (!(this.materialInfo.componentList.isEmpty() || this.hasFlag(MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING) || this.hasFlag(MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING) || this.hasFlag(MaterialFlags.DISABLE_DECOMPOSITION))) {
            boolean onlyMetalMaterials = true;
            for (MaterialStack materialStack : this.materialInfo.componentList) {
                Material material = materialStack.material();
                onlyMetalMaterials &= material.hasProperty(PropertyKey.INGOT);
            }
            if (onlyMetalMaterials) {
                this.flags.addFlags(MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING);
            } else {
                this.flags.addFlags(MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING);
            }
        }
    }

    public Fluid getFluid() {
        FluidProperty prop = this.getProperty(PropertyKey.FLUID);
        if (prop == null) {
            throw new IllegalArgumentException("Material " + this.getResourceLocation() + " does not have a Fluid!");
        }
        Fluid fluid = prop.get(prop.getPrimaryKey());
        if (fluid != null) {
            return fluid;
        }
        fluid = this.getFluid(FluidStorageKeys.LIQUID);
        if (fluid != null) {
            return fluid;
        }
        return this.getFluid(FluidStorageKeys.GAS);
    }

    public Fluid getFluid(@NotNull FluidStorageKey key) {
        FluidProperty prop = this.getProperty(PropertyKey.FLUID);
        if (prop == null) {
            throw new IllegalArgumentException("Material " + this.getResourceLocation() + " does not have a Fluid!");
        }
        return prop.get(key);
    }

    public FluidStack getFluid(int amount) {
        return new FluidStack(this.getFluid(), amount);
    }

    public FluidStack getFluid(@NotNull FluidStorageKey key, int amount) {
        return new FluidStack(this.getFluid(key), amount);
    }

    public TagKey<Fluid> getFluidTag() {
        return TagUtil.createFluidTag(this.getName());
    }

    public FluidBuilder getFluidBuilder() {
        FluidProperty prop = this.getProperty(PropertyKey.FLUID);
        if (prop == null) {
            throw new IllegalArgumentException("Material " + this.getResourceLocation() + " does not have a Fluid!");
        }
        FluidStorageKey key = prop.getPrimaryKey();
        FluidBuilder fluid = null;
        if (key != null) {
            fluid = prop.getStorage().getQueuedBuilder(key);
        }
        if (fluid != null) {
            return fluid;
        }
        fluid = this.getFluidBuilder(FluidStorageKeys.LIQUID);
        if (fluid != null) {
            return fluid;
        }
        return this.getFluidBuilder(FluidStorageKeys.GAS);
    }

    public FluidBuilder getFluidBuilder(@NotNull FluidStorageKey key) {
        FluidProperty prop = this.getProperty(PropertyKey.FLUID);
        if (prop == null) {
            throw new IllegalArgumentException("Material " + this.getResourceLocation() + " does not have a Fluid!");
        }
        return prop.getStorage().getQueuedBuilder(key);
    }

    public MaterialToolTier getToolTier() {
        ToolProperty prop = this.getProperty(PropertyKey.TOOL);
        if (prop == null) {
            throw new IllegalArgumentException("Material " + this.materialInfo.resourceLocation + " does not have a tool!");
        }
        return prop.getTier(this);
    }

    public Fluid getHotFluid() {
        AlloyBlastProperty prop = this.properties.getProperty(PropertyKey.ALLOY_BLAST);
        return prop == null ? null : prop.getFluid();
    }

    public FluidStack getHotFluid(int amount) {
        AlloyBlastProperty prop = this.properties.getProperty(PropertyKey.ALLOY_BLAST);
        return prop == null ? null : new FluidStack(prop.getFluid(), amount);
    }

    public Item getBucket() {
        Fluid fluid = this.getFluid();
        return fluid.m_6859_();
    }

    public int getBlockHarvestLevel() {
        if (!this.hasProperty(PropertyKey.DUST)) {
            throw new IllegalArgumentException("Material " + this.materialInfo.resourceLocation + " does not have a harvest level! Is probably a Fluid");
        }
        int harvestLevel = this.getProperty(PropertyKey.DUST).getHarvestLevel();
        return harvestLevel > 0 ? harvestLevel - 1 : harvestLevel;
    }

    public int getToolHarvestLevel() {
        if (!this.hasProperty(PropertyKey.TOOL)) {
            throw new IllegalArgumentException("Material " + this.materialInfo.resourceLocation + " does not have a tool harvest level! Is probably not a Tool Material");
        }
        return this.getProperty(PropertyKey.TOOL).getHarvestLevel();
    }

    public void setMaterialARGB(int materialRGB) {
        this.materialInfo.colors.set(0, materialRGB);
    }

    public void setMaterialSecondaryARGB(int materialRGB) {
        this.materialInfo.colors.set(1, materialRGB);
    }

    public int getLayerARGB(int layerIndex) {
        if (layerIndex < -100) {
            layerIndex = Math.abs(layerIndex) % 100 / 10;
        }
        if (layerIndex > this.materialInfo.colors.size() - 1 || layerIndex < 0) {
            return -1;
        }
        int layerColor = this.getMaterialARGB(layerIndex);
        if (layerColor != -1 || layerIndex == 0) {
            return layerColor;
        }
        return this.getMaterialARGB(0);
    }

    public int getMaterialARGB() {
        return this.materialInfo.colors.getInt(0) | 0xFF000000;
    }

    public int getMaterialSecondaryARGB() {
        return this.materialInfo.colors.getInt(1) | 0xFF000000;
    }

    public int getMaterialARGB(int index) {
        return this.materialInfo.colors.getInt(index) | 0xFF000000;
    }

    public int getMaterialRGB() {
        return this.materialInfo.colors.getInt(0);
    }

    public int getMaterialRGB(int index) {
        return this.materialInfo.colors.getInt(index);
    }

    public int getMaterialSecondaryRGB() {
        return this.materialInfo.colors.getInt(1);
    }

    public boolean hasFluidColor() {
        return this.materialInfo.hasFluidColor;
    }

    public void setMaterialIconSet(MaterialIconSet materialIconSet) {
        this.materialInfo.iconSet = materialIconSet;
    }

    public MaterialIconSet getMaterialIconSet() {
        return this.materialInfo.iconSet;
    }

    public boolean isRadioactive() {
        if (this.materialInfo.element != null) {
            return this.materialInfo.element.halfLifeSeconds() >= 0L;
        }
        for (MaterialStack material : this.materialInfo.componentList) {
            if (!material.material().isRadioactive()) continue;
            return true;
        }
        return false;
    }

    public long getProtons() {
        if (this.materialInfo.element != null) {
            return this.materialInfo.element.protons();
        }
        if (this.materialInfo.componentList.isEmpty()) {
            return Math.max(1, 43);
        }
        long totalProtons = 0L;
        long totalAmount = 0L;
        for (MaterialStack material : this.materialInfo.componentList) {
            totalAmount += material.amount();
            totalProtons += material.amount() * material.material().getProtons();
        }
        return totalProtons / totalAmount;
    }

    public long getNeutrons() {
        if (this.materialInfo.element != null) {
            return this.materialInfo.element.neutrons();
        }
        if (this.materialInfo.componentList.isEmpty()) {
            return 55L;
        }
        long totalNeutrons = 0L;
        long totalAmount = 0L;
        for (MaterialStack material : this.materialInfo.componentList) {
            totalAmount += material.amount();
            totalNeutrons += material.amount() * material.material().getNeutrons();
        }
        return totalNeutrons / totalAmount;
    }

    public long getMass() {
        if (this.materialInfo.element != null) {
            return this.materialInfo.element.mass();
        }
        if (this.materialInfo.componentList.size() == 0) {
            return 98L;
        }
        long totalMass = 0L;
        long totalAmount = 0L;
        for (MaterialStack material : this.materialInfo.componentList) {
            totalAmount += material.amount();
            totalMass += material.amount() * material.material().getMass();
        }
        return totalMass / totalAmount;
    }

    public int getBlastTemperature() {
        BlastProperty prop = this.properties.getProperty(PropertyKey.BLAST);
        return prop == null ? 0 : prop.getBlastTemperature();
    }

    public String toCamelCaseString() {
        return FormattingUtil.lowerUnderscoreToUpperCamel(this.getName());
    }

    @NotNull
    public ResourceLocation getResourceLocation() {
        return this.materialInfo.resourceLocation;
    }

    public String getUnlocalizedName() {
        return this.materialInfo.resourceLocation.m_214296_("material");
    }

    public MutableComponent getLocalizedName() {
        return Component.m_237115_((String)this.getUnlocalizedName());
    }

    @Override
    public int compareTo(Material material) {
        return this.toString().compareTo(material.toString());
    }

    public String toString() {
        return this.materialInfo.resourceLocation.toString();
    }

    public MaterialStack multiply(long amount) {
        return new MaterialStack(this, amount);
    }

    public <T extends IMaterialProperty> boolean hasProperty(PropertyKey<T> key) {
        return this.getProperty(key) != null;
    }

    public <T extends IMaterialProperty> T getProperty(PropertyKey<T> key) {
        return this.properties.getProperty(key);
    }

    public <T extends IMaterialProperty> void setProperty(PropertyKey<T> key, IMaterialProperty property) {
        if (!GTCEuAPI.materialManager.canModifyMaterials()) {
            throw new IllegalStateException("Cannot add properties to a Material when registry is frozen!");
        }
        this.properties.setProperty(key, property);
        this.properties.verify();
    }

    public boolean isSolid() {
        return this.hasProperty(PropertyKey.INGOT) || this.hasProperty(PropertyKey.GEM);
    }

    public boolean hasFluid() {
        return this.hasProperty(PropertyKey.FLUID);
    }

    public void verifyMaterial() {
        this.properties.verify();
        this.flags.verify(this);
        this.chemicalFormula = this.calculateChemicalFormula();
        this.calculateDecompositionType();
    }

    @NotNull
    public MaterialInfo getMaterialInfo() {
        return this.materialInfo;
    }

    @NotNull
    public MaterialProperties getProperties() {
        return this.properties;
    }

    private static class MaterialInfo {
        private final ResourceLocation resourceLocation;
        private IntList colors = new IntArrayList(List.of(Integer.valueOf(-1), Integer.valueOf(-1)));
        private boolean hasFluidColor = true;
        private MaterialIconSet iconSet;
        private ImmutableList<MaterialStack> componentList;
        private Element element;

        private MaterialInfo(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        private void verifyInfo(MaterialProperties p, boolean averageRGB) {
            if (this.iconSet == null) {
                this.iconSet = p.hasProperty(PropertyKey.GEM) ? MaterialIconSet.GEM_VERTICAL : (p.hasProperty(PropertyKey.DUST) || p.hasProperty(PropertyKey.INGOT) || p.hasProperty(PropertyKey.POLYMER) ? MaterialIconSet.DULL : (p.hasProperty(PropertyKey.FLUID) ? MaterialIconSet.FLUID : MaterialIconSet.DULL));
            }
            if (this.colors.getInt(0) == -1) {
                if (!averageRGB || this.componentList.isEmpty()) {
                    this.colors.set(0, 0xFFFFFF);
                } else {
                    long colorTemp = 0L;
                    long divisor = 0L;
                    for (MaterialStack stack : this.componentList) {
                        colorTemp += (long)stack.material().getMaterialARGB() * stack.amount();
                        divisor += stack.amount();
                    }
                    this.colors.set(0, GTMath.saturatedCast(colorTemp / divisor));
                }
            }
        }

        public MaterialInfo setComponents(MaterialStack ... components) {
            this.componentList = ImmutableList.copyOf(Arrays.stream(components).toList());
            return this;
        }

        public IntList getColors() {
            return this.colors;
        }

        public MaterialInfo setColors(IntList colors) {
            this.colors = colors;
            return this;
        }

        public boolean isHasFluidColor() {
            return this.hasFluidColor;
        }

        public MaterialInfo setHasFluidColor(boolean hasFluidColor) {
            this.hasFluidColor = hasFluidColor;
            return this;
        }

        public MaterialIconSet getIconSet() {
            return this.iconSet;
        }

        public MaterialInfo setIconSet(MaterialIconSet iconSet) {
            this.iconSet = iconSet;
            return this;
        }

        public ImmutableList<MaterialStack> getComponentList() {
            return this.componentList;
        }

        public MaterialInfo setComponentList(ImmutableList<MaterialStack> componentList) {
            this.componentList = componentList;
            return this;
        }

        public Element getElement() {
            return this.element;
        }

        public MaterialInfo setElement(Element element) {
            this.element = element;
            return this;
        }
    }

    @RemapPrefixForJS(value="kjs$")
    public static class Builder
    extends BuilderBase<Material> {
        private final MaterialInfo materialInfo;
        private final MaterialProperties properties;
        private final MaterialFlags flags;
        private List<MaterialStack> composition = new ArrayList<MaterialStack>();
        private List<MaterialStackWrapper> compositionSupplier;
        private boolean averageRGB = false;

        public Builder(ResourceLocation resourceLocation) {
            super(resourceLocation);
            String name = resourceLocation.m_135815_();
            if (name.charAt(name.length() - 1) == '_') {
                throw new IllegalArgumentException("Material name cannot end with a '_'!");
            }
            this.materialInfo = new MaterialInfo(resourceLocation);
            this.properties = new MaterialProperties();
            this.flags = new MaterialFlags();
        }

        public Builder fluid() {
            this.fluid(FluidStorageKeys.LIQUID, new FluidBuilder());
            return this;
        }

        public Builder fluid(@NotNull FluidStorageKey key, @NotNull FluidState state) {
            return this.fluid(key, new FluidBuilder().state(state));
        }

        public Builder fluid(@NotNull FluidStorageKey key, @NotNull FluidBuilder builder) {
            this.properties.ensureSet(PropertyKey.FLUID);
            FluidProperty property = this.properties.getProperty(PropertyKey.FLUID);
            property.enqueueRegistration(key, builder);
            return this;
        }

        public Builder liquid() {
            return this.fluid(FluidStorageKeys.LIQUID, FluidState.LIQUID);
        }

        public Builder liquid(@NotNull FluidBuilder builder) {
            return this.fluid(FluidStorageKeys.LIQUID, builder.state(FluidState.LIQUID));
        }

        public Builder liquid(int temp) {
            return this.liquid(new FluidBuilder().temperature(temp));
        }

        public Builder plasma() {
            return this.fluid(FluidStorageKeys.PLASMA, FluidState.PLASMA);
        }

        public Builder plasma(@NotNull FluidBuilder builder) {
            return this.fluid(FluidStorageKeys.PLASMA, builder.state(FluidState.PLASMA));
        }

        public Builder plasma(int temp) {
            return this.plasma(new FluidBuilder().temperature(temp));
        }

        public Builder gas() {
            return this.fluid(FluidStorageKeys.GAS, FluidState.GAS);
        }

        public Builder gas(@NotNull FluidBuilder builder) {
            return this.fluid(FluidStorageKeys.GAS, builder.state(FluidState.GAS));
        }

        public Builder gas(int temp) {
            return this.gas(new FluidBuilder().temperature(temp));
        }

        public Builder dust() {
            this.properties.ensureSet(PropertyKey.DUST);
            return this;
        }

        public Builder dust(int harvestLevel) {
            return this.dust(harvestLevel, 0);
        }

        public Builder dust(int harvestLevel, int burnTime) {
            this.properties.setProperty(PropertyKey.DUST, new DustProperty(harvestLevel, burnTime));
            return this;
        }

        public Builder wood() {
            return this.wood(0, 300);
        }

        public Builder wood(int harvestLevel) {
            return this.wood(harvestLevel, 300);
        }

        public Builder wood(int harvestLevel, int burnTime) {
            this.properties.setProperty(PropertyKey.DUST, new DustProperty(harvestLevel, burnTime));
            this.properties.ensureSet(PropertyKey.WOOD);
            return this;
        }

        public Builder ingot() {
            this.properties.ensureSet(PropertyKey.INGOT);
            return this;
        }

        public Builder ingot(int harvestLevel) {
            return this.ingot(harvestLevel, 0);
        }

        public Builder ingot(int harvestLevel, int burnTime) {
            DustProperty prop = this.properties.getProperty(PropertyKey.DUST);
            if (prop == null) {
                this.dust(harvestLevel, burnTime);
            } else {
                if (prop.getHarvestLevel() == 2) {
                    prop.setHarvestLevel(harvestLevel);
                }
                if (prop.getBurnTime() == 0) {
                    prop.setBurnTime(burnTime);
                }
            }
            this.properties.ensureSet(PropertyKey.INGOT);
            return this;
        }

        public Builder gem() {
            this.properties.ensureSet(PropertyKey.GEM);
            return this;
        }

        public Builder gem(int harvestLevel) {
            return this.gem(harvestLevel, 0);
        }

        public Builder gem(int harvestLevel, int burnTime) {
            DustProperty prop = this.properties.getProperty(PropertyKey.DUST);
            if (prop == null) {
                this.dust(harvestLevel, burnTime);
            } else {
                if (prop.getHarvestLevel() == 2) {
                    prop.setHarvestLevel(harvestLevel);
                }
                if (prop.getBurnTime() == 0) {
                    prop.setBurnTime(burnTime);
                }
            }
            this.properties.ensureSet(PropertyKey.GEM);
            return this;
        }

        public Builder polymer() {
            this.properties.ensureSet(PropertyKey.POLYMER);
            return this;
        }

        public Builder polymer(int harvestLevel) {
            DustProperty prop = this.properties.getProperty(PropertyKey.DUST);
            if (prop == null) {
                this.dust(harvestLevel, 0);
            } else if (prop.getHarvestLevel() == 2) {
                prop.setHarvestLevel(harvestLevel);
            }
            this.properties.ensureSet(PropertyKey.POLYMER);
            return this;
        }

        public Builder burnTime(int burnTime) {
            DustProperty prop = this.properties.getProperty(PropertyKey.DUST);
            if (prop == null) {
                this.dust();
                prop = this.properties.getProperty(PropertyKey.DUST);
            }
            prop.setBurnTime(burnTime);
            return this;
        }

        public Builder color(int color) {
            this.color(color, true);
            return this;
        }

        public Builder color(int color, boolean hasFluidColor) {
            this.materialInfo.colors.set(0, color);
            this.materialInfo.hasFluidColor = hasFluidColor;
            return this;
        }

        public Builder secondaryColor(int color) {
            this.materialInfo.colors.set(1, color);
            return this;
        }

        public Builder colorAverage() {
            this.averageRGB = true;
            return this;
        }

        public Builder iconSet(MaterialIconSet iconSet) {
            this.materialInfo.iconSet = iconSet;
            return this;
        }

        public Builder components(Object ... components) {
            Preconditions.checkArgument((components.length % 2 == 0 ? 1 : 0) != 0, (Object)"Material Components list malformed!");
            for (int i = 0; i < components.length; i += 2) {
                Material material;
                if (components[i] == null) {
                    throw new IllegalArgumentException("Material in Components List is null for Material " + this.materialInfo.resourceLocation);
                }
                Object object = components[i];
                if (object instanceof CharSequence) {
                    CharSequence chars = (CharSequence)object;
                    material = GTMaterials.get(chars.toString());
                } else {
                    material = (Material)components[i];
                }
                this.composition.add(new MaterialStack(material, ((Number)components[i + 1]).longValue()));
            }
            return this;
        }

        public Builder componentStacks(MaterialStack ... components) {
            this.composition = Arrays.asList(components);
            return this;
        }

        public Builder componentStacks(ImmutableList<MaterialStack> components) {
            this.composition = components;
            return this;
        }

        public Builder kjs$components(MaterialStackWrapper ... components) {
            this.compositionSupplier = Arrays.asList(components);
            return this;
        }

        public Builder kjs$components(ImmutableList<MaterialStackWrapper> components) {
            this.compositionSupplier = components;
            return this;
        }

        public Builder flags(MaterialFlag ... flags) {
            this.flags.addFlags(flags);
            return this;
        }

        public Builder appendFlags(Collection<MaterialFlag> f1, MaterialFlag ... f2) {
            this.flags.addFlags(f1.toArray(new MaterialFlag[0]));
            this.flags.addFlags(f2);
            return this;
        }

        public Builder element(Element element) {
            this.materialInfo.element = element;
            return this;
        }

        public Builder toolStats(ToolProperty toolProperty) {
            this.properties.setProperty(PropertyKey.TOOL, toolProperty);
            return this;
        }

        public Builder rotorStats(int power, int efficiency, float damage, int durability) {
            this.properties.setProperty(PropertyKey.ROTOR, new RotorProperty(power, efficiency, damage, durability));
            return this;
        }

        public Builder blastTemp(int temp) {
            return this.blast(temp);
        }

        public Builder blastTemp(int temp, BlastProperty.GasTier gasTier) {
            return this.blast(temp, gasTier);
        }

        public Builder blastTemp(int temp, BlastProperty.GasTier gasTier, int eutOverride) {
            return this.blast(b -> b.temp(temp, gasTier).blastStats(eutOverride));
        }

        public Builder blastTemp(int temp, BlastProperty.GasTier gasTier, int eutOverride, int durationOverride) {
            return this.blast(b -> b.temp(temp, gasTier).blastStats(eutOverride, durationOverride));
        }

        public Builder blast(int temp) {
            this.properties.setProperty(PropertyKey.BLAST, new BlastProperty(temp));
            return this;
        }

        public Builder blast(int temp, BlastProperty.GasTier gasTier) {
            this.properties.setProperty(PropertyKey.BLAST, new BlastProperty(temp, gasTier));
            return this;
        }

        public Builder blast(UnaryOperator<BlastProperty.Builder> b) {
            this.properties.setProperty(PropertyKey.BLAST, ((BlastProperty.Builder)b.apply(new BlastProperty.Builder())).build());
            return this;
        }

        public Builder removeHazard() {
            this.properties.setProperty(PropertyKey.HAZARD, new HazardProperty(HazardProperty.HazardTrigger.NONE, GTMedicalConditions.NONE, 0.0f, false));
            return this;
        }

        public Builder radioactiveHazard(float multiplier) {
            this.properties.setProperty(PropertyKey.HAZARD, new HazardProperty(HazardProperty.HazardTrigger.ANY, GTMedicalConditions.CARCINOGEN, multiplier, true));
            return this;
        }

        public Builder hazard(HazardProperty.HazardTrigger trigger, MedicalCondition condition) {
            this.properties.setProperty(PropertyKey.HAZARD, new HazardProperty(trigger, condition, 1.0f, false));
            return this;
        }

        public Builder hazard(HazardProperty.HazardTrigger trigger, MedicalCondition condition, float progressionMultiplier) {
            this.properties.setProperty(PropertyKey.HAZARD, new HazardProperty(trigger, condition, progressionMultiplier, false));
            return this;
        }

        public Builder hazard(HazardProperty.HazardTrigger trigger, MedicalCondition condition, float progressionMultiplier, boolean applyToDerivatives) {
            this.properties.setProperty(PropertyKey.HAZARD, new HazardProperty(trigger, condition, progressionMultiplier, applyToDerivatives));
            return this;
        }

        public Builder hazard(HazardProperty.HazardTrigger trigger, MedicalCondition condition, boolean applyToDerivatives) {
            this.properties.setProperty(PropertyKey.HAZARD, new HazardProperty(trigger, condition, 1.0f, applyToDerivatives));
            return this;
        }

        public Builder ore() {
            this.properties.ensureSet(PropertyKey.ORE);
            return this;
        }

        public Builder ore(boolean emissive) {
            this.properties.setProperty(PropertyKey.ORE, new OreProperty(1, 1, emissive));
            return this;
        }

        public Builder ore(int oreMultiplier, int byproductMultiplier) {
            this.properties.setProperty(PropertyKey.ORE, new OreProperty(oreMultiplier, byproductMultiplier));
            return this;
        }

        public Builder ore(int oreMultiplier, int byproductMultiplier, boolean emissive) {
            this.properties.setProperty(PropertyKey.ORE, new OreProperty(oreMultiplier, byproductMultiplier, emissive));
            return this;
        }

        public Builder washedIn(Material m) {
            this.properties.ensureSet(PropertyKey.ORE);
            this.properties.getProperty(PropertyKey.ORE).setWashedIn(m);
            return this;
        }

        public Builder washedIn(Material m, int washedAmount) {
            this.properties.ensureSet(PropertyKey.ORE);
            this.properties.getProperty(PropertyKey.ORE).setWashedIn(m, washedAmount);
            return this;
        }

        public Builder separatedInto(Material ... m) {
            this.properties.ensureSet(PropertyKey.ORE);
            this.properties.getProperty(PropertyKey.ORE).setSeparatedInto(m);
            return this;
        }

        public Builder oreSmeltInto(Material m) {
            this.properties.ensureSet(PropertyKey.ORE);
            this.properties.getProperty(PropertyKey.ORE).setDirectSmeltResult(m);
            return this;
        }

        public Builder polarizesInto(Material m) {
            this.properties.ensureSet(PropertyKey.INGOT);
            this.properties.getProperty(PropertyKey.INGOT).setMagneticMaterial(m);
            return this;
        }

        public Builder arcSmeltInto(Material m) {
            this.properties.ensureSet(PropertyKey.INGOT);
            this.properties.getProperty(PropertyKey.INGOT).setArcSmeltingInto(m);
            return this;
        }

        public Builder macerateInto(Material m) {
            this.properties.ensureSet(PropertyKey.INGOT);
            this.properties.getProperty(PropertyKey.INGOT).setMacerateInto(m);
            return this;
        }

        public Builder ingotSmeltInto(Material m) {
            this.properties.ensureSet(PropertyKey.INGOT);
            this.properties.getProperty(PropertyKey.INGOT).setSmeltingInto(m);
            return this;
        }

        public Builder addOreByproducts(Material ... byproducts) {
            this.properties.ensureSet(PropertyKey.ORE);
            this.properties.getProperty(PropertyKey.ORE).setOreByProducts(byproducts);
            return this;
        }

        public Builder cableProperties(long voltage, int amperage, int loss) {
            this.cableProperties(voltage, amperage, loss, false);
            return this;
        }

        public Builder cableProperties(long voltage, int amperage, int loss, boolean isSuperCon) {
            this.properties.ensureSet(PropertyKey.DUST);
            this.properties.setProperty(PropertyKey.WIRE, new WireProperties(voltage, amperage, loss, isSuperCon));
            return this;
        }

        public Builder cableProperties(long voltage, int amperage, int loss, boolean isSuperCon, int criticalTemperature) {
            this.properties.ensureSet(PropertyKey.DUST);
            this.properties.setProperty(PropertyKey.WIRE, new WireProperties(voltage, amperage, loss, isSuperCon, criticalTemperature));
            return this;
        }

        public Builder fluidPipeProperties(int maxTemp, int throughput, boolean gasProof) {
            return this.fluidPipeProperties(maxTemp, throughput, gasProof, false, false, false);
        }

        public Builder fluidPipeProperties(int maxTemp, int throughput, boolean gasProof, boolean acidProof, boolean cryoProof, boolean plasmaProof) {
            this.properties.setProperty(PropertyKey.FLUID_PIPE, new FluidPipeProperties(maxTemp, throughput, gasProof, acidProof, cryoProof, plasmaProof));
            return this;
        }

        public Builder itemPipeProperties(int priority, float stacksPerSec) {
            this.properties.setProperty(PropertyKey.ITEM_PIPE, new ItemPipeProperties(priority, stacksPerSec));
            return this;
        }

        @Deprecated
        public Builder addDefaultEnchant(Enchantment enchant, int level) {
            if (!this.properties.hasProperty(PropertyKey.TOOL)) {
                throw new IllegalArgumentException("Material cannot have an Enchant without Tools!");
            }
            this.properties.getProperty(PropertyKey.TOOL).addEnchantmentForTools(enchant, level);
            return this;
        }

        @HideFromJS
        public Material buildAndRegister() {
            ImmutableList immutableList = this.materialInfo.componentList = this.composition.isEmpty() && this.compositionSupplier != null ? ImmutableList.copyOf((Object[])((MaterialStack[])this.compositionSupplier.stream().map(MaterialStackWrapper::toMatStack).toArray(MaterialStack[]::new))) : ImmutableList.copyOf(this.composition);
            if (!this.properties.hasProperty(PropertyKey.HAZARD)) {
                for (MaterialStack materialStack : this.materialInfo.componentList) {
                    Material material = materialStack.material();
                    if (!material.hasProperty(PropertyKey.HAZARD) || !material.getProperty(PropertyKey.HAZARD).applyToDerivatives) continue;
                    this.properties.setProperty(PropertyKey.HAZARD, material.getProperty(PropertyKey.HAZARD));
                    break;
                }
            }
            if (this.properties.hasProperty(PropertyKey.HAZARD) && this.properties.getProperty(PropertyKey.HAZARD).hazardTrigger == HazardProperty.HazardTrigger.NONE) {
                this.properties.removeProperty(PropertyKey.HAZARD);
            }
            Material mat = new Material(this.materialInfo, this.properties, this.flags);
            this.materialInfo.verifyInfo(this.properties, this.averageRGB);
            mat.registerMaterial();
            return mat;
        }

        @Override
        @HideFromJS
        public Material register() {
            this.value = this.buildAndRegister();
            return this.value;
        }
    }
}

