/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_config.networking.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.fzzyhmstrs.fzzy_config.networking.FzzyPayload;
import me.fzzyhmstrs.fzzy_config.networking.NetworkEventsClient;
import me.fzzyhmstrs.fzzy_config.networking.api.C2SPayloadHandler;
import me.fzzyhmstrs.fzzy_config.networking.api.ClientPlayNetworkContext;
import me.fzzyhmstrs.fzzy_config.networking.api.NetworkApi;
import me.fzzyhmstrs.fzzy_config.networking.api.S2CPayloadHandler;
import me.fzzyhmstrs.fzzy_config.networking.api.ServerPlayNetworkContext;
import me.fzzyhmstrs.fzzy_config.util.platform.impl.PlatformUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ!\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJQ\u0010\u0018\u001a\u00020\r\"\b\b\u0000\u0010\u0010*\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00028\u00000\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019JQ\u0010\u001b\u001a\u00020\r\"\b\b\u0000\u0010\u0010*\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00028\u00000\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cR \u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001e0\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R \u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020!0\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010 \u00a8\u0006#"}, d2={"Lme/fzzyhmstrs/fzzy_config/networking/impl/NetworkApiImpl;", "Lme/fzzyhmstrs/fzzy_config/networking/api/NetworkApi;", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "id", "Lnet/minecraft/world/entity/player/Player;", "playerEntity", "", "canSend", "(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/world/entity/player/Player;)Z", "Lme/fzzyhmstrs/fzzy_config/networking/FzzyPayload;", "payload", "", "send", "(Lme/fzzyhmstrs/fzzy_config/networking/FzzyPayload;Lnet/minecraft/world/entity/player/Player;)V", "T", "Ljava/lang/Class;", "clazz", "Ljava/util/function/Function;", "Lnet/minecraft/network/FriendlyByteBuf;", "function", "Lme/fzzyhmstrs/fzzy_config/networking/api/S2CPayloadHandler;", "handler", "registerS2C", "(Lnet/minecraft/resources/ResourceLocation;Ljava/lang/Class;Ljava/util/function/Function;Lme/fzzyhmstrs/fzzy_config/networking/api/S2CPayloadHandler;)V", "Lme/fzzyhmstrs/fzzy_config/networking/api/C2SPayloadHandler;", "registerC2S", "(Lnet/minecraft/resources/ResourceLocation;Ljava/lang/Class;Ljava/util/function/Function;Lme/fzzyhmstrs/fzzy_config/networking/api/C2SPayloadHandler;)V", "", "Lnet/minecraftforge/network/simple/SimpleChannel;", "channelMap", "Ljava/util/Map;", "Ljava/util/concurrent/atomic/AtomicInteger;", "indexMap", "fzzy_config"})
public final class NetworkApiImpl
implements NetworkApi {
    @NotNull
    public static final NetworkApiImpl INSTANCE = new NetworkApiImpl();
    @NotNull
    private static final Map<ResourceLocation, SimpleChannel> channelMap = new LinkedHashMap();
    @NotNull
    private static final Map<ResourceLocation, AtomicInteger> indexMap = new LinkedHashMap();

    private NetworkApiImpl() {
    }

    @Override
    public boolean canSend(@NotNull ResourceLocation id, @Nullable Player playerEntity) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return playerEntity instanceof ServerPlayer ? ((ServerPlayer)playerEntity).f_8906_.m_6198_() : NetworkEventsClient.INSTANCE.canSend(id);
    }

    @Override
    public void send(@NotNull FzzyPayload payload, @Nullable Player playerEntity) {
        block1: {
            block0: {
                Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
                if (!(playerEntity instanceof ServerPlayer)) break block0;
                SimpleChannel simpleChannel = channelMap.get(payload.getId());
                if (simpleChannel == null) break block1;
                simpleChannel.send(PacketDistributor.PLAYER.with(() -> NetworkApiImpl.send$lambda$0(playerEntity)), (Object)payload);
                break block1;
            }
            SimpleChannel simpleChannel = channelMap.get(payload.getId());
            if (simpleChannel == null) break block1;
            simpleChannel.send(PacketDistributor.SERVER.noArg(), (Object)payload);
        }
    }

    @Override
    public <T extends FzzyPayload> void registerS2C(@NotNull ResourceLocation id, @NotNull Class<T> clazz, @NotNull Function<FriendlyByteBuf, T> function, @NotNull S2CPayloadHandler<T> handler) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(function, (String)"function");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        String version = "1.0";
        AtomicInteger atomicInteger = indexMap.computeIfAbsent(id, arg_0 -> NetworkApiImpl.registerS2C$lambda$2(NetworkApiImpl::registerS2C$lambda$1, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)atomicInteger, (String)"computeIfAbsent(...)");
        AtomicInteger index = atomicInteger;
        SimpleChannel simpleChannel = channelMap.computeIfAbsent(id, arg_0 -> NetworkApiImpl.registerS2C$lambda$7(arg_0 -> NetworkApiImpl.registerS2C$lambda$6(version, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)simpleChannel, (String)"computeIfAbsent(...)");
        SimpleChannel channel = simpleChannel;
        channel.registerMessage(index.incrementAndGet(), clazz, NetworkApiImpl::registerS2C$lambda$8, function, (arg_0, arg_1) -> NetworkApiImpl.registerS2C$lambda$9(handler, arg_0, arg_1));
    }

    @Override
    public <T extends FzzyPayload> void registerC2S(@NotNull ResourceLocation id, @NotNull Class<T> clazz, @NotNull Function<FriendlyByteBuf, T> function, @NotNull C2SPayloadHandler<T> handler) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(function, (String)"function");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        String version = "1.0";
        AtomicInteger atomicInteger = indexMap.computeIfAbsent(id, arg_0 -> NetworkApiImpl.registerC2S$lambda$11(NetworkApiImpl::registerC2S$lambda$10, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)atomicInteger, (String)"computeIfAbsent(...)");
        AtomicInteger index = atomicInteger;
        SimpleChannel simpleChannel = channelMap.computeIfAbsent(id, arg_0 -> NetworkApiImpl.registerC2S$lambda$16(arg_0 -> NetworkApiImpl.registerC2S$lambda$15(version, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)simpleChannel, (String)"computeIfAbsent(...)");
        SimpleChannel channel = simpleChannel;
        channel.registerMessage(index.incrementAndGet(), clazz, NetworkApiImpl::registerC2S$lambda$17, function, (arg_0, arg_1) -> NetworkApiImpl.registerC2S$lambda$18(handler, arg_0, arg_1));
    }

    private static final ServerPlayer send$lambda$0(Player $playerEntity) {
        return (ServerPlayer)$playerEntity;
    }

    private static final AtomicInteger registerS2C$lambda$1(ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"<unused var>");
        return new AtomicInteger(0);
    }

    private static final AtomicInteger registerS2C$lambda$2(Function1 $tmp0, Object p0) {
        return (AtomicInteger)$tmp0.invoke(p0);
    }

    private static final String registerS2C$lambda$6$lambda$3(String $version) {
        return $version;
    }

    private static final boolean registerS2C$lambda$6$lambda$4(String $version, String serverVersion) {
        return Intrinsics.areEqual((Object)serverVersion, (Object)$version);
    }

    private static final boolean registerS2C$lambda$6$lambda$5(String $version, String clientVersion) {
        return Intrinsics.areEqual((Object)clientVersion, (Object)$version);
    }

    private static final SimpleChannel registerS2C$lambda$6(String $version, ResourceLocation i) {
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        return NetworkRegistry.newSimpleChannel((ResourceLocation)i, () -> NetworkApiImpl.registerS2C$lambda$6$lambda$3($version), arg_0 -> NetworkApiImpl.registerS2C$lambda$6$lambda$4($version, arg_0), arg_0 -> NetworkApiImpl.registerS2C$lambda$6$lambda$5($version, arg_0));
    }

    private static final SimpleChannel registerS2C$lambda$7(Function1 $tmp0, Object p0) {
        return (SimpleChannel)$tmp0.invoke(p0);
    }

    private static final void registerS2C$lambda$8(FzzyPayload payload, FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        payload.write(buf);
    }

    private static final void registerS2C$lambda$9(S2CPayloadHandler $handler, FzzyPayload payload, Supplier contextSuppler) {
        if (PlatformUtils.INSTANCE.isClient()) {
            Object t = contextSuppler.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            ClientPlayNetworkContext newContext = new ClientPlayNetworkContext((NetworkEvent.Context)t);
            Intrinsics.checkNotNull((Object)payload);
            $handler.handle(payload, newContext);
            ((NetworkEvent.Context)contextSuppler.get()).setPacketHandled(true);
        }
    }

    private static final AtomicInteger registerC2S$lambda$10(ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"<unused var>");
        return new AtomicInteger(0);
    }

    private static final AtomicInteger registerC2S$lambda$11(Function1 $tmp0, Object p0) {
        return (AtomicInteger)$tmp0.invoke(p0);
    }

    private static final String registerC2S$lambda$15$lambda$12(String $version) {
        return $version;
    }

    private static final boolean registerC2S$lambda$15$lambda$13(String $version, String serverVersion) {
        return Intrinsics.areEqual((Object)serverVersion, (Object)$version);
    }

    private static final boolean registerC2S$lambda$15$lambda$14(String $version, String clientVersion) {
        return Intrinsics.areEqual((Object)clientVersion, (Object)$version);
    }

    private static final SimpleChannel registerC2S$lambda$15(String $version, ResourceLocation i) {
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        return NetworkRegistry.newSimpleChannel((ResourceLocation)i, () -> NetworkApiImpl.registerC2S$lambda$15$lambda$12($version), arg_0 -> NetworkApiImpl.registerC2S$lambda$15$lambda$13($version, arg_0), arg_0 -> NetworkApiImpl.registerC2S$lambda$15$lambda$14($version, arg_0));
    }

    private static final SimpleChannel registerC2S$lambda$16(Function1 $tmp0, Object p0) {
        return (SimpleChannel)$tmp0.invoke(p0);
    }

    private static final void registerC2S$lambda$17(FzzyPayload payload, FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        payload.write(buf);
    }

    private static final void registerC2S$lambda$18(C2SPayloadHandler $handler, FzzyPayload payload, Supplier contextSuppler) {
        Object t = contextSuppler.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        ServerPlayNetworkContext newContext = new ServerPlayNetworkContext((NetworkEvent.Context)t);
        Intrinsics.checkNotNull((Object)payload);
        $handler.handle(payload, newContext);
        ((NetworkEvent.Context)contextSuppler.get()).setPacketHandled(true);
    }
}

