/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.world;

import com.buuz135.functionalstorage.inventory.EnderInventoryHandler;
import java.util.HashMap;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;

public class EnderSavedData
extends SavedData {
    public static EnderSavedData CLIENT = new EnderSavedData(null);
    public static final String NAME = "FunctionalStorageEnder";
    private HashMap<String, EnderInventoryHandler> itemHandlers = new HashMap();
    private Level level;

    public EnderSavedData(Level level) {
        this.level = level;
    }

    public static EnderSavedData getInstance(LevelAccessor accessor) {
        if (accessor instanceof ServerLevel) {
            ServerLevel serverWorld = ((ServerLevel)accessor).m_7654_().m_129880_(Level.f_46428_);
            EnderSavedData data = (EnderSavedData)serverWorld.m_8895_().m_164861_(tag -> EnderSavedData.load(tag, (Level)((ServerLevel)accessor)), () -> new EnderSavedData((Level)((ServerLevel)accessor)), NAME);
            return data;
        }
        if (accessor instanceof ClientLevel) {
            return CLIENT;
        }
        return null;
    }

    private static EnderSavedData load(CompoundTag compoundTag, Level level) {
        EnderSavedData manager = new EnderSavedData(level);
        manager.itemHandlers = new HashMap();
        CompoundTag backpacks = compoundTag.m_128469_("Ender");
        for (String s : backpacks.m_128431_()) {
            EnderInventoryHandler hander = new EnderInventoryHandler(s, manager);
            hander.deserializeNBT(backpacks.m_128469_(s));
            manager.itemHandlers.put(s, hander);
        }
        return manager;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setFrenquency(String frequency, EnderInventoryHandler handler) {
        this.itemHandlers.put(frequency, handler);
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        CompoundTag nbt = new CompoundTag();
        this.itemHandlers.forEach((s, iItemHandler) -> nbt.m_128365_(s, (Tag)iItemHandler.serializeNBT()));
        tag.m_128365_("Ender", (Tag)nbt);
        return tag;
    }

    public EnderInventoryHandler getFrequency(String string) {
        return this.itemHandlers.computeIfAbsent(string, s -> new EnderInventoryHandler((String)s, this));
    }

    public HashMap<String, EnderInventoryHandler> getItemHandlers() {
        return this.itemHandlers;
    }
}

