/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.fulleng.definition;

import appeng.block.AEBaseBlockItem;
import appeng.core.definitions.AEParts;
import appeng.core.definitions.BlockDefinition;
import appeng.core.definitions.ItemDefinition;
import appeng.items.parts.PartItem;
import appeng.parts.reporting.AbstractDisplayPart;
import appeng.parts.reporting.AbstractMonitorPart;
import gripe._90.fulleng.FullblockEnergistics;
import gripe._90.fulleng.block.FullBlock;
import gripe._90.fulleng.block.MonitorBlock;
import gripe._90.fulleng.block.TerminalBlock;
import gripe._90.fulleng.block.entity.monitor.ConversionMonitorBlockEntity;
import gripe._90.fulleng.block.entity.monitor.StorageMonitorBlockEntity;
import gripe._90.fulleng.block.entity.terminal.CraftingTerminalBlockEntity;
import gripe._90.fulleng.block.entity.terminal.PatternAccessTerminalBlockEntity;
import gripe._90.fulleng.block.entity.terminal.PatternEncodingTerminalBlockEntity;
import gripe._90.fulleng.block.entity.terminal.StorageTerminalBlockEntity;
import gripe._90.fulleng.block.entity.terminal.TerminalBlockEntity;
import gripe._90.fulleng.integration.requester.RequesterTerminalBlock;
import gripe._90.fulleng.integration.requester.RequesterTerminalBlockEntity;
import gripe._90.fulleng.integration.requester.RequesterTerminalBlockItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class FullEngBlocks {
    private static final List<BlockDefinition<?>> BLOCKS = new ArrayList();
    public static final BlockDefinition<TerminalBlock<StorageTerminalBlockEntity>> TERMINAL = FullEngBlocks.terminal(AEParts.TERMINAL);
    public static final BlockDefinition<TerminalBlock<CraftingTerminalBlockEntity>> CRAFTING_TERMINAL = FullEngBlocks.terminal(AEParts.CRAFTING_TERMINAL);
    public static final BlockDefinition<TerminalBlock<PatternEncodingTerminalBlockEntity>> PATTERN_ENCODING_TERMINAL = FullEngBlocks.terminal(AEParts.PATTERN_ENCODING_TERMINAL);
    public static final BlockDefinition<TerminalBlock<PatternAccessTerminalBlockEntity>> PATTERN_ACCESS_TERMINAL = FullEngBlocks.terminal(AEParts.PATTERN_ACCESS_TERMINAL);
    public static final BlockDefinition<MonitorBlock<StorageMonitorBlockEntity>> STORAGE_MONITOR = FullEngBlocks.monitor(AEParts.STORAGE_MONITOR);
    public static final BlockDefinition<MonitorBlock<ConversionMonitorBlockEntity>> CONVERSION_MONITOR = FullEngBlocks.monitor(AEParts.CONVERSION_MONITOR);
    public static final BlockDefinition<FullBlock<RequesterTerminalBlockEntity>> REQUESTER_TERMINAL = FullEngBlocks.block("ME Requester Terminal", "requester_terminal", RequesterTerminalBlock::new, RequesterTerminalBlockItem::new);

    public static List<BlockDefinition<?>> getBlocks() {
        return Collections.unmodifiableList(BLOCKS);
    }

    static <P extends AbstractMonitorPart, E extends StorageMonitorBlockEntity> BlockDefinition<MonitorBlock<E>> monitor(ItemDefinition<PartItem<P>> equivalentPart) {
        return FullEngBlocks.block(equivalentPart.getEnglishName(), equivalentPart.id().m_135815_(), () -> new MonitorBlock(equivalentPart));
    }

    static <P extends AbstractDisplayPart, E extends TerminalBlockEntity> BlockDefinition<TerminalBlock<E>> terminal(ItemDefinition<PartItem<P>> equivalentPart) {
        return FullEngBlocks.block(equivalentPart.getEnglishName(), equivalentPart.id().m_135815_(), () -> new TerminalBlock(equivalentPart));
    }

    static <T extends Block> BlockDefinition<T> block(String englishName, String id, Supplier<T> supplier) {
        return FullEngBlocks.block(englishName, id, supplier, block -> new AEBaseBlockItem(block, new Item.Properties()));
    }

    static <T extends Block> BlockDefinition<T> block(String englishName, String id, Supplier<T> blockSupplier, Function<T, ? extends AEBaseBlockItem> itemFunction) {
        Block block = (Block)blockSupplier.get();
        AEBaseBlockItem item = itemFunction.apply(block);
        BlockDefinition definition = new BlockDefinition(englishName, FullblockEnergistics.makeId(id), block, (BlockItem)item);
        BLOCKS.add(definition);
        return definition;
    }
}

