/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.fulleng.block.entity;

import appeng.api.implementations.blockentities.IColorableBlockEntity;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNodeListener;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.blockentity.grid.AENetworkBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class FullBlockEntity
extends AENetworkBlockEntity
implements IColorableBlockEntity {
    private AEColor paintedColour = AEColor.TRANSPARENT;
    private boolean isActive = false;

    public FullBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).setIdlePowerUsage(0.5);
    }

    protected boolean readFromStream(FriendlyByteBuf data) {
        boolean needRedraw = super.readFromStream(data);
        boolean wasActive = this.isActive;
        this.isActive = data.readBoolean();
        AEColor oldPaintedColor = this.paintedColour;
        this.paintedColour = AEColor.values()[data.readByte()];
        return oldPaintedColor != this.paintedColour || wasActive != this.isActive || needRedraw;
    }

    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeBoolean(this.getMainNode().isOnline());
        data.writeByte(this.paintedColour.ordinal());
    }

    protected void saveVisualState(CompoundTag data) {
        super.saveVisualState(data);
        data.m_128379_("active", this.isActive);
    }

    protected void loadVisualState(CompoundTag data) {
        super.loadVisualState(data);
        this.isActive = data.m_128471_("active");
    }

    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        data.m_128344_("paintedColor", (byte)this.paintedColour.ordinal());
    }

    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        if (data.m_128441_("paintedColor")) {
            this.paintedColour = AEColor.values()[data.m_128445_("paintedColor")];
        }
    }

    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (reason != IGridNodeListener.State.GRID_BOOT) {
            this.markForUpdate();
        }
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.COVERED;
    }

    public void onReady() {
        super.onReady();
        if (!this.isClientSide()) {
            this.isActive = true;
        }
    }

    public void m_7651_() {
        super.m_7651_();
        this.isActive = false;
    }

    public boolean isActive() {
        return this.isClientSide() ? this.isActive : this.getMainNode().isOnline();
    }

    public AEColor getColor() {
        return this.paintedColour;
    }

    public boolean recolourBlock(Direction side, AEColor colour, Player who) {
        if (this.paintedColour == colour) {
            return false;
        }
        this.paintedColour = colour;
        this.saveChanges();
        this.markForUpdate();
        return true;
    }
}

