/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.repack.org.quartz.jobs.ee.jms;

import javax.jms.Message;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import net.creeperhost.ftbbackups.repack.org.quartz.Job;
import net.creeperhost.ftbbackups.repack.org.quartz.JobDataMap;
import net.creeperhost.ftbbackups.repack.org.quartz.JobExecutionContext;
import net.creeperhost.ftbbackups.repack.org.quartz.JobExecutionException;
import net.creeperhost.ftbbackups.repack.org.quartz.jobs.ee.jms.JmsHelper;
import net.creeperhost.ftbbackups.repack.org.quartz.jobs.ee.jms.JmsMessageFactory;

public final class SendTopicMessageJob
implements Job {
    public void execute(JobExecutionContext jobCtx) throws JobExecutionException {
        TopicConnection conn = null;
        TopicSession sess = null;
        TopicPublisher publisher = null;
        try {
            JobDataMap dataMap = jobCtx.getMergedJobDataMap();
            InitialContext namingCtx = JmsHelper.getInitialContext(dataMap);
            TopicConnectionFactory connFactory = (TopicConnectionFactory)namingCtx.lookup(dataMap.getString("jms.connection.factory"));
            if (!JmsHelper.isDestinationSecure(dataMap)) {
                conn = connFactory.createTopicConnection();
            } else {
                String user = dataMap.getString("jms.user");
                String password = dataMap.getString("jms.password");
                conn = connFactory.createTopicConnection(user, password);
            }
            boolean useTransaction = JmsHelper.useTransaction(dataMap);
            int ackMode = dataMap.getInt("jms.acknowledge");
            sess = (TopicSession)conn.createSession(useTransaction, ackMode);
            Topic topic = (Topic)namingCtx.lookup(dataMap.getString("jms.destination"));
            publisher = sess.createPublisher(topic);
            String msgFactoryClassName = dataMap.getString("jms.message.factory.class.name");
            JmsMessageFactory messageFactory = JmsHelper.getMessageFactory(msgFactoryClassName);
            Message msg = messageFactory.createMessage(dataMap, (Session)sess);
            publisher.publish(msg);
        }
        catch (Exception e) {
            try {
                throw new JobExecutionException(e);
            }
            catch (Throwable throwable) {
                JmsHelper.closeResource(publisher);
                JmsHelper.closeResource(sess);
                JmsHelper.closeResource(conn);
                throw throwable;
            }
        }
        JmsHelper.closeResource(publisher);
        JmsHelper.closeResource(sess);
        JmsHelper.closeResource(conn);
    }
}

