/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.framingtemplates.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.netty.handler.codec.DecoderException;
import ky.someone.mods.framingtemplates.item.FramingTemplateItem;
import ky.someone.mods.framingtemplates.recipe.FramingRecipes;
import ky.someone.mods.framingtemplates.util.FramingUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class TemplateCopyRecipe
extends ShapedRecipe {
    private final Item template;
    private final Ingredient center;
    private final Ingredient surrounding;
    private final int count;

    public TemplateCopyRecipe(ResourceLocation id, Item template, Ingredient top, Ingredient surrounding, int count) {
        super(id, "", CraftingBookCategory.BUILDING, 3, 3, NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{surrounding, Ingredient.m_43929_((ItemLike[])new ItemLike[]{template}), surrounding, surrounding, top, surrounding, surrounding, surrounding, surrounding}), TemplateCopyRecipe.withCopyHint(template, count));
        this.template = template;
        this.center = top;
        this.surrounding = surrounding;
        this.count = count;
    }

    private static ItemStack withCopyHint(Item item, int count) {
        ItemStack stack = item.m_7968_().m_255036_(count);
        MutableComponent hint = Component.m_237115_((String)"tooltip.framing_templates.makes_copy").m_130938_(FramingUtil.TOOLTIP_EXTRA);
        ListTag lore = new ListTag();
        lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)hint)));
        stack.m_41698_("display").m_128365_("Lore", (Tag)lore);
        return stack;
    }

    public boolean m_5818_(CraftingContainer container, Level level) {
        return super.m_5818_(container, level) && container.m_8020_(1).m_41737_("decorations") != null;
    }

    public ItemStack m_5874_(CraftingContainer container, RegistryAccess reg) {
        return container.m_8020_(1).m_255036_(this.count);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)FramingRecipes.TEMPLATE_COPY.get();
    }

    public static class Serializer
    implements RecipeSerializer<TemplateCopyRecipe> {
        public TemplateCopyRecipe fromJson(ResourceLocation id, JsonObject json) {
            String templateId = json.getAsJsonPrimitive("template").getAsString();
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(templateId));
            if (!(item instanceof FramingTemplateItem)) {
                throw new JsonParseException("Invalid template item %s!".formatted(templateId));
            }
            FramingTemplateItem template = (FramingTemplateItem)item;
            Ingredient surrounding = Ingredient.m_43917_((JsonElement)json.get("surrounding"));
            Ingredient center = json.has("center") ? Ingredient.m_43917_((JsonElement)json.get("center")) : surrounding;
            int count = GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)2);
            return new TemplateCopyRecipe(id, template, center, surrounding, count);
        }

        public TemplateCopyRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            Item item = (Item)buf.readRegistryIdUnsafe(ForgeRegistries.ITEMS);
            if (!(item instanceof FramingTemplateItem)) {
                throw new DecoderException("Invalid template item!");
            }
            FramingTemplateItem template = (FramingTemplateItem)item;
            Ingredient surrounding = Ingredient.m_43940_((FriendlyByteBuf)buf);
            Ingredient center = Ingredient.m_43940_((FriendlyByteBuf)buf);
            int count = buf.m_130242_();
            return new TemplateCopyRecipe(id, template, center, surrounding, count);
        }

        public void toNetwork(FriendlyByteBuf buf, TemplateCopyRecipe recipe) {
            buf.writeRegistryIdUnsafe(ForgeRegistries.ITEMS, (Object)recipe.template);
            recipe.surrounding.m_43923_(buf);
            recipe.center.m_43923_(buf);
            buf.m_130130_(recipe.count);
        }
    }
}

