/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.util;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.util.LText;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public record TextKey(int index, List<String> args) {
    static final Map<String, Integer> keyMap = new HashMap<String, Integer>();
    static final Map<Integer, String> keyReverseMap = new HashMap<Integer, String>();
    static final Map<Integer, Function<TextKey, Component>> keyTextBuilderMap = new HashMap<Integer, Function<TextKey, Component>>();
    static final Map<Integer, BiFunction<ItemStack, Level, List<ItemStack>>> processorMap = new HashMap<Integer, BiFunction<ItemStack, Level, List<ItemStack>>>();
    static final Map<Integer, ResourceLocation> keySpriteIdMap = new HashMap<Integer, ResourceLocation>();
    static final Function<TextKey, Component> DEFAULT_FUNCTION = key -> LText.translatable("emi_loot.missing_key");
    static final BiFunction<ItemStack, Level, List<ItemStack>> DEFAULT_PROCESSOR = (stack, world) -> List.of(stack);
    static final ResourceLocation EMPTY = new ResourceLocation("emi_loot", "textures/gui/empty.png");
    static int curDynamicIndex = 1000;
    public static final Set<String> defaultSkips = Set.of("emi_loot.function.set_count_add", "emi_loot.function.set_count_set", "emi_loot.function.fill_player_head", "emi_loot.function.limit_count", "emi_loot.no_conditions");

    private static void mapBuilder(int index, String key, Function<TextKey, Component> function, ResourceLocation spriteId) {
        keyMap.put(key, index);
        keyReverseMap.put(index, key);
        keyTextBuilderMap.put(index, function);
        keySpriteIdMap.put(index, spriteId);
    }

    private static void mapBuilder(int index, String key, Function<TextKey, Component> function, ResourceLocation spriteId, BiFunction<ItemStack, Level, List<ItemStack>> processor) {
        keyMap.put(key, index);
        keyReverseMap.put(index, key);
        keyTextBuilderMap.put(index, function);
        keySpriteIdMap.put(index, spriteId);
        processorMap.put(index, processor);
    }

    public static void register(String key, int args, ResourceLocation sprite, BiFunction<ItemStack, Level, List<ItemStack>> processor) {
        if (keyMap.containsKey(key)) {
            throw new IllegalArgumentException("Text key [" + key + "] already registered!");
        }
        if (!sprite.toString().contains(".png")) {
            throw new IllegalArgumentException("Text key [" + key + "] registered with sprite identifier [" + String.valueOf(sprite) + "] that isn't a png!)");
        }
        int index = curDynamicIndex++;
        switch (args) {
            case 0: {
                TextKey.mapBuilder(index, key, tk -> TextKey.getBasicText(index), sprite, processor);
                break;
            }
            case 1: {
                TextKey.mapBuilder(index, key, tk -> TextKey.getOneArgText(index, tk), sprite, processor);
                break;
            }
            case 2: {
                TextKey.mapBuilder(index, key, tk -> TextKey.getTwoArgText(index, tk), sprite, processor);
                break;
            }
            default: {
                TextKey.mapBuilder(index, key, TextKey::getAnyOfText, sprite, processor);
            }
        }
    }

    public static void register(String key, int args, ResourceLocation sprite) {
        if (keyMap.containsKey(key)) {
            throw new IllegalArgumentException("Text key [" + key + "] already registered!");
        }
        if (!sprite.toString().contains(".png")) {
            throw new IllegalArgumentException("Text key [" + key + "] registered with sprite identifier [" + String.valueOf(sprite) + "] that isn't a png!)");
        }
        int index = curDynamicIndex++;
        switch (args) {
            case 0: {
                TextKey.mapBuilder(index, key, tk -> TextKey.getBasicText(index), sprite);
                break;
            }
            case 1: {
                TextKey.mapBuilder(index, key, tk -> TextKey.getOneArgText(index, tk), sprite);
                break;
            }
            case 2: {
                TextKey.mapBuilder(index, key, tk -> TextKey.getTwoArgText(index, tk), sprite);
                break;
            }
            default: {
                TextKey.mapBuilder(index, key, TextKey::getAnyOfText, sprite);
            }
        }
    }

    private static Component getBasicText(int index) {
        String translationKey = keyReverseMap.getOrDefault(index, "emi_loot.missing_key");
        return LText.translatable(translationKey);
    }

    private static Component getOneArgText(int index, TextKey key) {
        String arg;
        String translationKey = keyReverseMap.getOrDefault(index, "emi_loot.missing_key");
        try {
            arg = key.args.get(0);
        }
        catch (Exception e) {
            EMILoot.LOGGER.error("Couldn't get one-arg text");
            e.printStackTrace();
            arg = "Missing";
        }
        return LText.translatable(translationKey, arg);
    }

    private static Component getTwoArgText(int index, TextKey key) {
        String arg2;
        String arg1;
        String translationKey = keyReverseMap.getOrDefault(index, "emi_loot.missing_key");
        try {
            arg1 = key.args.get(0);
        }
        catch (Exception e) {
            EMILoot.LOGGER.error("Couldn't get first arg of two-arg text");
            e.printStackTrace();
            arg1 = "Missing";
        }
        try {
            arg2 = key.args.get(1);
        }
        catch (Exception e) {
            EMILoot.LOGGER.error("Couldn't get second arg of two-arg text");
            e.printStackTrace();
            arg2 = "Missing";
        }
        return LText.translatable(translationKey, arg1, arg2);
    }

    private static Component getAnyOfText(TextKey key) {
        List<String> args = key.args;
        int size = args.size();
        if (size == 1) {
            return LText.translatable("emi_loot.condition.any_of", args.get(0));
        }
        if (size == 2) {
            return LText.translatable("emi_loot.condition.any_of_2", args.get(0), args.get(1));
        }
        MutableComponent finalText = LText.empty();
        for (int i = 0; i < size; ++i) {
            String arg = args.get(i);
            if (i == size - 2) {
                finalText.m_7220_((Component)LText.translatable("emi_loot.condition.any_of_3a", arg));
                continue;
            }
            if (i == size - 1) {
                finalText.m_7220_((Component)LText.translatable("emi_loot.condition.any_of", arg));
                continue;
            }
            finalText.m_7220_((Component)LText.translatable("emi_loot.condition.any_of_3", arg));
        }
        return finalText;
    }

    private static Component getAllOfText(TextKey key) {
        List<String> args = key.args;
        int size = args.size();
        if (size == 1) {
            return LText.translatable("emi_loot.condition.all_of", args.get(0));
        }
        if (size == 2) {
            return LText.translatable("emi_loot.condition.all_of_2", args.get(0), args.get(1));
        }
        MutableComponent finalText = LText.empty();
        for (int i = 0; i < size; ++i) {
            String arg = args.get(i);
            if (i == size - 2) {
                finalText.m_7220_((Component)LText.translatable("emi_loot.condition.all_of_3a", arg));
                continue;
            }
            if (i == size - 1) {
                finalText.m_7220_((Component)LText.translatable("emi_loot.condition.all_of", arg));
                continue;
            }
            finalText.m_7220_((Component)LText.translatable("emi_loot.condition.all_of_3", arg));
        }
        return finalText;
    }

    private static Component getInvertedText(int index, TextKey key) {
        String arg;
        String translationKey = keyReverseMap.getOrDefault(index, "emi_loot.missing_key");
        try {
            arg = key.args.get(0);
        }
        catch (Exception e) {
            EMILoot.LOGGER.error("Couldn't get inverted text");
            e.printStackTrace();
            arg = "Missing";
        }
        return LText.translatable(translationKey, arg).m_130940_(ChatFormatting.RED);
    }

    public boolean isNotEmpty() {
        return this.index != 0;
    }

    public static Set<String> keys() {
        return keyMap.keySet();
    }

    public static int getIndex(String key) {
        return keyMap.getOrDefault(key, -1);
    }

    public static String getKey(int index) {
        return keyReverseMap.getOrDefault(index, "emi_loot.function.empty");
    }

    public static ResourceLocation getSpriteId(int index) {
        return keySpriteIdMap.getOrDefault(index, EMPTY);
    }

    public static TextKey empty() {
        return new TextKey(0, new LinkedList<String>());
    }

    public static TextKey of(String key, String ... args) {
        if (keyMap.containsKey(key)) {
            return new TextKey(keyMap.get(key), Arrays.stream(args).toList());
        }
        return new TextKey(0, new LinkedList<String>());
    }

    public static TextKey of(String key, List<String> args) {
        if (keyMap.containsKey(key)) {
            return new TextKey(keyMap.get(key), args);
        }
        EMILoot.LOGGER.error("Couldn't parse TextKey with key: {}and args: {}", (Object)key, args);
        return new TextKey(0, new LinkedList<String>());
    }

    public static TextKey of(String key) {
        return TextKey.of(key, new LinkedList<String>());
    }

    public static TextKey of(String key, String arg) {
        return TextKey.of(key, Collections.singletonList(arg));
    }

    public static String symbolKey(int index) {
        return String.valueOf((char)(59136 + index));
    }

    public TextKeyResult process(ItemStack stack, @Nullable Level world) {
        BiFunction<ItemStack, Level, List<ItemStack>> processor = processorMap.getOrDefault(this.index, DEFAULT_PROCESSOR);
        List<ItemStack> finalStacks = processor.apply(stack, world);
        Component text = keyTextBuilderMap.getOrDefault(this.index, DEFAULT_FUNCTION).apply(this);
        return new TextKeyResult(text, finalStacks);
    }

    public boolean skip() {
        return EMILoot.config.skippedKeys.contains(TextKey.getKey(this.index));
    }

    public static TextKey fromBuf(FriendlyByteBuf buf) {
        int key = buf.m_130242_();
        int size = buf.readByte();
        LinkedList<String> args = new LinkedList<String>();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                args.add(buf.m_130277_());
            }
        }
        return new TextKey(key, args);
    }

    public void toBuf(FriendlyByteBuf buf) {
        buf.m_130130_(this.index);
        if (this.args.isEmpty()) {
            buf.writeByte(0);
        } else {
            int argSize = Math.min(127, this.args.size());
            buf.writeByte(this.args.size());
            for (int i = 0; i < argSize; ++i) {
                String string = this.args.get(i);
                buf.m_130070_(string);
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextKey textKey = (TextKey)o;
        return this.index == textKey.index && this.args.equals(textKey.args);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.index, this.args);
    }

    static {
        BiFunction<ItemStack, Level, List<ItemStack>> smeltProcessor = (stack, world) -> {
            LinkedList<ItemStack> finalStacks = new LinkedList<ItemStack>();
            if (world != null) {
                Optional opt = world.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{stack}), world);
                if (opt.isPresent()) {
                    ItemStack tempStack = ((SmeltingRecipe)opt.get()).m_8043_(world.m_9598_());
                    if (!tempStack.m_41619_()) {
                        finalStacks.add(tempStack.m_41777_());
                    }
                } else {
                    finalStacks.add((ItemStack)stack);
                }
            } else {
                finalStacks.add((ItemStack)stack);
            }
            return finalStacks;
        };
        BiFunction<ItemStack, Level, List<ItemStack>> ominousProcessor = (stack, world) -> List.of(Raid.m_37779_());
        TextKey.mapBuilder(0, "emi_loot.function.empty", key -> LText.empty(), EMPTY);
        TextKey.mapBuilder(1, "emi_loot.function.bonus", key -> TextKey.getOneArgText(1, key), new ResourceLocation("emi_loot", "textures/gui/bonus.png"));
        TextKey.mapBuilder(2, "emi_loot.function.potion", key -> TextKey.getOneArgText(2, key), new ResourceLocation("emi_loot", "textures/gui/potion.png"));
        TextKey.mapBuilder(3, "emi_loot.function.set_count_add", key -> TextKey.getBasicText(3), new ResourceLocation("emi_loot", "textures/gui/set_count_add.png"));
        TextKey.mapBuilder(4, "emi_loot.function.set_count_set", key -> TextKey.getBasicText(4), new ResourceLocation("emi_loot", "textures/gui/set_count_add.png"));
        TextKey.mapBuilder(5, "emi_loot.function.randomly_enchanted_book", key -> TextKey.getBasicText(5), new ResourceLocation("emi_loot", "textures/gui/random_book.png"));
        TextKey.mapBuilder(6, "emi_loot.function.randomly_enchanted_item", key -> TextKey.getBasicText(6), new ResourceLocation("emi_loot", "textures/gui/random_item.png"));
        TextKey.mapBuilder(7, "emi_loot.function.set_enchant_book", key -> TextKey.getBasicText(7), new ResourceLocation("emi_loot", "textures/gui/set_book.png"));
        TextKey.mapBuilder(8, "emi_loot.function.set_enchant_item", key -> TextKey.getBasicText(8), new ResourceLocation("emi_loot", "textures/gui/set_item.png"));
        TextKey.mapBuilder(9, "emi_loot.function.smelt", key -> TextKey.getBasicText(9), new ResourceLocation("emi_loot", "textures/gui/smelt.png"), smeltProcessor);
        TextKey.mapBuilder(10, "emi_loot.function.looting", key -> TextKey.getBasicText(10), new ResourceLocation("emi_loot", "textures/gui/looting.png"));
        TextKey.mapBuilder(11, "emi_loot.function.map", key -> TextKey.getOneArgText(11, key), new ResourceLocation("emi_loot", "textures/gui/map.png"));
        TextKey.mapBuilder(12, "emi_loot.function.set_contents", key -> TextKey.getBasicText(12), new ResourceLocation("emi_loot", "textures/gui/set_contents.png"));
        TextKey.mapBuilder(13, "emi_loot.function.damage", key -> TextKey.getOneArgText(13, key), new ResourceLocation("emi_loot", "textures/gui/damage.png"));
        TextKey.mapBuilder(14, "emi_loot.function.copy_state", key -> TextKey.getBasicText(14), new ResourceLocation("emi_loot", "textures/gui/copy.png"));
        TextKey.mapBuilder(15, "emi_loot.function.copy_name", key -> TextKey.getOneArgText(15, key), new ResourceLocation("emi_loot", "textures/gui/copy.png"));
        TextKey.mapBuilder(16, "emi_loot.function.copy_nbt", key -> TextKey.getBasicText(16), new ResourceLocation("emi_loot", "textures/gui/nbt.png"));
        TextKey.mapBuilder(17, "emi_loot.function.decay", key -> TextKey.getBasicText(17), new ResourceLocation("emi_loot", "textures/gui/tnt.png"));
        TextKey.mapBuilder(18, "emi_loot.function.fill_player_head", key -> TextKey.getBasicText(18), new ResourceLocation("emi_loot", "textures/gui/fzzy.png"));
        TextKey.mapBuilder(19, "emi_loot.function.limit_count", key -> TextKey.getOneArgText(19, key), new ResourceLocation("emi_loot", "textures/gui/limit_count.png"));
        TextKey.mapBuilder(20, "emi_loot.function.set_attributes", key -> TextKey.getOneArgText(20, key), new ResourceLocation("emi_loot", "textures/gui/set_attributes.png"));
        TextKey.mapBuilder(21, "emi_loot.function.banner", key -> TextKey.getBasicText(21), new ResourceLocation("emi_loot", "textures/gui/banner.png"));
        TextKey.mapBuilder(22, "emi_loot.function.lore", key -> TextKey.getBasicText(22), new ResourceLocation("emi_loot", "textures/gui/lore.png"));
        TextKey.mapBuilder(23, "emi_loot.function.set_stew", key -> TextKey.getOneArgText(23, key), new ResourceLocation("emi_loot", "textures/gui/stew.png"));
        TextKey.mapBuilder(24, "emi_loot.function.set_nbt", key -> TextKey.getBasicText(24), new ResourceLocation("emi_loot", "textures/gui/nbt.png"));
        TextKey.mapBuilder(25, "emi_loot.function.set_loot_table", key -> TextKey.getOneArgText(25, key), new ResourceLocation("emi_loot", "textures/gui/chest.png"));
        TextKey.mapBuilder(26, "emi_loot.function.reference", key -> TextKey.getOneArgText(25, key), new ResourceLocation("emi_loot", "textures/gui/reference.png"));
        TextKey.mapBuilder(34, "emi_loot.condition.survives_explosion", key -> TextKey.getBasicText(34), new ResourceLocation("emi_loot", "textures/gui/tnt.png"));
        TextKey.mapBuilder(35, "emi_loot.condition.blockstate", key -> TextKey.getOneArgText(35, key), new ResourceLocation("emi_loot", "textures/gui/blockstate.png"));
        TextKey.mapBuilder(36, "emi_loot.condition.table_bonus", key -> TextKey.getOneArgText(36, key), new ResourceLocation("emi_loot", "textures/gui/percent.png"));
        TextKey.mapBuilder(37, "emi_loot.condition.invert", key -> TextKey.getInvertedText(37, key), new ResourceLocation("emi_loot", "textures/gui/invert.png"));
        TextKey.mapBuilder(39, "emi_loot.condition.any_of", TextKey::getAnyOfText, new ResourceLocation("emi_loot", "textures/gui/or.png"));
        TextKey.mapBuilder(40, "emi_loot.condition.all_of", TextKey::getAllOfText, new ResourceLocation("emi_loot", "textures/gui/or.png"));
        TextKey.mapBuilder(41, "emi_loot.condition.killed_player", key -> TextKey.getBasicText(41), new ResourceLocation("emi_loot", "textures/gui/steve.png"));
        TextKey.mapBuilder(42, "emi_loot.condition.chance", key -> TextKey.getOneArgText(42, key), new ResourceLocation("emi_loot", "textures/gui/percent.png"));
        TextKey.mapBuilder(43, "emi_loot.condition.chance_looting", key -> TextKey.getTwoArgText(43, key), new ResourceLocation("emi_loot", "textures/gui/chance_looting.png"));
        TextKey.mapBuilder(44, "emi_loot.condition.damage_source", key -> TextKey.getOneArgText(44, key), new ResourceLocation("emi_loot", "textures/gui/tiny_cactus.png"));
        TextKey.mapBuilder(45, "emi_loot.condition.location", key -> TextKey.getOneArgText(45, key), new ResourceLocation("emi_loot", "textures/gui/location.png"));
        TextKey.mapBuilder(46, "emi_loot.condition.entity_props", key -> TextKey.getOneArgText(46, key), new ResourceLocation("emi_loot", "textures/gui/entity_props.png"));
        TextKey.mapBuilder(47, "emi_loot.condition.match_tool", key -> TextKey.getOneArgText(47, key), new ResourceLocation("emi_loot", "textures/gui/match_tool.png"));
        TextKey.mapBuilder(48, "emi_loot.condition.entity_scores", key -> TextKey.getBasicText(48), new ResourceLocation("emi_loot", "textures/gui/score.png"));
        TextKey.mapBuilder(49, "emi_loot.condition.reference", key -> TextKey.getOneArgText(49, key), new ResourceLocation("emi_loot", "textures/gui/reference.png"));
        TextKey.mapBuilder(50, "emi_loot.condition.time_check", key -> TextKey.getOneArgText(50, key), new ResourceLocation("emi_loot", "textures/gui/time.png"));
        TextKey.mapBuilder(51, "emi_loot.condition.value_check", key -> TextKey.getTwoArgText(51, key), new ResourceLocation("emi_loot", "textures/gui/value.png"));
        TextKey.mapBuilder(52, "emi_loot.condition.raining_true", key -> TextKey.getBasicText(52), new ResourceLocation("emi_loot", "textures/gui/raining.png"));
        TextKey.mapBuilder(53, "emi_loot.condition.raining_false", key -> TextKey.getBasicText(53), new ResourceLocation("emi_loot", "textures/gui/sunny.png"));
        TextKey.mapBuilder(54, "emi_loot.condition.thundering_true", key -> TextKey.getBasicText(54), new ResourceLocation("emi_loot", "textures/gui/thundering.png"));
        TextKey.mapBuilder(55, "emi_loot.condition.thundering_false", key -> TextKey.getBasicText(55), new ResourceLocation("emi_loot", "textures/gui/not_thundering.png"));
        TextKey.mapBuilder(62, "emi_loot.pickaxe.wood", key -> TextKey.getBasicText(62), new ResourceLocation("emi_loot", "textures/gui/pickaxe_wood.png"));
        TextKey.mapBuilder(63, "emi_loot.pickaxe.stone", key -> TextKey.getBasicText(63), new ResourceLocation("emi_loot", "textures/gui/pickaxe_stone.png"));
        TextKey.mapBuilder(64, "emi_loot.pickaxe.iron", key -> TextKey.getBasicText(64), new ResourceLocation("emi_loot", "textures/gui/pickaxe_iron.png"));
        TextKey.mapBuilder(65, "emi_loot.pickaxe.diamond", key -> TextKey.getBasicText(65), new ResourceLocation("emi_loot", "textures/gui/pickaxe_diamond.png"));
        TextKey.mapBuilder(66, "emi_loot.pickaxe.netherite", key -> TextKey.getBasicText(66), new ResourceLocation("emi_loot", "textures/gui/pickaxe_netherite.png"));
        TextKey.mapBuilder(77, "emi_loot.axe.wood", key -> TextKey.getBasicText(77), new ResourceLocation("emi_loot", "textures/gui/axe_wood.png"));
        TextKey.mapBuilder(78, "emi_loot.axe.stone", key -> TextKey.getBasicText(78), new ResourceLocation("emi_loot", "textures/gui/axe_stone.png"));
        TextKey.mapBuilder(79, "emi_loot.axe.iron", key -> TextKey.getBasicText(79), new ResourceLocation("emi_loot", "textures/gui/axe_iron.png"));
        TextKey.mapBuilder(80, "emi_loot.axe.diamond", key -> TextKey.getBasicText(80), new ResourceLocation("emi_loot", "textures/gui/axe_diamond.png"));
        TextKey.mapBuilder(81, "emi_loot.axe.netherite", key -> TextKey.getBasicText(81), new ResourceLocation("emi_loot", "textures/gui/axe_netherite.png"));
        TextKey.mapBuilder(92, "emi_loot.shovel.wood", key -> TextKey.getBasicText(92), new ResourceLocation("emi_loot", "textures/gui/shovel_wood.png"));
        TextKey.mapBuilder(93, "emi_loot.shovel.stone", key -> TextKey.getBasicText(93), new ResourceLocation("emi_loot", "textures/gui/shovel_stone.png"));
        TextKey.mapBuilder(94, "emi_loot.shovel.iron", key -> TextKey.getBasicText(94), new ResourceLocation("emi_loot", "textures/gui/shovel_iron.png"));
        TextKey.mapBuilder(95, "emi_loot.shovel.diamond", key -> TextKey.getBasicText(95), new ResourceLocation("emi_loot", "textures/gui/shovel_diamond.png"));
        TextKey.mapBuilder(96, "emi_loot.shovel.netherite", key -> TextKey.getBasicText(96), new ResourceLocation("emi_loot", "textures/gui/shovel_netherite.png"));
        TextKey.mapBuilder(107, "emi_loot.hoe.wood", key -> TextKey.getBasicText(107), new ResourceLocation("emi_loot", "textures/gui/hoe_wood.png"));
        TextKey.mapBuilder(108, "emi_loot.hoe.stone", key -> TextKey.getBasicText(108), new ResourceLocation("emi_loot", "textures/gui/hoe_stone.png"));
        TextKey.mapBuilder(109, "emi_loot.hoe.iron", key -> TextKey.getBasicText(109), new ResourceLocation("emi_loot", "textures/gui/hoe_iron.png"));
        TextKey.mapBuilder(110, "emi_loot.hoe.diamond", key -> TextKey.getBasicText(110), new ResourceLocation("emi_loot", "textures/gui/hoe_diamond.png"));
        TextKey.mapBuilder(111, "emi_loot.hoe.netherite", key -> TextKey.getBasicText(111), new ResourceLocation("emi_loot", "textures/gui/hoe_netherite.png"));
        TextKey.mapBuilder(124, "emi_loot.condition.sequence", key -> TextKey.getBasicText(124), new ResourceLocation("emi_loot", "textures/gui/sequence.png"));
        TextKey.mapBuilder(125, "emi_loot.condition.direct_drop", key -> TextKey.getBasicText(125), new ResourceLocation("emi_loot", "textures/gui/direct_drops.png"));
        TextKey.mapBuilder(126, "emi_loot.condition.spawns_with", key -> TextKey.getBasicText(126), new ResourceLocation("emi_loot", "textures/gui/spawns_with.png"));
        TextKey.mapBuilder(127, "emi_loot.condition.creeper", key -> TextKey.getBasicText(127), new ResourceLocation("emi_loot", "textures/gui/creeper.png"));
        TextKey.mapBuilder(128, "emi_loot.condition.wither_kill", key -> TextKey.getBasicText(128), new ResourceLocation("emi_loot", "textures/gui/wither.png"));
        TextKey.mapBuilder(129, "emi_loot.function.set_any_damage", key -> TextKey.getBasicText(129), new ResourceLocation("emi_loot", "textures/gui/damage.png"));
        TextKey.mapBuilder(130, "emi_loot.function.ominous_banner", key -> TextKey.getBasicText(130), new ResourceLocation("emi_loot", "textures/gui/ominous.png"), ominousProcessor);
        TextKey.mapBuilder(150, "emi_loot.no_conditions", key -> TextKey.getBasicText(150), EMPTY);
    }

    public record TextKeyResult(Component text, List<ItemStack> stacks) {
    }
}

