/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.server;

import fzzyhmstrs.emi_loot.server.ArchaeologyLootPoolBuilder;
import fzzyhmstrs.emi_loot.server.LootSender;
import fzzyhmstrs.emi_loot.util.SimpleFzzyPayload;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import me.fzzyhmstrs.fzzy_config.api.ConfigApi;
import me.fzzyhmstrs.fzzy_config.networking.FzzyPayload;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ArchaeologyLootTableSender
implements LootSender<ArchaeologyLootPoolBuilder> {
    private final String idToSend;
    final List<ArchaeologyLootPoolBuilder> builderList = new LinkedList<ArchaeologyLootPoolBuilder>();
    HashMap<ItemStack, Float> floatMap = new HashMap();
    public static ResourceLocation ARCHAEOLOGY_SENDER = new ResourceLocation("e_1", "a_s");

    public ArchaeologyLootTableSender(ResourceLocation id) {
        this.idToSend = LootSender.getIdToSend(id);
    }

    @Override
    public String getId() {
        return this.idToSend;
    }

    @Override
    public void send(ServerPlayer player) {
        if (!ConfigApi.INSTANCE.network().canSend(ARCHAEOLOGY_SENDER, (Player)player)) {
            return;
        }
        FriendlyByteBuf buf = ConfigApi.INSTANCE.network().buf();
        buf.m_130070_(this.idToSend);
        buf.writeShort(this.floatMap.size());
        this.floatMap.forEach((item, floatWeight) -> {
            buf.m_130055_(item);
            buf.writeFloat(floatWeight.floatValue());
        });
        ConfigApi.INSTANCE.network().send((FzzyPayload)new SimpleFzzyPayload(buf, ARCHAEOLOGY_SENDER), (Player)player);
    }

    @Override
    public void addBuilder(ArchaeologyLootPoolBuilder builder) {
        this.builderList.add(builder);
    }

    @Override
    public List<ArchaeologyLootPoolBuilder> getBuilders() {
        return this.builderList;
    }

    @Override
    public void build() {
        this.builderList.forEach(builder -> {
            builder.build();
            builder.builtMap.forEach((item, weight) -> {
                if (this.floatMap.containsKey(item)) {
                    float oldWeight = this.floatMap.getOrDefault(item, Float.valueOf(0.0f)).floatValue();
                    this.floatMap.put((ItemStack)item, Float.valueOf(oldWeight + weight.floatValue()));
                } else {
                    this.floatMap.put((ItemStack)item, (Float)weight);
                }
            });
        });
    }
}

