/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.EMILootClientAgnos;
import fzzyhmstrs.emi_loot.client.ClientBlockLootTable;
import fzzyhmstrs.emi_loot.client.ClientBuiltPool;
import fzzyhmstrs.emi_loot.emi.EmiClientPlugin;
import fzzyhmstrs.emi_loot.util.BlockStateEmiStack;
import fzzyhmstrs.emi_loot.util.ConditionalStack;
import fzzyhmstrs.emi_loot.util.FloatTrimmer;
import fzzyhmstrs.emi_loot.util.IconGroupEmiWidget;
import fzzyhmstrs.emi_loot.util.SymbolText;
import fzzyhmstrs.emi_loot.util.WidgetRowBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import me.fzzyhmstrs.fzzy_config.util.FcText;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class BlockLootRecipe
implements EmiRecipe {
    private final ClientBlockLootTable loot;
    private final EmiStack inputStack;
    private final List<EmiStack> outputStacks;
    private final List<WidgetRowBuilder> rowBuilderList = new LinkedList<WidgetRowBuilder>();

    public BlockLootRecipe(ClientBlockLootTable loot) {
        this.loot = loot;
        ResourceLocation blockId = loot.blockId;
        Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(blockId);
        loot.build((Level)Minecraft.m_91087_().f_91073_, block);
        this.inputStack = block.m_5456_() == Items.f_41852_ ? new BlockStateEmiStack(block.m_49966_(), blockId) : EmiStack.of((ItemLike)block);
        LinkedList<EmiStack> list = new LinkedList<EmiStack>();
        loot.builtItems.forEach(builtPool -> {
            builtPool.stacks().forEach(stack -> list.addAll(stack.ingredient()));
            this.addWidgetBuilders((ClientBuiltPool)builtPool, false);
        });
        this.outputStacks = list;
    }

    private void addWidgetBuilders(ClientBuiltPool newPool, boolean recursive) {
        WidgetRowBuilder builder;
        boolean newBuilder = false;
        if (recursive || this.rowBuilderList.isEmpty()) {
            builder = new WidgetRowBuilder(115);
            newBuilder = true;
        } else {
            builder = this.rowBuilderList.get(this.rowBuilderList.size() - 1);
        }
        Optional<ClientBuiltPool> opt = builder.addAndTrim(newPool);
        if (newBuilder) {
            this.rowBuilderList.add(builder);
        }
        opt.ifPresent(clientMobBuiltPool -> this.addWidgetBuilders((ClientBuiltPool)clientMobBuiltPool, true));
    }

    public EmiRecipeCategory getCategory() {
        return EmiClientPlugin.BLOCK_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return new ResourceLocation("emi_loot", "/" + this.getCategory().id.m_135815_() + "/" + this.loot.id.m_135827_() + "/" + this.loot.id.m_135815_());
    }

    public List<EmiIngredient> getInputs() {
        return this.inputStack.getItemStack().m_41619_() ? Collections.emptyList() : List.of(this.inputStack);
    }

    public List<EmiIngredient> getCatalysts() {
        return super.getCatalysts();
    }

    public List<EmiStack> getOutputs() {
        return this.outputStacks;
    }

    public int getDisplayWidth() {
        return EMILoot.config.isTooltipStyle() ? 144 : 160;
    }

    public int getDisplayHeight() {
        if (EMILoot.config.isTooltipStyle()) {
            int stacks = this.outputStacks.size();
            if (stacks <= 5) {
                return 18;
            }
            if (EMILoot.config.isCompact(EMILoot.Type.BLOCK)) {
                int ingredients = 0;
                for (WidgetRowBuilder builder : this.rowBuilderList) {
                    ingredients += builder.ingredientCount();
                }
                if (ingredients <= 4) {
                    return 29;
                }
                return 18 + 18 * ((ingredients - 5) / 8 + 1);
            }
            return 18 + 18 * ((stacks - 6) / 8 + 1);
        }
        return 23 + 29 * (this.rowBuilderList.size() - 1);
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addSlot((EmiIngredient)this.inputStack, 0, 0);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 20, 0);
        int x = 46;
        int y = 0;
        if (EMILoot.config.isTooltipStyle()) {
            List stacks = this.outputStacks.size() <= 4 || !EMILoot.config.isCompact(EMILoot.Type.BLOCK) ? (List)this.rowBuilderList.stream().map(WidgetRowBuilder::stacks).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll) : (List)this.rowBuilderList.stream().map(WidgetRowBuilder::ingredients).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll);
            int i = 3;
            int j = 0;
            for (ConditionalStack stack : stacks) {
                SlotWidget widget = widgets.addSlot(stack.getIngredient(), i * 18, 18 * j);
                String rounded = FloatTrimmer.trimFloatString(stack.weight(), (Integer)EMILoot.config.chanceDecimalPlaces.get());
                widget.appendTooltip((Component)FcText.INSTANCE.translatable("emi_loot.percent_chance", new Object[]{rounded}));
                if (EMILoot.config.isNotPlain()) {
                    for (Tuple<Integer, Component> pair : stack.conditions()) {
                        widget.appendTooltip((Component)SymbolText.of((Integer)pair.m_14418_(), (Component)pair.m_14419_()));
                    }
                }
                if (++i <= 7) continue;
                i = 0;
                ++j;
            }
        } else {
            for (WidgetRowBuilder builder : this.rowBuilderList) {
                for (ClientBuiltPool pool : builder.getPoolList()) {
                    IconGroupEmiWidget widget = EMILootClientAgnos.createIconGroupEmiWidget(x, y, pool);
                    widgets.add((Widget)widget);
                    x += widget.getWidth() + 6;
                }
                y += 29;
                x = 46;
            }
        }
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    public boolean hideCraftable() {
        return super.hideCraftable();
    }
}

