/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.client;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.client.ClientArchaeologyLootTable;
import fzzyhmstrs.emi_loot.client.ClientBlockLootTable;
import fzzyhmstrs.emi_loot.client.ClientChestLootTable;
import fzzyhmstrs.emi_loot.client.ClientGameplayLootTable;
import fzzyhmstrs.emi_loot.client.ClientMobLootTable;
import fzzyhmstrs.emi_loot.client.LootReceiver;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;

public class ClientLootTables {
    public static final ClientLootTables INSTANCE = new ClientLootTables();
    private final List<LootReceiver> loots = new LinkedList<LootReceiver>();

    public List<LootReceiver> getLoots() {
        return this.loots;
    }

    public void clearLoots() {
        this.loots.clear();
    }

    void receiveChestSender(FriendlyByteBuf buf) {
        LootReceiver table = ClientChestLootTable.INSTANCE.fromBuf(buf);
        this.loots.add(table);
        if (EMILoot.config.isDebug(EMILoot.Type.CHEST)) {
            EMILoot.LOGGER.info("received chest " + String.valueOf(table.getId()));
        }
    }

    void receiveBlockSender(FriendlyByteBuf buf) {
        LootReceiver table = ClientBlockLootTable.INSTANCE.fromBuf(buf);
        this.loots.add(table);
        if (EMILoot.config.isDebug(EMILoot.Type.BLOCK)) {
            EMILoot.LOGGER.info("received block " + String.valueOf(table.getId()));
        }
    }

    void receiveMobSender(FriendlyByteBuf buf) {
        LootReceiver table = ClientMobLootTable.INSTANCE.fromBuf(buf);
        this.loots.add(table);
        if (EMILoot.config.isDebug(EMILoot.Type.MOB)) {
            EMILoot.LOGGER.info("received mob " + String.valueOf(table.getId()));
        }
    }

    void receiveGameplaySender(FriendlyByteBuf buf) {
        LootReceiver table = ClientGameplayLootTable.INSTANCE.fromBuf(buf);
        this.loots.add(table);
        if (EMILoot.config.isDebug(EMILoot.Type.GAMEPLAY)) {
            EMILoot.LOGGER.info("received gameplay loot: " + String.valueOf(table.getId()));
        }
    }

    void receiveArchaeologySender(FriendlyByteBuf buf) {
        LootReceiver table = ClientArchaeologyLootTable.INSTANCE.fromBuf(buf);
        this.loots.add(table);
        if (EMILoot.config.isDebug(EMILoot.Type.ARCHAEOLOGY)) {
            EMILoot.LOGGER.info("received archaeology loot: " + String.valueOf(table.getId()));
        }
    }
}

