/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.EmiStackInteraction;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.bom.BoM;
import dev.emi.emi.chess.EmiChess;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.config.HeaderType;
import dev.emi.emi.config.HelpLevel;
import dev.emi.emi.config.Margins;
import dev.emi.emi.config.ScreenAlign;
import dev.emi.emi.config.SidebarPages;
import dev.emi.emi.config.SidebarSettings;
import dev.emi.emi.config.SidebarSide;
import dev.emi.emi.config.SidebarSubpanels;
import dev.emi.emi.config.SidebarTheme;
import dev.emi.emi.config.SidebarType;
import dev.emi.emi.input.EmiBind;
import dev.emi.emi.input.EmiInput;
import dev.emi.emi.mixin.accessor.HandledScreenAccessor;
import dev.emi.emi.network.CreateItemC2SPacket;
import dev.emi.emi.network.EmiNetwork;
import dev.emi.emi.platform.EmiClient;
import dev.emi.emi.registry.EmiDragDropHandlers;
import dev.emi.emi.registry.EmiExclusionAreas;
import dev.emi.emi.registry.EmiRecipeFiller;
import dev.emi.emi.registry.EmiRecipes;
import dev.emi.emi.registry.EmiStackProviders;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.runtime.EmiFavorite;
import dev.emi.emi.runtime.EmiFavorites;
import dev.emi.emi.runtime.EmiHidden;
import dev.emi.emi.runtime.EmiHistory;
import dev.emi.emi.runtime.EmiLog;
import dev.emi.emi.runtime.EmiProfiler;
import dev.emi.emi.runtime.EmiReloadLog;
import dev.emi.emi.runtime.EmiReloadManager;
import dev.emi.emi.runtime.EmiSidebars;
import dev.emi.emi.screen.ConfigScreen;
import dev.emi.emi.screen.DisabledToast;
import dev.emi.emi.screen.EmiScreenBase;
import dev.emi.emi.screen.StackBatcher;
import dev.emi.emi.screen.tooltip.RecipeTooltipComponent;
import dev.emi.emi.screen.widget.EmiSearchWidget;
import dev.emi.emi.screen.widget.SidebarButtonWidget;
import dev.emi.emi.screen.widget.SizedButtonWidget;
import dev.emi.emi.search.EmiSearch;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class EmiScreenManager {
    private static final int PADDING_SIZE = 1;
    private static final int ENTRY_SIZE = 18;
    private static final int SUBPANEL_SEPARATOR_SIZE = 3;
    private static Minecraft client = Minecraft.m_91087_();
    private static List<? extends EmiIngredient> searchedStacks = List.of();
    private static int lastWidth;
    private static int lastHeight;
    private static List<Bounds> lastExclusion;
    private static StackBatcher.ClaimedCollection batchers;
    private static List<SidebarPanel> panels;
    public static ItemStack lastStackTooltipRendered;
    private static long lastPlayerInventorySync;
    public static EmiPlayerInventory lastPlayerInventory;
    public static int lastMouseX;
    public static int lastMouseY;
    public static EmiIngredient pressedStack;
    public static EmiIngredient draggedStack;
    private static EmiStackInteraction lastHoveredCraftable;
    private static boolean lastHoveredCraftableSturdy;
    private static int lastHoveredCraftableOffset;
    private static double scrollAcc;
    public static EmiSearchWidget search;
    public static SizedButtonWidget emi;
    public static SizedButtonWidget tree;

    public static boolean isDisabled() {
        return !EmiReloadManager.isLoaded() || !EmiConfig.enabled;
    }

    public static void recalculate() {
        EmiScreenBase base;
        EmiScreenManager.updateCraftables();
        SidebarPanel searchPanel = EmiScreenManager.getSearchPanel();
        if (searchPanel != null && searchPanel.space != null && searchedStacks != EmiSearch.stacks) {
            searchPanel.space.batcher.repopulate();
            searchedStacks = EmiSearch.stacks;
        }
        if ((base = EmiScreenBase.getCurrent()) == null) {
            return;
        }
        Screen screen = base.screen();
        List<Bounds> exclusion = EmiExclusionAreas.getExclusion(base);
        if (lastWidth == screen.f_96543_ && lastHeight == screen.f_96544_ && exclusion.size() == lastExclusion.size()) {
            boolean same = true;
            for (int i = 0; i < exclusion.size(); ++i) {
                Bounds a = exclusion.get(i);
                Bounds b = lastExclusion.get(i);
                if (a.x() == b.x() && a.y() == b.y() && a.width() == b.width() && a.height() == b.height()) continue;
                same = false;
                break;
            }
            if (same) {
                return;
            }
        }
        for (SidebarPanel panel : panels) {
            for (ScreenSpace space : panel.getSpaces()) {
                space.batcher.repopulate();
            }
        }
        lastWidth = screen.f_96543_;
        lastHeight = screen.f_96544_;
        lastExclusion = exclusion;
        Bounds bounds = base.bounds();
        int left = Math.max(36, bounds.left());
        int right = Math.min(screen.f_96543_ - 36, bounds.right());
        int top = bounds.left();
        int bottom = bounds.bottom();
        batchers.unclaimAll();
        ArrayList spaceExclusion = Lists.newArrayList();
        spaceExclusion.addAll(exclusion);
        EmiScreenManager.createScreenSpace(panels.get(0), screen, spaceExclusion, false, new Bounds(0, 0, left, screen.f_96544_), SidebarSettings.LEFT);
        EmiScreenManager.createScreenSpace(panels.get(1), screen, spaceExclusion, true, new Bounds(right, 0, screen.f_96543_ - right, screen.f_96544_), SidebarSettings.RIGHT);
        spaceExclusion = Lists.newArrayList();
        if (panels.get(0).isVisible()) {
            spaceExclusion.add(panels.get(0).getBounds());
        }
        if (panels.get(1).isVisible()) {
            spaceExclusion.add(panels.get(1).getBounds());
        }
        spaceExclusion.addAll(exclusion);
        int topCenter = EmiConfig.topSidebarSize.values.getInt(0) * 18 / 2 + EmiConfig.topSidebarTheme.horizontalPadding;
        int topSpaceBottom = switch (EmiConfig.topSidebarAlign.horizontal) {
            default -> throw new IncompatibleClassChangeError();
            case ScreenAlign.Horizontal.LEFT -> EmiScreenManager.getVerticalConstraint(panels.get(0), EmiConfig.topSidebarMargins.left() + topCenter, top, screen.f_96544_, true);
            case ScreenAlign.Horizontal.CENTER -> top;
            case ScreenAlign.Horizontal.RIGHT -> EmiScreenManager.getVerticalConstraint(panels.get(1), right - EmiConfig.topSidebarMargins.right() + topCenter, top, screen.f_96544_, true);
        };
        boolean topRtl = EmiConfig.topSidebarAlign.horizontal == ScreenAlign.Horizontal.RIGHT;
        EmiScreenManager.createScreenSpace(panels.get(2), screen, spaceExclusion, topRtl, new Bounds(0, 0, screen.f_96543_, topSpaceBottom), SidebarSettings.TOP);
        int bottomCenter = EmiConfig.bottomSidebarSize.values.getInt(0) * 18 / 2 + EmiConfig.bottomSidebarTheme.horizontalPadding;
        int bottomSpaceTop = switch (EmiConfig.bottomSidebarAlign.horizontal) {
            default -> throw new IncompatibleClassChangeError();
            case ScreenAlign.Horizontal.LEFT -> EmiScreenManager.getVerticalConstraint(panels.get(0), EmiConfig.bottomSidebarMargins.left() + bottomCenter, bottom, 0, false);
            case ScreenAlign.Horizontal.CENTER -> bottom;
            case ScreenAlign.Horizontal.RIGHT -> EmiScreenManager.getVerticalConstraint(panels.get(1), EmiConfig.bottomSidebarMargins.right() + bottomCenter, bottom, 0, false);
        };
        boolean bottomRtl = EmiConfig.bottomSidebarAlign.horizontal == ScreenAlign.Horizontal.RIGHT;
        EmiScreenManager.createScreenSpace(panels.get(3), screen, spaceExclusion, bottomRtl, new Bounds(0, bottomSpaceTop, screen.f_96543_, screen.f_96544_ - bottomSpaceTop), SidebarSettings.BOTTOM);
        EmiScreenManager.updateSidebarButtons();
    }

    private static void updateCraftables() {
        int minDelay = 400;
        if (EmiScreenManager.hasSidebarVisible(SidebarType.CRAFTABLES)) {
            minDelay = 50;
        }
        if (lastPlayerInventory == null || Math.abs(System.currentTimeMillis() - lastPlayerInventorySync) >= (long)minDelay) {
            lastPlayerInventorySync = System.currentTimeMillis();
            EmiPlayerInventory inv = EmiPlayerInventory.of((Player)EmiScreenManager.client.f_91074_);
            SidebarPanel searchPanel = EmiScreenManager.getSearchPanel();
            if (!inv.isEqual(lastPlayerInventory)) {
                lastPlayerInventory = inv;
                EmiSidebars.craftables = lastPlayerInventory.getCraftables();
                if (searchPanel != null && searchPanel.space != null) {
                    searchPanel.space.batcher.repopulate();
                    if (searchPanel.getType() == SidebarType.CRAFTABLES) {
                        EmiSearch.update();
                    }
                }
                EmiFavorites.updateSynthetic(inv);
                EmiScreenManager.repopulatePanels(SidebarType.CRAFTABLES);
            }
        }
    }

    public static void forceRecalculate() {
        lastWidth = -1;
        lastPlayerInventory = null;
        EmiScreenManager.recalculate();
    }

    private static int getVerticalConstraint(SidebarPanel panel, int cx, int def, int max, boolean top) {
        Bounds bounds;
        if (panel.isVisible() && (bounds = panel.getBounds()).x() <= cx && bounds.right() >= cx) {
            return top ? Math.max(def, bounds.top()) : Math.min(def, bounds.bottom());
        }
        return max;
    }

    private static void createScreenSpace(SidebarPanel panel, Screen screen, List<Bounds> exclusion, boolean rtl, Bounds bounds, SidebarSettings settings) {
        Margins margins = settings.margins();
        ScreenAlign align = settings.align();
        SidebarTheme theme = settings.theme();
        SidebarSubpanels subpanels = settings.subpanels();
        boolean header = settings.header() == HeaderType.VISIBLE;
        int maxWidth = settings.size().values.getInt(0);
        int maxHeight = settings.size().values.getInt(1);
        int subpanelHeight = 0;
        for (SidebarSubpanels.Subpanel subpanel : subpanels.subpanels) {
            subpanelHeight += subpanel.rows() * 18 + 3;
            maxHeight -= subpanel.rows();
        }
        if (panel.getType() == SidebarType.CHESS) {
            maxWidth = 8;
            maxHeight = 8;
            theme = SidebarTheme.MODERN;
        }
        int cx = bounds.x() + bounds.width() / 2;
        int cy = bounds.y() + bounds.height() / 2;
        int headerOffset = header ? 18 : 0;
        int idealWidth = Math.min(maxWidth * 18 + margins.left() + margins.right() + theme.horizontalPadding * 2, bounds.width());
        int idealHeight = Math.min(maxHeight * 18 + margins.top() + margins.bottom() + theme.verticalPadding * 2 + headerOffset + subpanelHeight, bounds.height());
        int idealX = switch (align.horizontal) {
            default -> throw new IncompatibleClassChangeError();
            case ScreenAlign.Horizontal.LEFT -> bounds.x();
            case ScreenAlign.Horizontal.CENTER -> bounds.x() + bounds.width() / 2 - idealWidth / 2;
            case ScreenAlign.Horizontal.RIGHT -> bounds.right() - idealWidth;
        };
        int idealY = switch (align.horizontal) {
            default -> throw new IncompatibleClassChangeError();
            case ScreenAlign.Horizontal.LEFT -> bounds.y();
            case ScreenAlign.Horizontal.CENTER -> bounds.y() + bounds.height() / 2 - idealHeight / 2;
            case ScreenAlign.Horizontal.RIGHT -> bounds.bottom() - idealHeight;
        };
        Bounds idealBounds = EmiScreenManager.constrainBounds(exclusion, new Bounds(idealX, idealY, idealWidth, idealHeight), align, headerOffset);
        bounds = EmiScreenManager.constrainBounds(exclusion, bounds, align, headerOffset);
        if (Math.min(idealWidth, idealBounds.width()) * Math.min(idealHeight, idealBounds.height()) > Math.min(idealWidth, bounds.width()) * Math.min(idealHeight, bounds.height())) {
            bounds = idealBounds;
        }
        int xMin = bounds.left() + margins.left() + theme.horizontalPadding;
        int xMax = bounds.right() - margins.right() - theme.horizontalPadding;
        int yMin = bounds.top() + margins.top() + theme.verticalPadding;
        int yMax = bounds.bottom() - margins.bottom() - theme.verticalPadding;
        int xSpan = xMax - xMin;
        int ySpan = yMax - yMin;
        int tw = Math.max(0, Math.min(xSpan / 18, maxWidth));
        int th = Math.max(0, Math.min((ySpan - headerOffset - subpanelHeight) / 18, maxHeight));
        int hl = xMin;
        int hr = xMax - tw * 18;
        int tx = switch (align.horizontal) {
            default -> throw new IncompatibleClassChangeError();
            case ScreenAlign.Horizontal.LEFT -> hl;
            case ScreenAlign.Horizontal.CENTER -> Mth.m_14045_((int)(cx - tw * 18 / 2), (int)hl, (int)hr);
            case ScreenAlign.Horizontal.RIGHT -> hr;
        };
        int vt = yMin + headerOffset;
        int vb = yMax - th * 18 - subpanelHeight;
        int ty = switch (align.vertical) {
            default -> throw new IncompatibleClassChangeError();
            case ScreenAlign.Vertical.TOP -> vt;
            case ScreenAlign.Vertical.CENTER -> Mth.m_14045_((int)(cy - (th * 18 - headerOffset + subpanelHeight + theme.verticalPadding / 2) / 2), (int)vt, (int)vb);
            case ScreenAlign.Vertical.BOTTOM -> vb;
        };
        panel.header = header;
        panel.theme = theme;
        ScreenSpace space = new ScreenSpace(tx, ty, tw, th, rtl, exclusion, () -> panel.getType(), panel.isSearch());
        ArrayList subspaces = Lists.newArrayList();
        for (SidebarSubpanels.Subpanel subpanel : subpanels.subpanels) {
            th = subpanel.rows();
            subspaces.add(new ScreenSpace(tx, ty += th * 18 + 3, tw, th, rtl, exclusion, () -> subpanel.type, false));
        }
        panel.setSpaces(space, subspaces);
    }

    private static Bounds constrainBounds(List<Bounds> exclusion, Bounds bounds, ScreenAlign align, int headerOffset) {
        for (int i = 0; i < exclusion.size(); ++i) {
            Bounds overlap = exclusion.get(i).overlap(bounds);
            if (overlap.empty() || bounds.empty() || overlap.top() >= bounds.top() + 18 + headerOffset && overlap.width() < bounds.width() * 2 / 3 && overlap.height() < bounds.height() / 3) continue;
            int widthFactor = overlap.width() * 10 / bounds.width();
            int heightFactor = overlap.height() * 10 / bounds.height();
            if (heightFactor < widthFactor) {
                int cy = bounds.y() + bounds.height() / 2;
                int ocy = overlap.y() + overlap.height() / 2;
                bounds = (cy += (switch (align.vertical) {
                    default -> throw new IncompatibleClassChangeError();
                    case ScreenAlign.Vertical.TOP -> -bounds.height() / 4;
                    case ScreenAlign.Vertical.CENTER -> 0;
                    case ScreenAlign.Vertical.BOTTOM -> bounds.height() / 4;
                })) < ocy ? new Bounds(bounds.x(), bounds.y(), bounds.width(), overlap.top() - bounds.top()) : new Bounds(bounds.x(), overlap.bottom(), bounds.width(), bounds.bottom() - overlap.bottom());
            } else {
                int cx = bounds.x() + bounds.width() / 2;
                int ocx = overlap.x() + overlap.width() / 2;
                bounds = (cx += (switch (align.horizontal) {
                    default -> throw new IncompatibleClassChangeError();
                    case ScreenAlign.Horizontal.LEFT -> -bounds.width() / 4;
                    case ScreenAlign.Horizontal.CENTER -> 0;
                    case ScreenAlign.Horizontal.RIGHT -> bounds.width() / 4;
                })) < ocx ? new Bounds(bounds.x(), bounds.y(), overlap.left() - bounds.left(), bounds.height()) : new Bounds(overlap.right(), bounds.y(), bounds.right() - overlap.right(), bounds.height());
            }
            i = -1;
        }
        if (bounds.empty()) {
            return Bounds.EMPTY;
        }
        return bounds;
    }

    public static void focusSearchSidebarType(SidebarType type) {
        SidebarPanel search = EmiScreenManager.getSearchPanel();
        if (search != null && search.supportsType(type)) {
            search.setType(type);
        }
    }

    public static void focusSidebarType(SidebarType type) {
        for (SidebarPanel panel : panels) {
            if (!panel.supportsType(type)) continue;
            panel.setType(type);
        }
    }

    @Nullable
    public static SidebarPanel getPanelFor(SidebarSide side) {
        for (SidebarPanel panel : panels) {
            if (panel.side != side) continue;
            return panel;
        }
        return null;
    }

    @Nullable
    public static SidebarPanel getPanelFor(SidebarType type) {
        for (SidebarPanel panel : panels) {
            if (panel.getType() != type) continue;
            return panel;
        }
        return null;
    }

    @Nullable
    public static SidebarPanel getHoveredPanel(int mouseX, int mouseY) {
        for (SidebarPanel panel : panels) {
            if (!panel.getBounds().contains(mouseX, mouseY) || !panel.isVisible()) continue;
            return panel;
        }
        return null;
    }

    @Nullable
    public static ScreenSpace getHoveredSpace(int mouseX, int mouseY) {
        SidebarPanel panel = EmiScreenManager.getHoveredPanel(mouseX, mouseY);
        if (panel != null) {
            return panel.getHoveredSpace(mouseX, mouseY);
        }
        return null;
    }

    public static boolean hasSidebarVisible(SidebarType type) {
        for (SidebarPanel panel : panels) {
            for (ScreenSpace space : panel.getSpaces()) {
                if (type != space.getType()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasSidebarAvailable(SidebarType type) {
        for (SidebarPanel panel : panels) {
            if (!panel.supportsType(type)) continue;
            return true;
        }
        return false;
    }

    public static void repopulatePanels(SidebarType type) {
        for (SidebarPanel panel : panels) {
            for (ScreenSpace space : panel.getSpaces()) {
                if (space.getType() != type) continue;
                space.batcher.repopulate();
            }
        }
    }

    public static SidebarPanel getSearchPanel() {
        for (SidebarPanel panel : panels) {
            if (!panel.isSearch()) continue;
            return panel;
        }
        return null;
    }

    public static void toggleSidebarType(SidebarType type) {
        boolean visible = false;
        for (SidebarPanel panel : panels) {
            if (panel.getType() != type) continue;
            visible = true;
            panel.cycleType(1);
        }
        if (!visible) {
            EmiScreenManager.focusSidebarType(type);
        }
    }

    public static List<? extends EmiIngredient> getSearchSource() {
        SidebarPanel search = EmiScreenManager.getSearchPanel();
        if (search == null) {
            return List.of();
        }
        return EmiSidebars.getStacks(search.getType());
    }

    public static EmiStackInteraction getHoveredStack(int mouseX, int mouseY, boolean notClick) {
        return EmiScreenManager.getHoveredStack(mouseX, mouseY, notClick, false);
    }

    public static int getDebugTextX() {
        int x = 4;
        if (EmiScreenManager.emi.f_93624_) {
            x = Math.max(4, 26);
        }
        if (EmiScreenManager.tree.f_93624_) {
            x = Math.max(4, 48);
        }
        return x;
    }

    public static EmiStackInteraction getHoveredStack(int mouseX, int mouseY, boolean notClick, boolean ignoreLastHoveredCraftable) {
        if (EmiScreenManager.client.f_91080_ == null) {
            return EmiStackInteraction.EMPTY;
        }
        EmiStackInteraction stack = EmiStackProviders.getStackAt(EmiScreenManager.client.f_91080_, mouseX, mouseY, notClick);
        if (!stack.isEmpty()) {
            return stack;
        }
        if (!ignoreLastHoveredCraftable && lastHoveredCraftable != null) {
            if (lastHoveredCraftable.getRecipeContext() == null || !lastHoveredCraftableSturdy && lastPlayerInventory != null && !lastPlayerInventory.canCraft(lastHoveredCraftable.getRecipeContext())) {
                lastHoveredCraftable = null;
            } else {
                return lastHoveredCraftable;
            }
        }
        for (SidebarPanel panel : panels) {
            for (ScreenSpace space : panel.getSpaces()) {
                if (!panel.isVisible() || space.pageSize <= 0 || !space.contains(mouseX, mouseY) || mouseX < space.tx || mouseY < space.ty) continue;
                int x = (mouseX - space.tx) / 18;
                int y = (mouseY - space.ty) / 18;
                int n = space.getRawOffset(x, y);
                if (n >= 0 && space == panel.space) {
                    n += space.pageSize * panel.page;
                }
                if (n < 0 || n >= space.getStacks().size()) continue;
                EmiIngredient hovered = space.getStacks().get(n);
                if (hovered instanceof EmiFavorite) {
                    EmiFavorite fav = (EmiFavorite)hovered;
                    return new SidebarEmiStackInteraction(hovered, space, fav.getRecipe(), true);
                }
                return new SidebarEmiStackInteraction(hovered, space);
            }
        }
        if (lastStackTooltipRendered != null && notClick) {
            return new EmiStackInteraction(EmiStack.of(lastStackTooltipRendered));
        }
        return EmiStackInteraction.EMPTY;
    }

    private static void updateMouse(int mouseX, int mouseY) {
        if (lastHoveredCraftable != null) {
            ScreenSpace space = EmiScreenManager.getHoveredSpace(mouseX, mouseY);
            if (space != null && (space.getType() == SidebarType.CRAFTABLES || space.getType() == SidebarType.CRAFT_HISTORY)) {
                int offset = space.getRawOffsetFromMouse(mouseX, mouseY);
                if (offset != lastHoveredCraftableOffset) {
                    lastHoveredCraftable = null;
                }
            } else {
                lastHoveredCraftable = null;
            }
        }
        lastMouseX = mouseX;
        lastMouseY = mouseY;
    }

    public static void drawBackground(EmiDrawContext context, int mouseX, int mouseY, float delta) {
        EmiScreenManager.updateMouse(mouseX, mouseY);
        EmiScreenManager.recalculate();
        EmiScreenBase base = EmiScreenBase.getCurrent();
        if (base != null) {
            EmiProfiler.push("sidebar");
            for (SidebarPanel panel : panels) {
                panel.drawBackground(context, mouseX, mouseY, delta);
            }
        }
    }

    public static void render(EmiDrawContext context, int mouseX, int mouseY, float delta) {
        EmiProfiler.push("emi");
        EmiScreenManager.updateMouse(mouseX, mouseY);
        EmiScreenManager.recalculate();
        EmiScreenBase base = EmiScreenBase.getCurrent();
        if (base == null) {
            return;
        }
        boolean visible = !EmiScreenManager.isDisabled();
        EmiScreenManager.emi.f_93624_ = EmiConfig.emiConfigButtonVisibility.resolve(visible);
        EmiScreenManager.tree.f_93624_ = EmiConfig.recipeTreeButtonVisibility.resolve(visible);
        for (SidebarPanel panel : panels) {
            panel.updateWidgetVisibility();
        }
        EmiScreenManager.renderWidgets(context, mouseX, mouseY, delta, base);
        if (EmiScreenManager.isDisabled()) {
            int screenHeight = base.screen().f_96544_;
            if (!EmiReloadManager.isLoaded()) {
                int reloadInfoX = EmiScreenManager.getDebugTextX();
                if (EmiReloadManager.getStatus() == -1) {
                    context.drawTextWithShadow((Component)EmiPort.translatable("emi.reloading.error"), reloadInfoX, screenHeight - 16);
                } else if (EmiReloadManager.getStatus() == 0) {
                    context.drawTextWithShadow((Component)EmiPort.translatable("emi.reloading.waiting"), reloadInfoX, screenHeight - 16);
                } else {
                    context.drawTextWithShadow((Component)EmiPort.translatable("emi.reloading"), reloadInfoX, screenHeight - 16);
                    context.drawTextWithShadow(EmiReloadManager.reloadStep, reloadInfoX, screenHeight - 26);
                    if (System.currentTimeMillis() > EmiReloadManager.reloadWorry) {
                        context.drawTextWithShadow((Component)EmiPort.translatable("emi.reloading.worry"), reloadInfoX, screenHeight - 36);
                    }
                }
            }
            EmiProfiler.pop();
            lastHoveredCraftable = null;
            return;
        }
        if (EmiRecipes.activeWorker != null) {
            int bakingX = EmiScreenManager.getDebugTextX();
            context.drawTextWithShadow((Component)EmiPort.translatable("emi.reloading.still_baking_recipes"), bakingX, base.screen().f_96544_ - 16);
        } else {
            EmiScreenManager.renderDevMode(context, mouseX, mouseY, delta, base);
        }
        EmiProfiler.push("sidebars");
        for (SidebarPanel panel : panels) {
            panel.render(context, mouseX, mouseY, delta);
        }
        EmiScreenManager.renderLastHoveredCraftable(context, mouseX, mouseY, delta, base);
        EmiProfiler.pop();
        EmiScreenManager.renderExclusionAreas(context, mouseX, mouseY, delta, base);
        EmiProfiler.swap("slots");
        EmiScreenManager.renderSlotOverlays(context, mouseX, mouseY, delta, base);
        EmiProfiler.pop();
        RenderSystem.disableDepthTest();
    }

    public static void drawForeground(EmiDrawContext context, int mouseX, int mouseY, float delta) {
        EmiScreenBase base = EmiScreenBase.getCurrent();
        if (base != null && !EmiScreenManager.isDisabled()) {
            EmiScreenManager.renderDraggedStack(context, mouseX, mouseY, delta, base);
            EmiScreenManager.renderCurrentTooltip(context, mouseX, mouseY, delta, base);
        }
    }

    private static void renderWidgets(EmiDrawContext context, int mouseX, int mouseY, float delta, EmiScreenBase base) {
        context.push();
        context.matrices().m_252880_(0.0f, 0.0f, 100.0f);
        emi.m_88315_(context.raw(), mouseX, mouseY, delta);
        tree.m_88315_(context.raw(), mouseX, mouseY, delta);
        search.m_88315_(context.raw(), mouseX, mouseY, delta);
        context.pop();
    }

    private static void renderLastHoveredCraftable(EmiDrawContext context, int mouseX, int mouseY, float delta, EmiScreenBase base) {
        ScreenSpace space;
        EmiStackInteraction cur;
        if (lastHoveredCraftable != null && lastHoveredCraftableOffset != -1 && (cur = EmiScreenManager.getHoveredStack(mouseX, mouseY, false, true)).getRecipeContext() != lastHoveredCraftable.getRecipeContext() && (space = EmiScreenManager.getHoveredSpace(mouseX, mouseY)) != null && (space.getType() == SidebarType.CRAFTABLES || space.getType() == SidebarType.CRAFT_HISTORY)) {
            PoseStack view = RenderSystem.getModelViewStack();
            view.m_85836_();
            view.m_252880_(0.0f, 0.0f, 200.0f);
            EmiPort.applyModelViewMatrix();
            int lhx = space.getRawX(lastHoveredCraftableOffset);
            int lhy = space.getRawY(lastHoveredCraftableOffset);
            context.fill(lhx, lhy, 18, 18, 1151992063);
            lastHoveredCraftable.getStack().render(context.raw(), lhx + 1, lhy + 1, delta, 1);
            view.m_85849_();
            EmiPort.applyModelViewMatrix();
        }
    }

    private static void renderDraggedStack(EmiDrawContext context, int mouseX, int mouseY, float delta, EmiScreenBase base) {
        if (!draggedStack.isEmpty()) {
            ScreenSpace space;
            SidebarPanel panel = EmiScreenManager.getHoveredPanel(mouseX, mouseY);
            if (panel != null && (space = panel.getHoveredSpace(mouseX, mouseY)) != null && space.getType() == SidebarType.FAVORITES) {
                int pageSize = space.pageSize;
                int page = panel.page;
                int index = space.getClosestEdge(mouseX, mouseY);
                if (index + pageSize * page > EmiFavorites.favorites.size()) {
                    index = EmiFavorites.favorites.size() - pageSize * page;
                }
                if (index + pageSize * page > space.getStacks().size()) {
                    index = space.getStacks().size() - pageSize * page;
                }
                if (index >= 0) {
                    context.push();
                    context.matrices().m_252880_(0.0f, 0.0f, 200.0f);
                    int dx = space.getEdgeX(index);
                    int dy = space.getEdgeY(index);
                    context.fill(dx - 1, dy, 2, 18, -16711681);
                    context.pop();
                }
            }
            context.push();
            context.matrices().m_252880_(0.0f, 0.0f, 400.0f);
            EmiDragDropHandlers.render(base.screen(), draggedStack, context.raw(), mouseX, mouseY, delta);
            draggedStack.render(context.raw(), mouseX - 8, mouseY - 8, delta, 1);
            context.pop();
        }
    }

    private static void renderCurrentTooltip(EmiDrawContext context, int mouseX, int mouseY, float delta, EmiScreenBase base) {
        ItemStack cursor = ItemStack.f_41583_;
        Screen screen = EmiScreenManager.client.f_91080_;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen handled = (AbstractContainerScreen)screen;
            cursor = handled.m_6262_().m_142621_();
        }
        ScreenSpace space = EmiScreenManager.getHoveredSpace(mouseX, mouseY);
        if (EmiConfig.cheatMode && !cursor.m_41619_() && space != null && space.getType() == SidebarType.INDEX && EmiConfig.deleteCursorStack.isBound()) {
            List<ClientTooltipComponent> list = List.of(ClientTooltipComponent.m_169948_((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.translatable("emi.delete_stack"))), ClientTooltipComponent.m_169948_((FormattedCharSequence)EmiPort.ordered(EmiConfig.deleteCursorStack.getBindText())));
            if (space.rtl) {
                EmiRenderHelper.drawLeftTooltip(base.screen(), context, list, mouseX, mouseY);
            } else {
                EmiRenderHelper.drawTooltip(base.screen(), context, list, mouseX, mouseY);
            }
        }
        if (cursor.m_41619_() && draggedStack.isEmpty()) {
            EmiRecipe recipe;
            EmiProfiler.swap("hover");
            EmiIngredient hov = EmiStack.EMPTY;
            SidebarType sidebar = SidebarType.NONE;
            EmiStackInteraction emiStackInteraction = EmiScreenManager.getHoveredStack(mouseX, mouseY, false);
            if (emiStackInteraction instanceof SidebarEmiStackInteraction) {
                SidebarEmiStackInteraction sesi = (SidebarEmiStackInteraction)emiStackInteraction;
                hov = sesi.getStack();
                sidebar = sesi.getType();
            }
            ArrayList list = Lists.newArrayList();
            list.addAll(hov.getTooltip());
            if (EmiApi.getRecipeContext(hov) == null && EmiConfig.showCraft.isHeld() && (recipe = EmiUtil.getPreferredRecipe(hov, lastPlayerInventory, false)) != null) {
                list.add(new RecipeTooltipComponent(recipe, true));
            }
            if (EmiConfig.editMode && sidebar == SidebarType.INDEX) {
                list.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)EmiPort.translatable("emi.edit_mode.hide_one", EmiConfig.hideStack.getBindText()).m_7532_()));
                list.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)EmiPort.translatable("emi.edit_mode.hide_all", EmiConfig.hideStackById.getBindText()).m_7532_()));
            }
            if (space != null && space.rtl) {
                EmiRenderHelper.drawLeftTooltip(base.screen(), context, list, mouseX, mouseY);
            } else {
                EmiRenderHelper.drawTooltip(base.screen(), context, list, mouseX, mouseY);
            }
            EmiProfiler.pop();
        }
        lastStackTooltipRendered = null;
    }

    private static void renderDevMode(EmiDrawContext context, int mouseX, int mouseY, float delta, EmiScreenBase base) {
        if (EmiConfig.devMode) {
            Screen screen = base.screen();
            EmiProfiler.swap("dev");
            int color = 0xFFFFFF;
            MutableComponent title = EmiPort.literal("EMI Dev Mode");
            int off = -16;
            int devTextX = EmiScreenManager.getDebugTextX();
            if (!EmiReloadLog.warnings.isEmpty()) {
                color = 0xFF0000;
                off = -11;
                String warnCount = EmiReloadLog.warningCount + " Warnings";
                context.drawTextWithShadow((Component)EmiPort.literal(warnCount), devTextX, screen.f_96544_ - 21, color);
                int width = Math.max(EmiScreenManager.client.f_91062_.m_92852_((FormattedText)title), EmiScreenManager.client.f_91062_.m_92895_(warnCount));
                if (mouseX >= devTextX && mouseX < width + devTextX && mouseY > screen.f_96544_ - 28) {
                    context.raw().m_280666_(EmiScreenManager.client.f_91062_, Stream.concat(Stream.of(" EMI detected some issues, see log for full details"), EmiReloadLog.warnings.stream()).map(s -> {
                        Object a = s;
                        if (((String)a).length() > 10 && EmiScreenManager.client.f_91062_.m_92895_((String)a) > screen.f_96543_ - 20) {
                            a = EmiScreenManager.client.f_91062_.m_92834_((String)a, screen.f_96543_ - 30) + "...";
                        }
                        return EmiPort.literal((String)a);
                    }).collect(Collectors.toList()), 0, 20);
                }
            }
            context.drawTextWithShadow((Component)title, devTextX, screen.f_96544_ + off, color);
        }
    }

    private static void renderExclusionAreas(EmiDrawContext context, int mouseX, int mouseY, float delta, EmiScreenBase base) {
        if (EmiConfig.highlightExclusionAreas) {
            for (SidebarPanel panel : panels) {
                if (!panel.isVisible()) continue;
                Bounds bounds = panel.getBounds();
                context.fill(bounds.left(), bounds.top(), bounds.width(), bounds.height(), 0x440000FF);
            }
            List<Bounds> exclusions = EmiExclusionAreas.getExclusion(base);
            if (exclusions.size() == 0) {
                return;
            }
            for (int i = 0; i < exclusions.size(); ++i) {
                Bounds b = exclusions.get(i);
                context.fill(b.x(), b.y(), b.width(), b.height(), i == 0 ? 0x4400FF00 : 0x44FF0000);
            }
        }
    }

    private static void renderSlotOverlays(EmiDrawContext context, int mouseX, int mouseY, float delta, EmiScreenBase base) {
        AbstractContainerScreen hs;
        Object object;
        EmiSearch.CompiledQuery query = null;
        if (EmiScreenManager.search.highlight) {
            query = EmiSearch.compiledQuery;
        }
        HashSet ignoredSlots = Sets.newHashSet();
        HashSet synfavs = Sets.newHashSet();
        if (BoM.craftingMode && BoM.tree != null) {
            List<EmiFavorite.Synthetic> syntheticFavorites = EmiFavorites.syntheticFavorites;
            for (EmiFavorite.Synthetic fav : syntheticFavorites) {
                synfavs.addAll(fav.getEmiStacks());
            }
            try {
                AbstractContainerScreen<?> hs2 = EmiApi.getHandledScreen();
                object = EmiRecipeFiller.getAllHandlers(hs2).iterator();
                while (object.hasNext()) {
                    EmiRecipeHandler handler = (EmiRecipeHandler)object.next();
                    if (!(handler instanceof StandardRecipeHandler)) continue;
                    StandardRecipeHandler standard = (StandardRecipeHandler)handler;
                    ignoredSlots.addAll(standard.getInputSources(hs2.m_6262_()));
                    ignoredSlots.addAll(standard.getCraftingSlots(hs2.m_6262_()));
                }
            }
            catch (Throwable t) {
                EmiLog.error("Recipe handler is throwing in renderSlotOverlays:");
                EmiLog.error(t);
            }
        }
        if ((object = base.screen()) instanceof AbstractContainerScreen && (hs = (AbstractContainerScreen)object) instanceof HandledScreenAccessor) {
            HandledScreenAccessor hsa = (HandledScreenAccessor)hs;
            context.push();
            context.matrices().m_252880_((float)hsa.getX(), (float)hsa.getY(), 0.0f);
            for (Slot slot : hs.m_6262_().f_38839_) {
                if (!slot.m_6659_()) continue;
                EmiStack stack = EmiStack.of(slot.m_7993_());
                context.push();
                context.matrices().m_252880_(0.0f, 0.0f, 300.0f);
                if (query != null) {
                    if (!query.test(stack)) {
                        context.fill(slot.f_40220_ - 1, slot.f_40221_ - 1, 18, 18, 0x77000000);
                    }
                } else if (BoM.craftingMode && BoM.tree != null && !(slot.f_40218_ instanceof Inventory) && !ignoredSlots.contains(slot) && synfavs.contains(stack)) {
                    context.fill(slot.f_40220_ - 1, slot.f_40221_ - 1, 18, 18, 1996536831);
                }
                context.pop();
            }
            context.pop();
        }
    }

    public static void addWidgets(Screen screen) {
        EmiScreenBase base = EmiScreenBase.getCurrent();
        if (base == null) {
            return;
        }
        EmiScreenManager.forceRecalculate();
        if (EmiConfig.centerSearchBar) {
            EmiScreenManager.search.f_93620_ = (screen.f_96543_ - 160) / 2;
            EmiScreenManager.search.f_93621_ = screen.f_96544_ - 21;
            search.m_93674_(160);
        } else if (EmiConfig.searchSidebar == SidebarSide.RIGHT) {
            EmiScreenManager.search.f_93620_ = EmiScreenManager.panels.get((int)1).space.tx;
            EmiScreenManager.search.f_93621_ = screen.f_96544_ - 21;
            search.m_93674_(EmiScreenManager.panels.get((int)1).space.tw * 18);
        } else {
            EmiScreenManager.search.f_93620_ = EmiScreenManager.panels.get((int)0).space.tx;
            EmiScreenManager.search.f_93621_ = screen.f_96544_ - 21 - 21;
            search.m_93674_(EmiScreenManager.panels.get((int)0).space.tw * 18);
        }
        EmiPort.focus(search, false);
        search.m_94194_(EmiConfig.searchSidebar != SidebarSide.NONE);
        EmiScreenManager.emi.f_93620_ = 2;
        EmiScreenManager.emi.f_93621_ = screen.f_96544_ - 22;
        EmiScreenManager.tree.f_93620_ = 24;
        EmiScreenManager.tree.f_93621_ = screen.f_96544_ - 22;
        EmiScreenManager.updateSidebarButtons();
    }

    private static void updateSidebarButtons() {
        for (SidebarPanel panel : panels) {
            panel.updateWidgetPosition();
            panel.updateWidgetVisibility();
        }
    }

    private static boolean isClickClicky(int button) {
        return button >= 0 && button < 3;
    }

    public static boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        int sa = (int)(scrollAcc += amount);
        scrollAcc %= 1.0;
        if (EmiScreenManager.isDisabled()) {
            return false;
        }
        EmiScreenManager.recalculate();
        SidebarPanel panel = EmiScreenManager.getHoveredPanel((int)mouseX, (int)mouseY);
        if (panel != null) {
            int mx = (int)mouseX;
            int my = (int)mouseY;
            for (Bounds bounds : EmiExclusionAreas.getExclusion(EmiScreenBase.getCurrent())) {
                if (!bounds.contains(mx, my)) continue;
                return false;
            }
            panel.scroll(-sa);
            return true;
        }
        return false;
    }

    public static boolean mouseClicked(double mouseX, double mouseY, int button) {
        EmiIngredient ingredient;
        EmiScreenBase base = EmiScreenBase.getCurrent();
        if (base == null) {
            return false;
        }
        if (search.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (emi.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (tree.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        for (SidebarPanel panel : panels) {
            if (panel.cycle.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            if (panel.pageLeft.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            if (!panel.pageRight.m_6375_(mouseX, mouseY, button)) continue;
            return true;
        }
        if (EmiScreenManager.isDisabled()) {
            if (EmiConfig.toggleVisibility.matchesMouse(button)) {
                EmiScreenManager.toggleVisibility(true);
                return true;
            }
            return false;
        }
        EmiScreenManager.recalculate();
        pressedStack = ingredient = EmiScreenManager.getHoveredStack((int)mouseX, (int)mouseY, !EmiScreenManager.isClickClicky(button)).getStack();
        return !ingredient.isEmpty() ? !(ingredient = EmiScreenManager.getHoveredStack((int)mouseX, (int)mouseY, false).getStack()).isEmpty() : EmiScreenManager.genericInteraction(bind -> bind.matchesMouse(button));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mouseReleased(double mouseX, double mouseY, int button) {
        EmiScreenBase base = EmiScreenBase.getCurrent();
        if (base == null) {
            return false;
        }
        try {
            if (EmiScreenManager.isDisabled()) {
                boolean bl = false;
                return bl;
            }
            int mx = (int)mouseX;
            int my = (int)mouseY;
            EmiScreenManager.recalculate();
            if (EmiConfig.cheatMode && EmiConfig.deleteCursorStack.matchesMouse(button) && EmiScreenManager.deleteCursor(mx, my)) {
                boolean bl = false;
                return bl;
            }
            SidebarPanel panel = EmiScreenManager.getHoveredPanel(mx, my);
            if (draggedStack == EmiStack.EMPTY && panel != null && panel.getType() == SidebarType.CHESS) {
                EmiChess.interact(pressedStack, button);
                boolean bl = true;
                return bl;
            }
            if (!pressedStack.isEmpty()) {
                if (!draggedStack.isEmpty()) {
                    if (panel != null) {
                        ScreenSpace space = panel.getHoveredSpace(mx, my);
                        if (space != null && space.getType() == SidebarType.FAVORITES) {
                            int page = panel.page;
                            int pageSize = space.pageSize;
                            int index = Math.min(space.getClosestEdge(mx, my), EmiFavorites.favorites.size());
                            if (index + pageSize * page > EmiFavorites.favorites.size()) {
                                index = EmiFavorites.favorites.size() - pageSize * page;
                            }
                            if (index >= 0) {
                                EmiFavorites.addFavoriteAt(draggedStack, index + pageSize * page);
                                space.batcher.repopulate();
                            }
                            boolean bl = true;
                            return bl;
                        }
                        if (panel.getType() == SidebarType.CHESS) {
                            EmiChess.drop(draggedStack, EmiScreenManager.getHoveredStack(mx, my, true).getStack());
                        }
                    } else if (EmiScreenManager.client.f_91080_ != null && EmiDragDropHandlers.dropStack(EmiScreenManager.client.f_91080_, draggedStack, mx, my)) {
                        boolean space = true;
                        return space;
                    }
                } else {
                    EmiStackInteraction hovered = EmiScreenManager.getHoveredStack((int)mouseX, (int)mouseY, !EmiScreenManager.isClickClicky(button));
                    if (draggedStack.isEmpty() && EmiScreenManager.stackInteraction(hovered, bind -> bind.matchesMouse(button))) {
                        boolean bl = true;
                        return bl;
                    }
                }
                if (EmiScreenManager.genericInteraction(bind -> bind.matchesMouse(button))) {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            pressedStack = EmiStack.EMPTY;
            draggedStack = EmiStack.EMPTY;
        }
    }

    public static boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        EmiScreenBase base = EmiScreenBase.getCurrent();
        if (base == null) {
            return false;
        }
        if (EmiScreenManager.isDisabled()) {
            return false;
        }
        if (draggedStack.isEmpty() && button == 0) {
            AbstractContainerScreen handled;
            Screen screen = EmiScreenManager.client.f_91080_;
            if (screen instanceof AbstractContainerScreen && !(handled = (AbstractContainerScreen)screen).m_6262_().m_142621_().m_41619_()) {
                return false;
            }
            EmiScreenManager.recalculate();
            EmiStackInteraction hovered = EmiScreenManager.getHoveredStack((int)mouseX, (int)mouseY, !EmiScreenManager.isClickClicky(button));
            if (hovered.getStack() != pressedStack && !(pressedStack instanceof EmiFavorite.Synthetic)) {
                draggedStack = pressedStack;
            }
        }
        return false;
    }

    public static boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        EmiScreenBase base = EmiScreenBase.getCurrent();
        if (base == null) {
            return false;
        }
        if (EmiScreenManager.isDisabled()) {
            if (EmiConfig.toggleVisibility.matchesKey(keyCode, scanCode)) {
                EmiScreenManager.toggleVisibility(true);
                return true;
            }
            return false;
        }
        if (search.m_7933_(keyCode, scanCode, modifiers) || search.m_94204_()) {
            return true;
        }
        if (EmiScreenManager.hasFocusedTextField((ContainerEventHandler)EmiScreenManager.client.f_91080_, 10)) {
            return false;
        }
        if (EmiConfig.cheatMode && EmiConfig.deleteCursorStack.matchesKey(keyCode, scanCode) && EmiScreenManager.deleteCursor(lastMouseX, lastMouseY)) {
            return true;
        }
        if (EmiInput.isControlDown() && keyCode == 89) {
            EmiApi.displayAllRecipes();
            return true;
        }
        EmiScreenManager.recalculate();
        if (EmiScreenManager.stackInteraction(EmiScreenManager.getHoveredStack(lastMouseX, lastMouseY, true), bind -> bind.matchesKey(keyCode, scanCode))) {
            return true;
        }
        return EmiScreenManager.genericInteraction(bind -> bind.matchesKey(keyCode, scanCode));
    }

    private static boolean hasFocusedTextField(ContainerEventHandler parent, int depthBail) {
        if (depthBail <= 0) {
            return false;
        }
        for (GuiEventListener e : parent.m_6702_()) {
            EditBox tfw;
            if (e instanceof EditBox && (tfw = (EditBox)e).m_94204_() && tfw.f_93624_) {
                return true;
            }
            if (!(e instanceof ContainerEventHandler)) continue;
            ContainerEventHandler p = (ContainerEventHandler)e;
            return EmiScreenManager.hasFocusedTextField(p, depthBail - 1);
        }
        return false;
    }

    public static boolean genericInteraction(Function<EmiBind, Boolean> function) {
        if (function.apply(EmiConfig.toggleVisibility).booleanValue()) {
            EmiScreenManager.toggleVisibility(true);
            return true;
        }
        boolean searchBreak = false;
        if (function.apply(EmiConfig.focusSearch).booleanValue() && EmiScreenManager.client.f_91080_ != null) {
            EmiScreenManager.client.f_91080_.m_7522_((GuiEventListener)search);
            EmiPort.focus(search, true);
            searchBreak = true;
        }
        if (function.apply(EmiConfig.clearSearch).booleanValue()) {
            search.m_94144_("");
            searchBreak = true;
        }
        if (searchBreak) {
            return true;
        }
        if (function.apply(EmiConfig.viewTree).booleanValue()) {
            EmiApi.viewRecipeTree();
            return true;
        }
        if (function.apply(EmiConfig.back).booleanValue()) {
            if (!EmiHistory.isEmpty()) {
                EmiHistory.pop();
                return true;
            }
        } else if (function.apply(EmiConfig.forward).booleanValue() && !EmiHistory.isForwardEmpty()) {
            EmiHistory.forward();
            return true;
        }
        return false;
    }

    public static boolean stackInteraction(EmiStackInteraction stack, Function<EmiBind, Boolean> function) {
        EmiIngredient ingredient = stack.getStack();
        EmiRecipe context = EmiApi.getRecipeContext(ingredient);
        if (!ingredient.isEmpty()) {
            SidebarEmiStackInteraction sesi;
            if (EmiConfig.editMode && stack instanceof SidebarEmiStackInteraction && (sesi = (SidebarEmiStackInteraction)stack).getType() == SidebarType.INDEX) {
                if (function.apply(EmiConfig.hideStack).booleanValue()) {
                    EmiHidden.setVisibility(sesi.getStack(), !EmiHidden.isHidden(sesi.getStack()), false);
                    return true;
                }
                if (function.apply(EmiConfig.hideStackById).booleanValue()) {
                    EmiHidden.setVisibility(sesi.getStack(), !EmiHidden.isHidden(sesi.getStack()), true);
                    return true;
                }
            }
            if (EmiScreenManager.craftInteraction(ingredient, () -> context, stack, function)) {
                return true;
            }
            if (EmiConfig.cheatMode && ingredient.getEmiStacks().size() == 1 && stack instanceof SidebarEmiStackInteraction) {
                if (function.apply(EmiConfig.cheatOneToInventory).booleanValue()) {
                    return EmiScreenManager.give(ingredient.getEmiStacks().get(0), 1, 0);
                }
                if (function.apply(EmiConfig.cheatStackToInventory).booleanValue()) {
                    return EmiScreenManager.give(ingredient.getEmiStacks().get(0), ingredient.getEmiStacks().get(0).getItemStack().m_41741_(), 0);
                }
                if (function.apply(EmiConfig.cheatOneToCursor).booleanValue()) {
                    return EmiScreenManager.give(ingredient.getEmiStacks().get(0), 1, 1);
                }
                if (function.apply(EmiConfig.cheatStackToCursor).booleanValue()) {
                    return EmiScreenManager.give(ingredient.getEmiStacks().get(0), ingredient.getEmiStacks().get(0).getItemStack().m_41741_(), 1);
                }
            }
            if (function.apply(EmiConfig.viewRecipes).booleanValue()) {
                EmiApi.displayRecipes(ingredient);
                if (stack.getRecipeContext() != null) {
                    EmiApi.focusRecipe(stack.getRecipeContext());
                }
                return true;
            }
            if (function.apply(EmiConfig.viewUses).booleanValue()) {
                EmiApi.displayUses(ingredient);
                return true;
            }
            if (function.apply(EmiConfig.favorite).booleanValue()) {
                EmiFavorites.addFavorite(ingredient, stack.getRecipeContext());
                EmiScreenManager.repopulatePanels(SidebarType.FAVORITES);
                return true;
            }
            if (function.apply(EmiConfig.viewStackTree).booleanValue() && stack.getRecipeContext() != null) {
                BoM.setGoal(stack.getRecipeContext());
                EmiApi.viewRecipeTree();
                return true;
            }
            Supplier<EmiRecipe> supplier = () -> EmiUtil.getPreferredRecipe(ingredient, lastPlayerInventory, true);
            if (EmiScreenManager.craftInteraction(ingredient, supplier, stack, function)) {
                return true;
            }
        }
        return EmiScreenManager.recipeInteraction(context, function);
    }

    private static boolean craftInteraction(EmiIngredient ingredient, Supplier<EmiRecipe> contextSupplier, EmiStackInteraction stack, Function<EmiBind, Boolean> function) {
        EmiRecipe context;
        if (!(stack instanceof SidebarEmiStackInteraction)) {
            return false;
        }
        EmiCraftContext.Destination destination = null;
        boolean all = false;
        if (function.apply(EmiConfig.craftAllToInventory).booleanValue()) {
            destination = EmiCraftContext.Destination.INVENTORY;
            all = true;
        } else if (function.apply(EmiConfig.craftOneToInventory).booleanValue()) {
            destination = EmiCraftContext.Destination.INVENTORY;
        } else if (function.apply(EmiConfig.craftOneToCursor).booleanValue()) {
            destination = EmiCraftContext.Destination.CURSOR;
        } else if (function.apply(EmiConfig.craftAll).booleanValue()) {
            destination = EmiCraftContext.Destination.NONE;
            all = true;
        } else if (function.apply(EmiConfig.craftOne).booleanValue()) {
            destination = EmiCraftContext.Destination.NONE;
        }
        if (destination != null && (context = contextSupplier.get()) != null) {
            ScreenSpace space;
            if (EmiConfig.miscraftPrevention && (space = EmiScreenManager.getHoveredSpace(lastMouseX, lastMouseY)) != null && (space.getType() == SidebarType.CRAFTABLES || space.getType() == SidebarType.CRAFT_HISTORY) && (lastHoveredCraftableOffset = space.getRawOffsetFromMouse(lastMouseX, lastMouseY)) != -1) {
                lastHoveredCraftableSturdy = lastHoveredCraftable != null;
                lastHoveredCraftable = stack;
                if (!all) {
                    lastHoveredCraftableSturdy = true;
                }
            }
            int amount = all ? Integer.MAX_VALUE : 1;
            EmiIngredient emiIngredient = stack.getStack();
            if (emiIngredient instanceof EmiFavorite.Synthetic) {
                int oc;
                EmiFavorite.Synthetic syn = (EmiFavorite.Synthetic)emiIngredient;
                int batches = (int)syn.batches;
                if (syn.getRecipe() == null && (oc = EmiUtil.getOutputCount(context, syn.getStack())) > 0) {
                    batches /= oc;
                }
                amount = Math.min(amount, batches);
            }
            if (EmiRecipeFiller.performFill(context, EmiApi.getHandledScreen(), EmiCraftContext.Type.CRAFTABLE, destination, amount)) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                return true;
            }
        }
        return false;
    }

    public static boolean recipeInteraction(EmiRecipe recipe, Function<EmiBind, Boolean> function) {
        if (recipe == null) {
            return false;
        }
        if (function.apply(EmiConfig.favorite).booleanValue() && recipe.getOutputs().size() > 0) {
            EmiFavorites.addFavorite(recipe.getOutputs().get(0), recipe);
            EmiScreenManager.repopulatePanels(SidebarType.FAVORITES);
            return true;
        }
        if (function.apply(EmiConfig.copyId).booleanValue()) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            EmiScreenManager.client.f_91068_.m_90911_("" + recipe.getId());
            return true;
        }
        return false;
    }

    public static void toggleVisibility(boolean notify) {
        EmiConfig.enabled = !EmiConfig.enabled;
        EmiConfig.writeConfig();
        if (notify && !EmiConfig.enabled && EmiConfig.helpLevel.has(HelpLevel.VERBOSE)) {
            client.m_91300_().m_94922_((Toast)new DisabledToast());
        }
        if (EmiConfig.enabled) {
            EmiScreenManager.forceRecalculate();
        }
    }

    private static boolean give(EmiStack stack, int amount, int mode) {
        if (stack.getItemStack().m_41619_()) {
            return false;
        }
        ItemStack is = stack.getItemStack().m_41777_();
        is.m_41764_(amount);
        if (mode == 1 && EmiScreenManager.client.f_91074_.m_150110_().f_35937_ && EmiScreenManager.client.f_91080_ instanceof CreativeModeInventoryScreen) {
            EmiScreenManager.client.f_91074_.f_36096_.m_142503_(is);
            return true;
        }
        if (EmiClient.onServer) {
            EmiNetwork.sendToServer(new CreateItemC2SPacket(mode, is));
            return true;
        }
        if (!is.m_41619_()) {
            ResourceLocation id = EmiPort.getItemRegistry().m_7981_((Object)is.m_41720_());
            String command = "give @s " + id;
            if (is.m_41782_()) {
                command = command + is.m_41783_().toString();
            }
            if ((command = command + " " + amount).length() < 256) {
                EmiScreenManager.client.f_91074_.f_108617_.m_246623_(command);
                return true;
            }
        }
        return false;
    }

    private static boolean deleteCursor(int mx, int my) {
        Screen screen = EmiScreenManager.client.f_91080_;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen handled = (AbstractContainerScreen)screen;
            ItemStack cursor = handled.m_6262_().m_142621_();
            ScreenSpace space = EmiScreenManager.getHoveredSpace(mx, my);
            if (!cursor.m_41619_() && space != null && space.getType() == SidebarType.INDEX) {
                handled.m_6262_().m_142503_(ItemStack.f_41583_);
                EmiNetwork.sendToServer(new CreateItemC2SPacket(1, ItemStack.f_41583_));
                return true;
            }
        }
        return false;
    }

    static {
        batchers = new StackBatcher.ClaimedCollection();
        panels = List.of(new SidebarPanel(SidebarSide.LEFT, EmiConfig.leftSidebarPages), new SidebarPanel(SidebarSide.RIGHT, EmiConfig.rightSidebarPages), new SidebarPanel(SidebarSide.TOP, EmiConfig.topSidebarPages), new SidebarPanel(SidebarSide.BOTTOM, EmiConfig.bottomSidebarPages));
        lastPlayerInventorySync = 0L;
        pressedStack = EmiStack.EMPTY;
        draggedStack = EmiStack.EMPTY;
        lastHoveredCraftable = null;
        lastHoveredCraftableSturdy = false;
        lastHoveredCraftableOffset = -1;
        scrollAcc = 0.0;
        search = new EmiSearchWidget(EmiScreenManager.client.f_91062_, 0, 0, 160, 18);
        emi = new SizedButtonWidget(0, 0, 20, 20, 204, 0, () -> true, w -> client.m_91152_((Screen)new ConfigScreen(EmiScreenManager.client.f_91080_)), List.of(EmiPort.translatable("tooltip.emi.config", EmiRenderHelper.getEmiText())));
        tree = new SizedButtonWidget(0, 0, 20, 20, 184, 0, () -> true, w -> EmiApi.viewRecipeTree(), List.of(EmiPort.translatable("tooltip.emi.recipe_tree")));
    }

    public static class SidebarPanel {
        public final SizedButtonWidget pageLeft;
        public final SizedButtonWidget pageRight;
        public final SidebarButtonWidget cycle;
        public final SidebarPages pages;
        public final SidebarSide side;
        public List<ScreenSpace> spaces;
        public ScreenSpace space;
        public SidebarTheme theme;
        public boolean header;
        public int sidebarPage;
        public int page;

        public SidebarPanel(SidebarSide side, SidebarPages pages) {
            this.side = side;
            this.pages = pages;
            this.pageLeft = new SizedButtonWidget(0, 0, 16, 16, 224, 0, this::hasMultiplePages, w -> this.scroll(-1));
            this.pageRight = new SizedButtonWidget(0, 0, 16, 16, 240, 0, this::hasMultiplePages, w -> this.scroll(1));
            this.cycle = new SidebarButtonWidget(0, 0, 16, 16, this);
        }

        public void setSpaces(ScreenSpace main, List<ScreenSpace> subpanels) {
            this.space = main;
            this.spaces = Stream.concat(Stream.of(main), subpanels.stream()).toList();
        }

        public List<ScreenSpace> getSpaces() {
            if (this.spaces == null) {
                return List.of();
            }
            return this.spaces;
        }

        public ScreenSpace getHoveredSpace(int mouseX, int mouseY) {
            for (ScreenSpace space : this.getSpaces()) {
                if (!space.containsNotExcluded(mouseX, mouseY)) continue;
                return space;
            }
            return null;
        }

        public SidebarType getType() {
            if (this.sidebarPage >= 0 && this.sidebarPage < this.pages.pages.size()) {
                return this.pages.pages.get((int)this.sidebarPage).type;
            }
            return SidebarType.NONE;
        }

        public boolean supportsType(SidebarType type) {
            for (SidebarPages.SidebarPage page : this.pages.pages) {
                if (page.type != type) continue;
                return true;
            }
            return false;
        }

        public void setSidebarPage(int page) {
            if (page == this.sidebarPage) {
                return;
            }
            boolean forceRecalculate = this.getType() == SidebarType.CHESS;
            this.sidebarPage = page;
            if ((forceRecalculate |= this.getType() == SidebarType.CHESS) && EmiScreenManager.client.f_91080_ != null) {
                lastWidth = -1;
                EmiScreenManager.recalculate();
            }
            if (this.isSearch()) {
                EmiSearch.search(search.m_94155_());
            }
            if (this.space != null) {
                this.space.batcher.repopulate();
            }
        }

        public void setType(SidebarType type) {
            for (int i = 0; i < this.pages.pages.size(); ++i) {
                SidebarPages.SidebarPage page = this.pages.pages.get(i);
                if (page.type != type) continue;
                this.setSidebarPage(i);
            }
        }

        public void cycleType(int amount) {
            int page = this.sidebarPage + amount;
            if (page >= this.pages.pages.size()) {
                page = 0;
            } else if (page < 0) {
                page = Math.max(this.pages.pages.size() - 1, 0);
            }
            this.setSidebarPage(page);
        }

        public void render(EmiDrawContext context, int mouseX, int mouseY, float delta) {
            this.cycleType(0);
            if (this.getType() == SidebarType.CHESS) {
                EmiChess.get().update();
                if (this.space.tw != 8 || this.space.th != 8) {
                    this.cycleType(1);
                }
            }
            if (this.isVisible()) {
                EmiProfiler.swap(this.side.getName());
                context.push();
                context.matrices().m_252880_(0.0f, 0.0f, 100.0f);
                this.pageLeft.m_88315_(context.raw(), mouseX, mouseY, delta);
                this.cycle.m_88315_(context.raw(), mouseX, mouseY, delta);
                this.pageRight.m_88315_(context.raw(), mouseX, mouseY, delta);
                context.pop();
                int totalPages = (this.space.getStacks().size() - 1) / this.space.pageSize + 1;
                this.wrapPage();
                this.drawHeader(context, mouseX, mouseY, delta, this.page, totalPages);
                for (ScreenSpace space : this.getSpaces()) {
                    if (space == this.space) {
                        space.render(context, mouseX, mouseY, delta, space.pageSize * this.page);
                        continue;
                    }
                    space.render(context, mouseX, mouseY, delta, 0);
                }
            }
        }

        private void drawBackground(EmiDrawContext context, int mouseX, int mouseY, float delta) {
            this.cycleType(0);
            if (this.getType() == SidebarType.CHESS && (this.space.tw != 8 || this.space.th != 8)) {
                this.cycleType(1);
            }
            if (this.isVisible()) {
                int headerOffset;
                RenderSystem.enableDepthTest();
                context.resetColor();
                int n = headerOffset = this.header ? 18 : 0;
                if (this.theme == SidebarTheme.VANILLA) {
                    int totalHeight = 18 + headerOffset;
                    for (ScreenSpace space : this.getSpaces()) {
                        totalHeight += space.th * 18 + 3;
                    }
                    EmiRenderHelper.drawNinePatch(context, EmiRenderHelper.BACKGROUND, this.space.tx - 9, this.space.ty - 9 - headerOffset, this.space.tw * 18 + 18, totalHeight, 0, 32, 8, 1);
                } else if (this.theme == SidebarTheme.MODERN) {
                    int offset = 2;
                    for (ScreenSpace space : this.getSpaces()) {
                        RenderSystem.enableBlend();
                        context.drawTexture(EmiRenderHelper.GRID, space.tx, space.ty, space.tw * 18, space.th * 18, 0.0f, 0.0f, space.tw, space.th, 2, offset);
                        if (space.th % 2 == 1) {
                            offset *= -1;
                        }
                        RenderSystem.disableBlend();
                    }
                }
                for (ScreenSpace space : this.getSpaces()) {
                    if (space == this.space) continue;
                    context.drawTexture(EmiRenderHelper.DASH, space.tx + 1, space.ty - 2, space.tw * 18, 1, 0.0f, 0.0f, space.tw * 18, 1, 6, 1);
                }
            }
        }

        private void drawHeader(EmiDrawContext context, int mouseX, int mouseY, float delta, int page, int totalPages) {
            if (this.header) {
                Component text = EmiRenderHelper.getPageText(page + 1, totalPages, (this.space.tw - 3) * 18);
                int x = this.space.tx + this.space.tw * 18 / 2;
                int maxLeft = (this.space.tw - 2) * 18 / 2 - 18;
                int w = EmiScreenManager.client.f_91062_.m_92852_((FormattedText)text) / 2;
                if (w > maxLeft) {
                    x += w - maxLeft;
                }
                context.drawCenteredText(text, x, this.space.ty - 15);
                if (totalPages > 1 && this.space.tw > 2) {
                    int scrollLeft = this.space.tx + 18;
                    int scrollWidth = this.space.tw * 18 - 36;
                    int scrollY = this.space.ty - 4;
                    context.fill(scrollLeft, scrollY, scrollWidth, 2, 0x55555555);
                    EmiRenderHelper.drawScroll(context, scrollLeft, scrollY, scrollWidth, 2, page, totalPages, -1);
                }
            }
        }

        private void wrapPage() {
            int totalPages = (this.space.getStacks().size() - 1) / this.space.pageSize + 1;
            if (this.page >= totalPages) {
                this.page = 0;
                this.space.batcher.repopulate();
            } else if (this.page < 0) {
                this.page = totalPages - 1;
                this.space.batcher.repopulate();
            }
        }

        public boolean isSearch() {
            return this.side == EmiConfig.searchSidebar;
        }

        public void updateWidgetPosition() {
            this.pageLeft.f_93620_ = this.space.tx;
            this.pageLeft.f_93621_ = this.space.ty - 18;
            this.pageRight.f_93620_ = this.space.tx + this.space.tw * 18 - 16;
            this.pageRight.f_93621_ = this.pageLeft.f_93621_;
            this.cycle.f_93620_ = this.space.tx + 18;
            this.cycle.f_93621_ = this.pageLeft.f_93621_ - 1;
        }

        public boolean isVisible() {
            if (this.getType() == SidebarType.CHESS && (this.space.tw != 8 || this.space.th != 8)) {
                return false;
            }
            return !EmiScreenManager.isDisabled() && this.space.pageSize > 0 && this.pages.pages.size() > 0;
        }

        public void updateWidgetVisibility() {
            boolean visible;
            this.pageLeft.f_93624_ = visible = this.header && this.isVisible();
            this.cycle.f_93624_ = visible;
            this.pageRight.f_93624_ = visible;
        }

        public boolean hasMultiplePages() {
            return this.space.getStacks().size() > this.space.pageSize;
        }

        public void scroll(int delta) {
            if (this.space.pageSize == 0) {
                return;
            }
            this.page += delta;
            int pageSize = this.space.pageSize;
            int totalPages = (this.space.getStacks().size() - 1) / pageSize + 1;
            if (totalPages <= 1) {
                return;
            }
            if (this.page >= totalPages) {
                this.page = 0;
            } else if (this.page < 0) {
                this.page = totalPages - 1;
            }
            this.space.batcher.repopulate();
        }

        public Bounds getBounds() {
            int headerOffset = this.header ? 18 : 0;
            ScreenSpace end = this.getSpaces().get(this.getSpaces().size() - 1);
            return new Bounds(this.space.tx - this.theme.horizontalPadding, this.space.ty - this.theme.verticalPadding - headerOffset, this.space.tw * 18 + this.theme.horizontalPadding * 2, end.ty - this.space.ty + end.th * 18 + this.theme.verticalPadding * 2 + headerOffset);
        }
    }

    public static class ScreenSpace {
        public final StackBatcher batcher = batchers.claim();
        private final Supplier<SidebarType> typeSupplier;
        public final int tx;
        public final int ty;
        public final int tw;
        public final int th;
        public final int pageSize;
        public final boolean rtl;
        public final int[] widths;
        public final boolean search;

        public ScreenSpace(int tx, int ty, int tw, int th, boolean rtl, List<Bounds> exclusion, Supplier<SidebarType> typeSupplier, boolean search) {
            this.tx = tx;
            this.ty = ty;
            this.tw = tw;
            this.th = th;
            this.rtl = rtl;
            this.typeSupplier = typeSupplier;
            this.search = search;
            int[] widths = new int[th];
            int pageSize = 0;
            for (int y = 0; y < th; ++y) {
                int width = 0;
                int cy = ty + y * 18;
                block1: for (int x = 0; x < tw; ++x) {
                    int cx = tx + (rtl ? tw - 1 - x : x) * 18;
                    int rx = cx + 18 - 1;
                    int ry = cy + 18 - 1;
                    for (Bounds rect : exclusion) {
                        if (!rect.contains(cx, cy) && !rect.contains(rx, cy) && !rect.contains(cx, ry) && !rect.contains(rx, ry)) continue;
                        break block1;
                    }
                    ++width;
                }
                widths[y] = width;
                pageSize += width;
            }
            this.pageSize = pageSize;
            this.widths = widths;
        }

        public List<? extends EmiIngredient> getStacks() {
            if (this.search && this.getType() != SidebarType.CHESS) {
                return searchedStacks;
            }
            return EmiSidebars.getStacks(this.getType());
        }

        public List<? extends EmiIngredient> getPage(int page) {
            int start = page * this.pageSize;
            List<? extends EmiIngredient> stacks = this.getStacks();
            int end = Math.min(start + this.pageSize, stacks.size());
            if (end > start) {
                return stacks.subList(start, end);
            }
            return List.of();
        }

        public SidebarType getType() {
            return this.typeSupplier.get();
        }

        public void render(EmiDrawContext context, int mouseX, int mouseY, float delta, int startIndex) {
            if (this.pageSize > 0) {
                RenderSystem.enableDepthTest();
                EmiPort.setPositionTexShader();
                context.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                int hx = -1;
                int hy = -1;
                this.batcher.begin(0, 0, 0);
                int i = startIndex;
                List<? extends EmiIngredient> stacks = this.getStacks();
                int hovered = this.getRawOffsetFromMouse(mouseX, mouseY);
                if (hovered != -1 && EmiConfig.showHoverOverlay && startIndex + hovered < stacks.size()) {
                    hx = this.getRawX(hovered);
                    hy = this.getRawY(hovered);
                    EmiRenderHelper.drawSlotHightlight(context, hx, hy, 18, 18, 0);
                }
                context.push();
                block0: for (int yo = 0; yo < this.th; ++yo) {
                    for (int xo = 0; xo < this.getWidth(yo); ++xo) {
                        if (i >= stacks.size()) break block0;
                        int cx = this.getX(xo, yo);
                        int cy = this.getY(xo, yo);
                        EmiIngredient stack = stacks.get(i++);
                        this.batcher.render(stack, context.raw(), cx + 1, cy + 1, delta);
                        if (this.getType() != SidebarType.INDEX) continue;
                        if (EmiConfig.editMode && EmiHidden.isHidden(stack)) {
                            RenderSystem.enableDepthTest();
                            context.fill(cx, cy, 18, 18, 0x33FF0000);
                            continue;
                        }
                        if (!EmiConfig.highlightDefaulted || BoM.getRecipe(stack) == null) continue;
                        RenderSystem.enableDepthTest();
                        context.fill(cx, cy, 18, 18, 0x3300FF00);
                    }
                }
                this.batcher.draw();
                context.pop();
            }
        }

        public int getWidth(int y) {
            return this.widths[y];
        }

        public int getX(int x, int y) {
            return this.tx + (this.rtl ? x + this.tw - this.getWidth(y) : x) * 18;
        }

        public int getY(int x, int y) {
            return this.ty + y * 18;
        }

        public int getEdgeX(int off) {
            int t = 0;
            int y = 0;
            while (y < this.th && t + this.getWidth(y) < off) {
                t += this.getWidth(y++);
            }
            return this.getX(off - t, y);
        }

        public int getEdgeY(int off) {
            int t = 0;
            int y = 0;
            while (y < this.th && t + this.getWidth(y) < off) {
                t += this.getWidth(y++);
            }
            return this.ty + y * 18;
        }

        public int getRawX(int off) {
            int t = 0;
            int y = 0;
            while (y < this.th && t + this.getWidth(y) <= off) {
                t += this.getWidth(y++);
            }
            return this.getX(off - t, y);
        }

        public int getRawY(int off) {
            int t = 0;
            int y = 0;
            while (y < this.th && t + this.getWidth(y) <= off) {
                t += this.getWidth(y++);
            }
            return this.ty + y * 18;
        }

        public int getClosestEdge(int x, int y) {
            if (y < this.ty) {
                return 0;
            }
            if (y >= this.ty + this.th * 18) {
                return this.pageSize;
            }
            x = (x - this.tx) / 18;
            y = (y - this.ty) / 18;
            int off = 0;
            for (int i = 0; i < y; ++i) {
                off += this.widths[i];
            }
            if (x < 0) {
                return y;
            }
            if (x >= this.widths[y]) {
                return y + this.widths[y];
            }
            if (this.rtl) {
                int to = this.tw - this.widths[y];
                if (x >= to) {
                    off += x - to;
                }
            } else {
                off = x < this.widths[y] ? (off += x) : (off += this.widths[y]);
            }
            return off;
        }

        public int getRawOffsetFromMouse(int mouseX, int mouseY) {
            if (mouseX < this.tx || mouseY < this.ty) {
                return -1;
            }
            return this.getRawOffset((mouseX - this.tx) / 18, (mouseY - this.ty) / 18);
        }

        public int getRawOffset(int x, int y) {
            if (x >= 0 && y >= 0 && x < this.tw && y < this.th) {
                int off = 0;
                for (int i = 0; i < y; ++i) {
                    off += this.widths[i];
                }
                if (this.rtl) {
                    int to = this.tw - this.widths[y];
                    if (x >= to) {
                        return off + x - to;
                    }
                } else if (x < this.widths[y]) {
                    return off + x;
                }
            }
            return -1;
        }

        public boolean contains(int x, int y) {
            return x >= this.tx && x < this.tx + this.tw * 18 && y >= this.ty && y < this.ty + this.th * 18;
        }

        public boolean containsNotExcluded(int x, int y) {
            if (this.contains(lastMouseX, lastMouseY)) {
                for (Bounds bounds : EmiExclusionAreas.getExclusion(EmiScreenBase.getCurrent())) {
                    if (!bounds.contains(x, y)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    public static class SidebarEmiStackInteraction
    extends EmiStackInteraction {
        public final ScreenSpace space;

        public SidebarEmiStackInteraction(EmiIngredient stack, ScreenSpace space) {
            super(stack);
            this.space = space;
        }

        public SidebarEmiStackInteraction(EmiIngredient stack, ScreenSpace space, EmiRecipe recipe, boolean clickable) {
            super(stack, recipe, clickable);
            this.space = space;
        }

        public SidebarType getType() {
            return this.space.getType();
        }
    }
}

