/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.registry;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.EmiRecipeDecorator;
import dev.emi.emi.api.recipe.EmiRecipeManager;
import dev.emi.emi.api.recipe.EmiRecipeSorting;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.ListEmiIngredient;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.data.EmiData;
import dev.emi.emi.data.EmiRecipeCategoryProperties;
import dev.emi.emi.registry.EmiRecipeSorter;
import dev.emi.emi.registry.EmiStackList;
import dev.emi.emi.runtime.EmiHidden;
import dev.emi.emi.runtime.EmiLog;
import dev.emi.emi.runtime.EmiReloadLog;
import dev.emi.emi.runtime.dev.EmiDev;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class EmiRecipes {
    public static volatile Worker activeWorker = null;
    public static EmiRecipeManager manager = Manager.EMPTY;
    public static List<Consumer<Consumer<EmiRecipe>>> lateRecipes = Lists.newArrayList();
    public static List<Predicate<EmiRecipe>> invalidators = Lists.newArrayList();
    public static List<EmiRecipeCategory> categories = Lists.newArrayList();
    private static Map<EmiRecipeCategory, List<EmiIngredient>> workstations = Maps.newHashMap();
    private static List<EmiRecipe> recipes = Lists.newArrayList();
    public static Map<EmiStack, List<EmiRecipe>> byWorkstation = Maps.newHashMap();
    public static List<EmiRecipeDecorator> decorators = Lists.newArrayList();

    public static void clear() {
        EmiRecipes.setWorker(null);
        lateRecipes.clear();
        invalidators.clear();
        categories.clear();
        workstations.clear();
        recipes.clear();
        byWorkstation.clear();
        decorators.clear();
        manager = Manager.EMPTY;
    }

    public static void bake() {
        long start = System.currentTimeMillis();
        recipes.addAll(EmiData.recipes.stream().map(r -> (EmiRecipe)r.get()).toList());
        categories.sort((a, b) -> EmiRecipeCategoryProperties.getOrder(a) - EmiRecipeCategoryProperties.getOrder(b));
        invalidators.addAll(EmiData.recipeFilters);
        invalidators.add(r -> {
            for (EmiIngredient i : Iterables.concat(r.getInputs(), r.getOutputs(), r.getCatalysts())) {
                if (!EmiHidden.isDisabled(i)) continue;
                return true;
            }
            return false;
        });
        List<EmiRecipe> filtered = recipes.stream().filter(r -> {
            for (Predicate<EmiRecipe> predicate : invalidators) {
                if (!predicate.test((EmiRecipe)r)) continue;
                return false;
            }
            return true;
        }).toList();
        HashMap filteredWorkstations = Maps.newHashMap();
        for (Map.Entry<EmiRecipeCategory, List<EmiIngredient>> entry : workstations.entrySet()) {
            List<EmiIngredient> w = entry.getValue().stream().filter(s -> !EmiHidden.isDisabled(s)).toList();
            if (w.isEmpty()) continue;
            filteredWorkstations.put(entry.getKey(), w);
        }
        manager = new Manager(categories, filteredWorkstations, filtered, false);
        EmiRecipes.setWorker(new Worker(categories, filteredWorkstations, filtered));
        EmiLog.info("Baked " + recipes.size() + " recipes in " + (System.currentTimeMillis() - start) + "ms");
    }

    public static void addCategory(EmiRecipeCategory category) {
        categories.add(category);
    }

    public static void addWorkstation(EmiRecipeCategory category, EmiIngredient workstation) {
        workstations.computeIfAbsent(category, k -> Lists.newArrayList()).add(workstation);
    }

    public static void addRecipe(EmiRecipe recipe) {
        recipes.add(recipe);
    }

    private static synchronized void setWorker(Worker worker) {
        activeWorker = worker;
        if (worker != null) {
            new Thread(activeWorker).start();
        }
    }

    private static class Worker
    implements Runnable {
        private List<EmiRecipeCategory> categories;
        private Map<EmiRecipeCategory, List<EmiIngredient>> workstations;
        private List<EmiRecipe> recipes;

        public Worker(List<EmiRecipeCategory> categories, Map<EmiRecipeCategory, List<EmiIngredient>> workstations, List<EmiRecipe> recipes) {
            this.categories = categories;
            this.workstations = workstations;
            this.recipes = recipes;
        }

        @Override
        public void run() {
            long startTime = System.currentTimeMillis();
            Manager manager = new Manager(this.categories, this.workstations, this.recipes, true);
            if (activeWorker == this) {
                long endTime = System.currentTimeMillis();
                EmiLog.info("Baked recipes after reload in " + (endTime - startTime) + "ms");
                EmiRecipes.manager = manager;
            }
            EmiRecipes.setWorker(null);
        }
    }

    private static class Manager
    implements EmiRecipeManager {
        public static final EmiRecipeManager EMPTY = new Manager();
        private final List<EmiRecipeCategory> categories;
        private final Map<EmiRecipeCategory, List<EmiIngredient>> workstations;
        private final List<EmiRecipe> recipes;
        private Map<EmiStack, List<EmiRecipe>> byInput = new Object2ObjectOpenCustomHashMap((Hash.Strategy)new EmiStackList.ComparisonHashStrategy());
        private Map<EmiStack, List<EmiRecipe>> byOutput = new Object2ObjectOpenCustomHashMap((Hash.Strategy)new EmiStackList.ComparisonHashStrategy());
        private Map<EmiRecipeCategory, List<EmiRecipe>> byCategory = Maps.newHashMap();
        private Map<ResourceLocation, EmiRecipe> byId = Maps.newHashMap();

        private Manager() {
            this.categories = List.of();
            this.workstations = Map.of();
            this.recipes = List.of();
        }

        public Manager(List<EmiRecipeCategory> categories, Map<EmiRecipeCategory, List<EmiIngredient>> workstations, List<EmiRecipe> recipes, boolean doSort) {
            Set r;
            this.categories = categories.stream().distinct().toList();
            this.workstations = workstations;
            this.recipes = List.copyOf(recipes);
            Object2IntOpenHashMap duplicateIds = new Object2IntOpenHashMap();
            ObjectArraySet incorrectIds = new ObjectArraySet();
            for (EmiRecipe recipe : recipes) {
                ResourceLocation id = recipe.getId();
                EmiRecipeCategory emiRecipeCategory = recipe.getCategory();
                if (!categories.contains(emiRecipeCategory)) {
                    EmiReloadLog.warn("Recipe " + id + " loaded with unregistered category: " + emiRecipeCategory.getId());
                }
                if (EmiConfig.logNonTagIngredients && recipe.supportsRecipeTree()) {
                    ObjectArraySet seen = new ObjectArraySet(0);
                    for (EmiIngredient ingredient : recipe.getInputs()) {
                        if (!(ingredient instanceof ListEmiIngredient) || seen.contains(ingredient)) continue;
                        EmiReloadLog.warn("Recipe " + recipe.getId() + " uses non-tag ingredient: " + ingredient);
                        seen.add(ingredient);
                    }
                }
                this.byCategory.computeIfAbsent(emiRecipeCategory, a -> Lists.newArrayList()).add(recipe);
                if (id == null) continue;
                if (this.byId.containsKey(id)) {
                    duplicateIds.put((Object)id, duplicateIds.getOrDefault((Object)id, 1) + 1);
                } else {
                    this.byId.put(id, recipe);
                }
                Minecraft client = Minecraft.m_91087_();
                if (id.m_135815_().startsWith("/") || client.f_91073_ == null || !client.f_91073_.m_7465_().m_44043_(id).isEmpty()) continue;
                incorrectIds.add(id);
            }
            if (EmiConfig.devMode) {
                for (ResourceLocation id : duplicateIds.keySet()) {
                    EmiReloadLog.warn(duplicateIds.getInt((Object)id) + " recipes loaded with the same id: " + id);
                }
                for (ResourceLocation id : incorrectIds) {
                    EmiReloadLog.warn("Recipe " + id + " not present in recipe manager. Consider prefixing its path with '/' if it is synthetic.");
                }
            }
            Object2ObjectOpenCustomHashMap byInput = new Object2ObjectOpenCustomHashMap((Hash.Strategy)new EmiStackList.ComparisonHashStrategy());
            Object2ObjectOpenCustomHashMap byOutput = new Object2ObjectOpenCustomHashMap((Hash.Strategy)new EmiStackList.ComparisonHashStrategy());
            for (EmiRecipeCategory emiRecipeCategory : this.byCategory.keySet()) {
                String key = EmiUtil.translateId("emi.category.", emiRecipeCategory.getId());
                if (emiRecipeCategory.getName().equals(EmiPort.translatable(key)) && !I18n.m_118936_((String)key)) {
                    EmiReloadLog.warn("Untranslated recipe category " + emiRecipeCategory.getId());
                }
                List<EmiRecipe> cRecipes = this.byCategory.get(emiRecipeCategory);
                Comparator<EmiRecipe> sort = EmiRecipeCategoryProperties.getSort(emiRecipeCategory);
                if (doSort && sort != EmiRecipeSorting.none()) {
                    cRecipes = cRecipes.stream().sorted(sort).collect(Collectors.toList());
                    EmiRecipeSorter.clear();
                }
                this.byCategory.put(emiRecipeCategory, cRecipes);
                for (EmiRecipe recipe : cRecipes) {
                    recipe.getInputs().stream().flatMap(i -> i.getEmiStacks().stream()).forEach(arg_0 -> Manager.lambda$new$3((Map)byInput, recipe, arg_0));
                    recipe.getCatalysts().stream().flatMap(i -> i.getEmiStacks().stream()).forEach(arg_0 -> Manager.lambda$new$6((Map)byInput, recipe, arg_0));
                    recipe.getOutputs().stream().forEach(arg_0 -> Manager.lambda$new$8((Map)byOutput, recipe, arg_0));
                }
            }
            for (EmiStack emiStack : byInput.keySet()) {
                r = byInput.getOrDefault(emiStack, null);
                if (r != null) {
                    this.byInput.put(emiStack, r.stream().toList());
                    continue;
                }
                EmiReloadLog.warn("Stack illegally self-mutated during recipe bake, causing recipe loss: " + emiStack);
            }
            for (EmiStack emiStack : byOutput.keySet()) {
                r = byOutput.getOrDefault(emiStack, null);
                if (r != null) {
                    this.byOutput.put(emiStack, r.stream().toList());
                    continue;
                }
                EmiReloadLog.warn("Stack illegally self-mutated during recipe bake, causing recipe loss: " + emiStack);
            }
            for (EmiRecipeCategory emiRecipeCategory : workstations.keySet()) {
                List w = workstations.getOrDefault(emiRecipeCategory, null);
                if (w != null) {
                    workstations.put(emiRecipeCategory, w.stream().distinct().toList());
                    continue;
                }
                EmiReloadLog.warn("Recipe category illegally self-mutated during recipe bake, causing recipe loss: " + emiRecipeCategory);
            }
            for (Map.Entry entry : this.byCategory.entrySet()) {
                for (EmiIngredient ingredient : workstations.getOrDefault(entry.getKey(), List.of())) {
                    for (EmiStack stack : ingredient.getEmiStacks()) {
                        byWorkstation.computeIfAbsent(stack, s -> Lists.newArrayList()).addAll((Collection)entry.getValue());
                    }
                }
            }
            if (EmiConfig.devMode) {
                EmiDev.duplicateRecipeIds = duplicateIds.keySet();
                EmiDev.incorrectRecipeIds = incorrectIds;
            }
        }

        @Override
        public List<EmiRecipeCategory> getCategories() {
            return this.categories;
        }

        @Override
        public List<EmiIngredient> getWorkstations(EmiRecipeCategory category) {
            return this.workstations.getOrDefault(category, List.of());
        }

        @Override
        public List<EmiRecipe> getRecipes() {
            return this.recipes;
        }

        @Override
        public List<EmiRecipe> getRecipes(EmiRecipeCategory category) {
            return this.byCategory.getOrDefault(category, List.of());
        }

        @Override
        @Nullable
        public EmiRecipe getRecipe(ResourceLocation id) {
            return this.byId.getOrDefault(id, null);
        }

        @Override
        public List<EmiRecipe> getRecipesByInput(EmiStack stack) {
            return this.byInput.getOrDefault(stack, List.of());
        }

        @Override
        public List<EmiRecipe> getRecipesByOutput(EmiStack stack) {
            return this.byOutput.getOrDefault(stack, List.of());
        }

        private static /* synthetic */ void lambda$new$8(Map byOutput, EmiRecipe recipe, EmiStack i) {
            byOutput.computeIfAbsent(i.copy(), b -> Sets.newLinkedHashSet()).add(recipe);
        }

        private static /* synthetic */ void lambda$new$6(Map byInput, EmiRecipe recipe, EmiStack i) {
            byInput.computeIfAbsent(i.copy(), b -> Sets.newLinkedHashSet()).add(recipe);
        }

        private static /* synthetic */ void lambda$new$3(Map byInput, EmiRecipe recipe, EmiStack i) {
            byInput.computeIfAbsent(i.copy(), b -> Sets.newLinkedHashSet()).add(recipe);
        }
    }
}

