/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.network;

import com.google.common.collect.Lists;
import dev.emi.emi.network.EmiNetwork;
import dev.emi.emi.network.EmiPacket;
import dev.emi.emi.runtime.EmiLog;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class FillRecipeC2SPacket
implements EmiPacket {
    private final int syncId;
    private final int action;
    private final List<Integer> slots;
    private final List<Integer> crafting;
    private final int output;
    private final List<ItemStack> stacks;

    public FillRecipeC2SPacket(AbstractContainerMenu handler, int action, List<Slot> slots, List<Slot> crafting, @Nullable Slot output, List<ItemStack> stacks) {
        this.syncId = handler.f_38840_;
        this.action = action;
        this.slots = slots.stream().map(s -> s == null ? -1 : s.f_40219_).toList();
        this.crafting = crafting.stream().map(s -> s == null ? -1 : s.f_40219_).toList();
        this.output = output == null ? -1 : output.f_40219_;
        this.stacks = stacks;
    }

    public FillRecipeC2SPacket(FriendlyByteBuf buf) {
        this.syncId = buf.readInt();
        this.action = buf.readByte();
        this.slots = FillRecipeC2SPacket.parseCompressedSlots(buf);
        this.crafting = Lists.newArrayList();
        int craftingSize = buf.m_130242_();
        for (int i = 0; i < craftingSize; ++i) {
            int s = buf.m_130242_();
            this.crafting.add(s);
        }
        this.output = buf.readBoolean() ? buf.m_130242_() : -1;
        int size = buf.m_130242_();
        this.stacks = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            this.stacks.add(buf.m_130267_());
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.syncId);
        buf.writeByte(this.action);
        FillRecipeC2SPacket.writeCompressedSlots(this.slots, buf);
        buf.m_130130_(this.crafting.size());
        for (Integer s : this.crafting) {
            buf.m_130130_(s.intValue());
        }
        if (this.output != -1) {
            buf.writeBoolean(true);
            buf.m_130130_(this.output);
        } else {
            buf.writeBoolean(false);
        }
        buf.m_130130_(this.stacks.size());
        for (ItemStack stack : this.stacks) {
            buf.m_130055_(stack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Player player) {
        if (this.slots == null || this.crafting == null) {
            EmiLog.error("Client requested fill but passed input and crafting slot information was invalid, aborting");
            return;
        }
        AbstractContainerMenu handler = player.f_36096_;
        if (handler == null || handler.f_38840_ != this.syncId) {
            EmiLog.warn("Client requested fill but screen handler has changed, aborting");
            return;
        }
        ArrayList slots = Lists.newArrayList();
        ArrayList crafting = Lists.newArrayList();
        Slot output = null;
        for (int i : this.slots) {
            if (i < 0 || i >= handler.f_38839_.size()) {
                EmiLog.error("Client requested fill but passed input slots don't exist, aborting");
                return;
            }
            slots.add((Slot)handler.f_38839_.get(i));
        }
        for (int i : this.crafting) {
            if (i >= 0 && i < handler.f_38839_.size()) {
                crafting.add((Slot)handler.f_38839_.get(i));
                continue;
            }
            crafting.add(null);
        }
        if (this.output != -1 && this.output >= 0 && this.output < handler.f_38839_.size()) {
            output = (Slot)handler.f_38839_.get(this.output);
        }
        if (crafting.size() >= this.stacks.size()) {
            int i;
            ArrayList rubble = Lists.newArrayList();
            for (i = 0; i < crafting.size(); ++i) {
                Slot s = (Slot)crafting.get(i);
                if (s == null || !s.m_8010_(player) || s.m_7993_().m_41619_()) continue;
                ItemStack taken = s.m_7993_();
                rubble.add(taken.m_41777_());
                s.m_269060_(ItemStack.f_41583_);
                s.m_142406_(player, taken);
            }
            try {
                for (i = 0; i < this.stacks.size(); ++i) {
                    ItemStack stack = this.stacks.get(i);
                    if (stack.m_41619_()) continue;
                    int gotten = FillRecipeC2SPacket.grabMatching(player, slots, rubble, crafting, stack);
                    if (gotten != stack.m_41613_()) {
                        if (gotten > 0) {
                            stack.m_41764_(gotten);
                            player.m_150109_().m_150079_(stack);
                        }
                        return;
                    }
                    Slot s = (Slot)crafting.get(i);
                    if (s != null && s.m_5857_(stack) && stack.m_41613_() <= s.m_6641_()) {
                        s.m_269060_(stack);
                        continue;
                    }
                    player.m_150109_().m_150079_(stack);
                }
                if (output != null) {
                    if (this.action == 1) {
                        handler.m_150399_(output.m_150661_(), 0, ClickType.PICKUP, player);
                    } else if (this.action == 2) {
                        handler.m_150399_(output.m_150661_(), 0, ClickType.QUICK_MOVE, player);
                    }
                }
            }
            finally {
                for (ItemStack stack : rubble) {
                    player.m_150109_().m_150079_(stack);
                }
            }
        }
    }

    private static List<Integer> parseCompressedSlots(FriendlyByteBuf buf) {
        ArrayList list = Lists.newArrayList();
        int amount = buf.m_130242_();
        for (int i = 0; i < amount; ++i) {
            int low = buf.m_130242_();
            int high = buf.m_130242_();
            if (low < 0) {
                return null;
            }
            for (int j = low; j <= high; ++j) {
                list.add(j);
            }
        }
        return list;
    }

    private static void writeCompressedSlots(List<Integer> list, FriendlyByteBuf buf) {
        ArrayList postWrite = Lists.newArrayList();
        int groups = 0;
        int i = 0;
        while (i < list.size()) {
            ++groups;
            int start = i;
            int startValue = list.get(start);
            while (i < list.size() && i - start == list.get(i) - startValue) {
                ++i;
            }
            int end = i - 1;
            postWrite.add(b -> {
                b.m_130130_(startValue);
                b.m_130130_(((Integer)list.get(end)).intValue());
            });
        }
        buf.m_130130_(groups);
        for (Consumer consumer : postWrite) {
            consumer.accept(buf);
        }
    }

    private static int grabMatching(Player player, List<Slot> slots, List<ItemStack> rubble, List<Slot> crafting, ItemStack stack) {
        int amount = stack.m_41613_();
        int grabbed = 0;
        for (int i = 0; i < rubble.size(); ++i) {
            if (grabbed >= amount) {
                return grabbed;
            }
            ItemStack r = rubble.get(i);
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)r)) continue;
            int wanted = amount - grabbed;
            if (r.m_41613_() <= wanted) {
                grabbed += r.m_41613_();
                rubble.remove(i);
                --i;
                continue;
            }
            grabbed = amount;
            r.m_41764_(r.m_41613_() - wanted);
        }
        for (Slot s : slots) {
            ItemStack st;
            if (grabbed >= amount) {
                return grabbed;
            }
            if (crafting.contains(s) || !s.m_8010_(player) || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)(st = s.m_7993_()))) continue;
            int wanted = amount - grabbed;
            ItemStack taken = st.m_41777_();
            if (st.m_41613_() <= wanted) {
                grabbed += st.m_41613_();
                s.m_269060_(ItemStack.f_41583_);
            } else {
                grabbed = amount;
                st.m_41764_(st.m_41613_() - wanted);
            }
            s.m_142406_(player, taken);
        }
        return grabbed;
    }

    @Override
    public ResourceLocation getId() {
        return EmiNetwork.FILL_RECIPE;
    }
}

