/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.stack;

import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.runtime.EmiLog;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;

public class Comparison {
    private static final Comparison COMPARE_NBT = Comparison.compareData(stack -> stack.getNbt());
    public static final Comparison DEFAULT_COMPARISON = Comparison.of((a, b) -> true);
    private Predicate predicate;
    private HashFunction hash;

    private Comparison(Predicate comparator, HashFunction hash) {
        this.predicate = comparator;
        this.hash = hash;
    }

    public static Comparison of(Predicate comparator) {
        return Comparison.of(comparator, i -> 0);
    }

    public static Comparison of(Predicate comparator, HashFunction hashFunction) {
        return new Comparison(comparator, hashFunction);
    }

    public static <T> Comparison compareData(Function<EmiStack, T> function) {
        return Comparison.of((a, b) -> Objects.equals(function.apply(a), function.apply(b)), stack -> Objects.hashCode(function.apply(stack)));
    }

    public static Comparison compareNbt() {
        return COMPARE_NBT;
    }

    public boolean compare(EmiStack a, EmiStack b) {
        try {
            return this.predicate.test(a, b);
        }
        catch (Throwable t) {
            this.predicate = (na, nb) -> true;
            EmiLog.error("Comparison threw an exception, disabling");
            t.printStackTrace();
            return true;
        }
    }

    @ApiStatus.Internal
    public int getHash(EmiStack stack) {
        try {
            return this.hash.hash(stack);
        }
        catch (Throwable t) {
            this.hash = s -> 0;
            EmiLog.error("Comparison threw an exception, disabling");
            t.printStackTrace();
            return 0;
        }
    }

    public static interface Predicate {
        public boolean test(EmiStack var1, EmiStack var2);
    }

    public static interface HashFunction {
        public int hash(EmiStack var1);
    }

    static class Builder {
        Builder() {
        }
    }
}

