/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.difficultylock_common_forge.util;

import com.natamus.difficultylock_common_forge.config.ConfigHandler;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.world.Difficulty;

public class Util {
    public static int buttonUpdatesLeft = 3;
    public static CycleButton<?> gameModeButton = null;
    public static CycleButton<?> difficultyButton = null;
    public static CycleButton<?> allowCheatsButton = null;
    private static WorldCreationUiState.SelectedGameMode lastSelectedGameMode = null;

    public static void processScreenTick(CreateWorldScreen createWorldScreen) {
        WorldCreationUiState uiState = createWorldScreen.m_267748_();
        if (!uiState.m_267761_().equals((Object)lastSelectedGameMode)) {
            buttonUpdatesLeft = 3;
            lastSelectedGameMode = uiState.m_267761_();
        }
        Util.actuallySetDifficulty(createWorldScreen);
    }

    public static Difficulty getDifficultyFromConfig() {
        boolean forceHardcoreMode = ConfigHandler.forceHardcoreMode;
        if (ConfigHandler.forcePeaceful && !forceHardcoreMode) {
            return Difficulty.PEACEFUL;
        }
        if (ConfigHandler.forceEasy && !forceHardcoreMode) {
            return Difficulty.EASY;
        }
        if (ConfigHandler.forceNormal && !forceHardcoreMode) {
            return Difficulty.NORMAL;
        }
        if (ConfigHandler.forceHard || forceHardcoreMode) {
            return Difficulty.HARD;
        }
        return null;
    }

    public static boolean hasADifficultyEnabledInConfig() {
        return ConfigHandler.forcePeaceful || ConfigHandler.forceEasy || ConfigHandler.forceNormal || ConfigHandler.forceHard || ConfigHandler.forceHardcoreMode;
    }

    public static void setCreateWorldScreenDifficulty(Screen screen) {
        Util.delaySettingDifficulty(screen);
    }

    private static void delaySettingDifficulty(final Screen screen) {
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                if (screen instanceof CreateWorldScreen) {
                    Util.actuallySetDifficulty((CreateWorldScreen)screen);
                }
            }
        }, 1L);
    }

    private static void actuallySetDifficulty(CreateWorldScreen createWorldScreen) {
        WorldCreationUiState uiState = createWorldScreen.m_267748_();
        if (ConfigHandler.forceHardcoreMode) {
            if (!uiState.m_267761_().equals((Object)WorldCreationUiState.SelectedGameMode.HARDCORE)) {
                buttonUpdatesLeft = 3;
                uiState.m_267616_(WorldCreationUiState.SelectedGameMode.HARDCORE);
            }
            if (Util.gameModeButton.f_93623_) {
                Util.gameModeButton.f_93623_ = false;
            }
        } else {
            Difficulty newDifficulty;
            WorldCreationUiState.SelectedGameMode selectedGameMode = uiState.m_267761_();
            if (selectedGameMode.equals((Object)WorldCreationUiState.SelectedGameMode.HARDCORE)) {
                return;
            }
            if (ConfigHandler.disableCreativeModeSelection && selectedGameMode.equals((Object)WorldCreationUiState.SelectedGameMode.CREATIVE)) {
                buttonUpdatesLeft = 3;
                uiState.m_267616_(WorldCreationUiState.SelectedGameMode.SURVIVAL);
                selectedGameMode = WorldCreationUiState.SelectedGameMode.SURVIVAL;
            }
            if ((newDifficulty = Util.getDifficultyFromConfig()) != null && !uiState.m_267816_().equals((Object)newDifficulty)) {
                buttonUpdatesLeft = 3;
                uiState.m_267754_(newDifficulty);
            }
            if (Util.difficultyButton.f_93623_ && Util.hasADifficultyEnabledInConfig()) {
                Util.difficultyButton.f_93623_ = false;
            }
            if (ConfigHandler.forceCheatsDisabled && selectedGameMode.equals((Object)WorldCreationUiState.SelectedGameMode.SURVIVAL)) {
                if (uiState.m_267823_()) {
                    buttonUpdatesLeft = 3;
                    uiState.m_267601_(false);
                }
                if (Util.allowCheatsButton.f_93623_) {
                    Util.allowCheatsButton.f_93623_ = false;
                }
            }
        }
    }
}

