/*
 * Decompiled with CFR 0.152.
 */
package whirlfrenzy.customitemdespawnduration.config;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import whirlfrenzy.customitemdespawnduration.config.CustomItemDespawnDurationConfig;

public class HashMapEditorScreen
extends Screen {
    Screen parent;
    EditBox keyTextField;
    EditBox valueTextField;
    Button addEntryButton;
    Button backButton;
    HashMapList list;

    protected HashMapEditorScreen(Component title) {
        super(title);
    }

    public HashMapEditorScreen(Screen parent) {
        this((Component)Component.m_237115_((String)"custom-item-despawn-duration.config.mapEditorScreenTitle"));
        this.parent = parent;
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.m_280039_(context);
        super.m_88315_(context, mouseX, mouseY, delta);
        context.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 10, -1);
        if (this.f_96541_.m_91091_() && this.f_96541_.m_91092_().m_6992_()) {
            context.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"custom-item-despawn-duration.config.lanWarning"), this.f_96543_ / 2, this.f_96544_ - 10, -1);
        }
        context.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"custom-item-despawn-duration.config.mapEditorKeyFieldLabel"), this.f_96543_ / 2 - 155, 26, -1, true);
        context.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"custom-item-despawn-duration.config.mapEditorValueFieldLabel"), this.f_96543_ / 2 + 5, 26, -1, true);
        context.m_280056_(this.f_96541_.f_91062_, "s", this.f_96543_ / 2 + 42, 41, -1, true);
        this.keyTextField.m_88315_(context, mouseX, mouseY, delta);
        this.valueTextField.m_88315_(context, mouseX, mouseY, delta);
        this.addEntryButton.m_88315_(context, mouseX, mouseY, delta);
    }

    public void m_7856_() {
        this.keyTextField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 155, 35, 150, 20, (Component)Component.m_237115_((String)"custom-item-despawn-duration.config.mapEditorKeyFieldLabel"));
        this.keyTextField.m_94153_(text -> {
            if (text.isEmpty()) {
                this.keyTextField.m_94202_(-1);
                this.keyTextField.m_257544_(null);
                return true;
            }
            ResourceLocation id = ResourceLocation.m_135820_((String)text);
            if (id == null || !BuiltInRegistries.f_257033_.m_7804_(id)) {
                this.keyTextField.m_94202_(-34953);
                this.keyTextField.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"custom-item-despawn-duration.config.invalidItem").m_130940_(ChatFormatting.RED)));
            } else if (CustomItemDespawnDurationConfig.despawnDurations.containsKey(id.toString())) {
                this.keyTextField.m_94202_(-34953);
                this.keyTextField.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"custom-item-despawn-duration.config.itemAlreadyPresent").m_130940_(ChatFormatting.RED)));
            } else {
                this.keyTextField.m_94202_(-1);
                this.keyTextField.m_257544_(null);
            }
            return true;
        });
        this.keyTextField.m_257771_((Component)Component.m_237115_((String)"custom-item-despawn-duration.config.mapEditorKeyFieldPlaceholder").m_130940_(ChatFormatting.GRAY));
        this.valueTextField = new EditBox(this.f_96547_, this.f_96543_ / 2 + 5, 35, 35, 20, (Component)Component.m_237115_((String)"custom-item-despawn-duration.config.value"));
        this.valueTextField.m_94199_(4);
        this.valueTextField.m_94153_(text -> {
            int seconds;
            if (text.isEmpty()) {
                this.valueTextField.m_94202_(-1);
                this.valueTextField.m_257544_(null);
                return true;
            }
            try {
                seconds = Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                this.valueTextField.m_94202_(-34953);
                this.valueTextField.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"custom-item-despawn-duration.config.notANumber").m_130940_(ChatFormatting.RED)));
                return true;
            }
            if (seconds > 1800) {
                this.valueTextField.m_94202_(-34953);
                this.valueTextField.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)"custom-item-despawn-duration.config.maximumValue", (Object[])new Object[]{1800}).m_130940_(ChatFormatting.RED)));
            } else if (seconds < 0) {
                this.valueTextField.m_94202_(-34953);
                this.valueTextField.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)"custom-item-despawn-duration.config.minimumValue", (Object[])new Object[]{0}).m_130940_(ChatFormatting.RED)));
            } else {
                this.valueTextField.m_94202_(-1);
                this.valueTextField.m_257544_(null);
            }
            return true;
        });
        this.addEntryButton = new Button.Builder((Component)Component.m_237113_((String)"+"), widget -> {
            try {
                if (this.keyTextField.m_94155_().isEmpty() || this.valueTextField.m_94155_().isEmpty()) {
                    return;
                }
                ResourceLocation id = ResourceLocation.m_135820_((String)this.keyTextField.m_94155_());
                if (id == null || CustomItemDespawnDurationConfig.despawnDurations.containsKey(id.toString()) || !BuiltInRegistries.f_257033_.m_7804_(id)) {
                    return;
                }
                int seconds = Integer.parseInt(this.valueTextField.m_94155_());
                if (seconds > 1800 || seconds < 0) {
                    return;
                }
                LinkedHashMap<String, Integer> oldDespawnDurations = new LinkedHashMap<String, Integer>(CustomItemDespawnDurationConfig.despawnDurations);
                CustomItemDespawnDurationConfig.despawnDurations.clear();
                CustomItemDespawnDurationConfig.despawnDurations.put(id.toString(), seconds);
                CustomItemDespawnDurationConfig.despawnDurations.putAll(oldDespawnDurations);
                this.list.addToTop(Map.entry(id.toString(), seconds));
                this.keyTextField.m_94144_("");
                this.valueTextField.m_94144_("");
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }).m_252987_(this.f_96543_ / 2 + 55, 35, 20, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"custom-item-despawn-duration.config.add"))).m_253136_();
        this.backButton = new Button.Builder((Component)Component.m_237115_((String)"gui.done"), widget -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - 75, this.f_96544_ - 30, 150, 20).m_253136_();
        this.list = new HashMapList(this.f_96541_, this.f_96543_, this.f_96544_ - 105, 65, this.f_96544_ - 40, 25);
        for (Map.Entry<String, Integer> entry : CustomItemDespawnDurationConfig.despawnDurations.entrySet()) {
            this.list.add(entry);
        }
        this.m_142416_((GuiEventListener)this.keyTextField);
        this.m_142416_((GuiEventListener)this.valueTextField);
        this.m_142416_((GuiEventListener)this.addEntryButton);
        this.m_142416_((GuiEventListener)this.backButton);
        this.m_142416_((GuiEventListener)this.list);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.list.m_5953_(mouseX, mouseY) && this.list.m_7222_() != null) {
            ((ListEntry)this.list.m_7222_()).valueTextField.m_93692_(false);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public static class HashMapList
    extends ContainerObjectSelectionList<ListEntry> {
        public HashMapList(Minecraft minecraftClient, int width, int height, int top, int bottom, int itemHeight) {
            super(minecraftClient, width, height, top, bottom, itemHeight);
        }

        public void add(Map.Entry<String, Integer> entry) {
            this.m_7085_((AbstractSelectionList.Entry)new ListEntry(entry, this.f_93388_, this));
        }

        public void addToTop(Map.Entry<String, Integer> entry) {
            this.addEntryToTop(new ListEntry(entry, this.f_93388_, this));
        }

        protected void addEntryToTop(ListEntry entry) {
            if (this.m_93517_() == 0.0) {
                super.m_239857_((AbstractSelectionList.Entry)entry);
                this.m_93410_(0.0);
            } else {
                super.m_239857_((AbstractSelectionList.Entry)entry);
            }
        }

        public void remove(ListEntry listEntry) {
            this.m_239045_((AbstractSelectionList.Entry)listEntry);
        }
    }

    public static class ListEntry
    extends ContainerObjectSelectionList.Entry<ListEntry> {
        Map.Entry<String, Integer> entry;
        EditBox valueTextField;
        Button removeButton;
        StringWidget itemName;
        Minecraft client = Minecraft.m_91087_();
        HashMapList parentList;
        ItemStack representingItem;
        int screenWidth;

        public ListEntry(Map.Entry<String, Integer> entry, int screenWidth, HashMapList parentList) {
            this.entry = entry;
            this.screenWidth = screenWidth;
            this.parentList = parentList;
            this.valueTextField = new EditBox(this.client.f_91062_, this.screenWidth / 2 + 5, 0, 35, 20, (Component)Component.m_237113_((String)"Value"));
            this.valueTextField.m_94144_(String.valueOf(this.entry.getValue()));
            if (!BuiltInRegistries.f_257033_.m_7804_(new ResourceLocation(this.entry.getKey()))) {
                this.valueTextField.m_94186_(false);
                this.valueTextField.m_94205_(0x444444);
                this.valueTextField.f_93623_ = false;
                this.itemName = new StringWidget(0, 0, this.screenWidth / 2 - 30, 25, (Component)Component.m_237113_((String)this.entry.getKey()), this.client.f_91062_);
                this.itemName.m_267574_();
                this.itemName.m_269033_(0x444444);
                this.itemName.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"custom-item-despawn-duration.config.itemMissing")));
            } else {
                this.representingItem = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(this.entry.getKey())));
                this.itemName = new StringWidget(0, 0, this.screenWidth / 2 - 30, 25, (Component)Component.m_237115_((String)this.representingItem.m_41778_()), this.client.f_91062_);
                this.itemName.m_267574_();
                this.valueTextField.m_94199_(4);
                this.valueTextField.m_94153_(text -> {
                    int seconds;
                    try {
                        seconds = Integer.parseInt(text);
                    }
                    catch (NumberFormatException e) {
                        this.valueTextField.m_94202_(-34953);
                        this.valueTextField.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"custom-item-despawn-duration.config.notANumber")));
                        return true;
                    }
                    if (seconds > 1800) {
                        this.valueTextField.m_94202_(-34953);
                        this.valueTextField.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)"custom-item-despawn-duration.config.maximumValue", (Object[])new Object[]{1800}).m_130940_(ChatFormatting.RED)));
                    } else if (seconds < 0) {
                        this.valueTextField.m_94202_(-34953);
                        this.valueTextField.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)"custom-item-despawn-duration.config.minimumValue", (Object[])new Object[]{0}).m_130940_(ChatFormatting.RED)));
                    } else {
                        this.valueTextField.m_94202_(-1);
                        this.valueTextField.m_257544_(null);
                        CustomItemDespawnDurationConfig.despawnDurations.put(this.entry.getKey(), seconds);
                    }
                    return true;
                });
            }
            this.removeButton = new Button.Builder((Component)Component.m_237113_((String)"-"), buttonWidget -> {
                CustomItemDespawnDurationConfig.despawnDurations.remove(this.entry.getKey());
                this.parentList.remove(this);
            }).m_252987_(this.screenWidth / 2 + 55, 0, 20, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"custom-item-despawn-duration.config.remove"))).m_253136_();
        }

        public List<? extends NarratableEntry> m_142437_() {
            return this.m_6702_();
        }

        public List<? extends AbstractWidget> m_6702_() {
            return List.of(this.valueTextField, this.removeButton, this.itemName);
        }

        public void m_6311_(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            for (AbstractWidget abstractWidget : this.m_6702_()) {
                abstractWidget.m_253211_(y);
                abstractWidget.m_88315_(context, mouseX, mouseY, tickDelta);
            }
            if (this.representingItem != null) {
                context.m_280480_(this.representingItem, this.screenWidth / 2 - 25, y + 2);
            }
            int textColor = this.representingItem == null ? 0x444444 : 0xFFFFFF;
            context.m_280056_(this.client.f_91062_, "s", this.screenWidth / 2 + 42, y + 6, textColor, true);
        }
    }
}

