/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.value;

import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.exception.ConfigValueMissingException;
import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.validate.NumberRange;
import dev.toma.configuration.config.value.AbstractArrayValue;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.IConfigValueReadable;
import dev.toma.configuration.config.value.NumericArrayValue;
import dev.toma.configuration.config.value.ValueData;
import java.lang.reflect.Field;
import net.minecraft.network.FriendlyByteBuf;

public class ShortArrayValue
extends NumericArrayValue<Short> {
    public ShortArrayValue(ValueData<Short[]> valueData) {
        super(valueData, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE);
    }

    @Override
    public NumberRange<Short> getValueRange(Field field) {
        Configurable.Range range = field.getAnnotation(Configurable.Range.class);
        return range != null ? NumberRange.interval(this, (short)Math.max(range.min(), (long)((Short)this.min()).shortValue()), (short)Math.min(range.max(), (long)((Short)this.max()).shortValue())) : NumberRange.all(this);
    }

    @Override
    public Short createElementInstance() {
        return (short)0;
    }

    @Override
    public void serialize(IConfigFormat format) {
        format.writeShortArray(this.getId(), (Short[])this.get(IConfigValueReadable.Mode.SAVED));
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        this.setValue(format.readShortArray(this.getId()));
    }

    public static final class Adapter
    extends TypeAdapter<Short[]> {
        @Override
        public void encodeToBuffer(ConfigValue<Short[]> value, FriendlyByteBuf buffer) {
            AbstractArrayValue.saveToBuffer((Short[])value.get(), buffer, (buf, aShort) -> buf.writeShort((int)aShort.shortValue()));
        }

        @Override
        public Short[] decodeFromBuffer(ConfigValue<Short[]> value, FriendlyByteBuf buffer) {
            return AbstractArrayValue.readFromBuffer(buffer, Short[]::new, FriendlyByteBuf::readShort);
        }

        @Override
        public ConfigValue<Short[]> serialize(TypeAdapter.TypeAttributes<Short[]> attributes, Object instance, TypeAdapter.TypeSerializer serializer) throws IllegalAccessException {
            return new ShortArrayValue(ValueData.of(attributes));
        }
    }
}

