/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.widget;

import dev.toma.configuration.client.WidgetAdder;
import dev.toma.configuration.client.screen.WidgetPlacerHelper;
import dev.toma.configuration.client.theme.ConfigTheme;
import dev.toma.configuration.client.widget.ContainerWidget;
import dev.toma.configuration.config.validate.AggregatedValidationResult;
import dev.toma.configuration.config.validate.IValidationResult;
import dev.toma.configuration.config.value.ConfigValue;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

public class ConfigEntryWidget
extends ContainerWidget
implements WidgetAdder {
    public static final Component OPEN = Component.m_237115_((String)"text.configuration.value.open");
    public static final Component APPLY = Component.m_237115_((String)"text.configuration.value.apply");
    public static final Component REVERT_DEFAULTS = Component.m_237115_((String)"text.configuration.value.revert.default");
    public static final Component REVERT_DEFAULTS_DIALOG_TEXT = Component.m_237115_((String)"text.configuration.value.revert.default.dialog");
    public static final Component REVERT_CHANGES = Component.m_237115_((String)"text.configuration.value.revert.changes");
    public static final Component REVERT_CHANGES_DIALOG_TEXT = Component.m_237115_((String)"text.configuration.value.revert.changes.dialog");
    private final String configId;
    private final ConfigValue<?> configValue;
    private final List<Component> description;
    private final ConfigTheme theme;
    private IValidationResult result = IValidationResult.success();
    private IValidationRenderer renderer;
    private boolean lastHoverState;
    private long hoverTimeStart;

    public ConfigEntryWidget(int x, int y, int w, int h, ConfigValue<?> value, String configId, ConfigTheme theme) {
        this(x, y, w, h, value.getValueData().getTitle(), value, configId, theme);
    }

    public ConfigEntryWidget(int x, int y, int w, int h, Component label, ConfigValue<?> value, String configId, ConfigTheme theme) {
        super(x, y, w, h, label);
        this.configValue = value;
        this.configId = configId;
        this.description = value.getDescription();
        this.theme = theme;
    }

    public void setDescriptionRenderer(IValidationRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public Component getComponentName() {
        return this.m_6035_();
    }

    public void m_168797_(NarrationElementOutput p_169152_) {
    }

    @Override
    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Font font = Minecraft.m_91087_().f_91062_;
        ConfigTheme.ConfigEntry configEntry = this.theme.getConfigEntry();
        if (this.f_93622_) {
            if (!this.lastHoverState) {
                this.hoverTimeStart = System.currentTimeMillis();
            }
            if (configEntry.hoveredColorBackground() != null) {
                graphics.m_280509_(this.m_252754_() - 30, this.m_252907_() - 2, this.getRight() + 30, this.getBottom() + 2, configEntry.hoveredColorBackground().intValue());
            }
        }
        IValidationResult validationResult = this.getValidationResult();
        boolean isError = this.hasGuiError();
        MutableComponent label = Component.m_237113_((String)this.m_6035_().getString()).m_130948_(this.m_6035_().m_7383_());
        UnaryOperator<Style> modifiedStyle = configEntry.modifiedValueStyle();
        if (this.configValue.isChanged() && modifiedStyle != null) {
            label.m_130948_((Style)modifiedStyle.apply(label.m_7383_()));
        }
        int entryLeft = WidgetPlacerHelper.getLeft(this.m_252754_(), this.f_93618_);
        int n = this.m_252754_();
        int n2 = this.m_252907_();
        Objects.requireNonNull(font);
        ConfigEntryWidget.drawScrollingString(graphics, font, (Component)label, n, entryLeft - 5, n2 + (this.f_93619_ - 9) / 2, configEntry.color());
        super.m_87963_(graphics, mouseX, mouseY, partialTicks);
        IValidationResult.Severity severity = validationResult.severity();
        boolean validationRendering = false;
        if (severity.isWarningOrError()) {
            validationRendering = true;
            this.renderer.drawIcon(graphics, this, severity);
        }
        if ((isError || this.f_93622_) && this.renderer != null) {
            long totalHoverTime = System.currentTimeMillis() - this.hoverTimeStart;
            if (isError || totalHoverTime >= 750L) {
                boolean hasDescription;
                List<Component> messages = validationRendering ? validationResult.messages() : this.description;
                List<FormattedCharSequence> lines = messages.stream().flatMap(text -> font.m_92923_((FormattedText)text, this.f_93618_ / 2).stream()).toList();
                boolean bl = hasDescription = lines.size() > 1 || lines.size() == 1 && !((FormattedCharSequence)lines.get(0)).equals(FormattedCharSequence.f_13691_);
                if (hasDescription) {
                    this.renderer.drawDescription(graphics, this, lines, severity, severity.textColor);
                }
            }
        }
        this.lastHoverState = this.f_93622_;
    }

    @Override
    public void setValidationResult(IValidationResult result) {
        this.result = result;
    }

    @Override
    public <W extends AbstractWidget> W addConfigWidget(boolean editableCheck, WidgetAdder.ToWidgetFunction<W> function) {
        W widget = function.asWidget(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, this.configId);
        if (editableCheck) {
            ((AbstractWidget)widget).f_93623_ = this.configValue.isEditable();
        }
        return this.addRenderableWidget(widget);
    }

    public static void drawScrollingString(GuiGraphics graphics, Font font, Component text, int x1, int x2, int y, int color) {
        int maxWidth = x2 - x1;
        int width = font.m_92852_((FormattedText)text);
        if (width <= maxWidth) {
            graphics.m_280430_(font, text, x1, y, color);
        } else {
            Objects.requireNonNull(font);
            AbstractWidget.m_280138_((GuiGraphics)graphics, (Font)font, (Component)text, (int)x1, (int)y, (int)x2, (int)(y + 9), (int)color);
        }
    }

    private IValidationResult getValidationResult() {
        IValidationResult valueResult = this.configValue.getValidationResult() != null ? this.configValue.getValidationResult() : IValidationResult.success();
        return valueResult.severity().isHigherSeverityThan(this.result.severity()) ? valueResult : this.result;
    }

    private boolean hasGuiError() {
        IValidationResult result = this.getValidationResult();
        return !result.severity().isValid() && !(result instanceof AggregatedValidationResult);
    }

    public static interface IValidationRenderer {
        public void drawIcon(GuiGraphics var1, AbstractWidget var2, IValidationResult.Severity var3);

        public void drawDescription(GuiGraphics var1, AbstractWidget var2, List<FormattedCharSequence> var3, IValidationResult.Severity var4, int var5);
    }
}

