/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.widget;

import dev.toma.configuration.client.theme.ConfigTheme;
import dev.toma.configuration.client.widget.render.IRenderer;
import dev.toma.configuration.client.widget.render.SpriteRenderer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public abstract class AbstractThemeWidget
extends AbstractWidget {
    public static final Component REVERT = Component.m_237115_((String)"text.configuration.value.revert");
    public static final Component REVERT_DEFAULT = Component.m_237115_((String)"text.configuration.value.revert_default");
    public static final SpriteRenderer.SpriteOptions DISABLED = new SpriteRenderer.SpriteOptions(0, 20);
    public static final SpriteRenderer.SpriteOptions HOVERED = new SpriteRenderer.SpriteOptions(0, 40);
    protected final ConfigTheme theme;
    protected IRenderer backgroundRenderer;
    protected ChangeListener<AbstractThemeWidget> changeListener;

    public AbstractThemeWidget(int x, int y, int width, int height, ConfigTheme theme) {
        this(x, y, width, height, CommonComponents.f_237098_, theme);
    }

    public AbstractThemeWidget(int x, int y, int width, int height, Component text, ConfigTheme theme) {
        super(x, y, width, height, text);
        this.theme = theme;
    }

    public static SpriteRenderer.SpriteOptions getSpriteOptions(AbstractThemeWidget widget) {
        return widget.f_93623_ ? (widget.m_198029_() ? HOVERED : SpriteRenderer.SpriteOptions.DEFAULT) : DISABLED;
    }

    public void setBackgroundRenderer(IRenderer backgroundRenderer) {
        this.backgroundRenderer = backgroundRenderer;
    }

    public void renderBackground(GuiGraphics graphics) {
        this.applyRenderer(this.backgroundRenderer, graphics, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_());
    }

    public void applyRenderer(IRenderer renderer, GuiGraphics graphics, int x, int y, int width, int height) {
        if (renderer != null) {
            renderer.draw(graphics, x, y, width, height, this.f_93622_);
        }
    }

    public void setChangeListener(ChangeListener<AbstractThemeWidget> changeListener) {
        this.changeListener = changeListener;
    }

    public void setChanged() {
        if (this.changeListener != null) {
            this.changeListener.onChanged(this);
        }
    }

    protected void m_168797_(NarrationElementOutput output) {
        output.m_169146_(NarratedElementType.TITLE, this.m_6035_());
    }

    public ConfigTheme getTheme() {
        return this.theme;
    }

    public int getRight() {
        return this.m_252754_() + this.m_5711_();
    }

    public int getBottom() {
        return this.m_252907_() + this.m_93694_();
    }

    @FunctionalInterface
    public static interface ChangeListener<T> {
        public void onChanged(T var1);
    }
}

