/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.screen;

import dev.toma.configuration.Configuration;
import dev.toma.configuration.ConfigurationSettings;
import dev.toma.configuration.client.screen.AbstractConfigScreen;
import dev.toma.configuration.client.theme.ConfigTheme;
import dev.toma.configuration.client.theme.adapter.DisplayAdapter;
import dev.toma.configuration.client.widget.ConfigEntryWidget;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.value.ConfigValue;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

public class ConfigScreen
extends AbstractConfigScreen {
    private final Map<String, ConfigValue<?>> configValueMap;
    private final Map<String, ConfigValue<?>> valueMap = new LinkedHashMap();

    public ConfigScreen(ConfigHolder<?> configHolder, Component screenTitle, Map<String, ConfigValue<?>> valueMap, Screen previous) {
        super(screenTitle, previous, configHolder);
        this.configValueMap = valueMap;
    }

    protected void m_7856_() {
        int viewportMin = 35;
        int viewportHeight = this.f_96544_ - 35 - 30;
        this.valueMap.clear();
        ConfigurationSettings settings = ConfigurationSettings.getInstance();
        for (Map.Entry<String, ConfigValue<?>> entry : this.configValueMap.entrySet()) {
            ConfigValue<?> value = entry.getValue();
            if (!value.getFieldVisibility().isVisible(settings)) continue;
            this.valueMap.put(entry.getKey(), value);
        }
        int spacing = 22;
        this.pageSize = (viewportHeight - 20) / spacing;
        this.correctScrollingIndex(this.valueMap.size());
        ArrayList values = new ArrayList(this.valueMap.values());
        int errorOffset = viewportHeight - 20 - (this.pageSize * spacing - 5);
        int offset = 0;
        for (int i = this.index; i < this.index + this.pageSize; ++i) {
            int j = i - this.index;
            if (i >= values.size()) break;
            int correct = errorOffset / (this.pageSize - j);
            errorOffset -= correct;
            ConfigValue value = (ConfigValue)values.get(i);
            ConfigEntryWidget widget = (ConfigEntryWidget)this.m_142416_((GuiEventListener)new ConfigEntryWidget(30, 45 + j * spacing + (offset += correct), this.f_96543_ - 60, 20, value, this.getConfigId(), this.theme));
            widget.setDescriptionRenderer(this);
            TypeAdapter.AdapterContext context = value.getSerializationContext();
            Field field = context.getOwner();
            DisplayAdapter adapter = this.theme.getAdapter(field.getType());
            if (adapter == null) {
                Configuration.LOGGER.error(MARKER, "Missing display adapter for {} type, will not be displayed in GUI", (Object)field.getType().getSimpleName());
                continue;
            }
            try {
                adapter.placeWidgets(this.holder, value, field, this.theme, widget);
                continue;
            }
            catch (ClassCastException e) {
                Configuration.LOGGER.error(MARKER, (Message)new FormattedMessage("Unable to create config field for {}", (Object)field.getType().getSimpleName()), (Throwable)e);
            }
        }
        this.addSettingsButton();
        this.addFooter();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        ConfigTheme.Header themeHeader = this.theme.getHeader();
        ConfigTheme.Footer footer = this.theme.getFooter();
        Component headerLabel = themeHeader.customText() != null ? themeHeader.customText() : this.f_96539_;
        int titleWidth = this.f_96547_.m_92852_((FormattedText)headerLabel);
        int n = (this.f_96543_ - titleWidth) / 2;
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280614_(this.f_96547_, headerLabel, n, (35 - 9) / 2, themeHeader.foregroundColor(), true);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280509_(0, 0, this.f_96543_, 35, themeHeader.backgroundColor());
        graphics.m_280509_(0, this.f_96544_ - 30, this.f_96543_, this.f_96544_, footer.backgroundColor());
        Integer fillColor = this.theme.getBackgroundFillColor();
        if (fillColor != null) {
            graphics.m_280509_(0, 35, this.f_96543_, this.f_96544_ - 30, fillColor.intValue());
        }
        this.f_169369_.forEach(renderable -> renderable.m_88315_(graphics, mouseX, mouseY, partialTicks));
        ConfigTheme.Scrollbar scrollbar = this.theme.getScrollbar();
        ConfigScreen.renderScrollbar(graphics, this.f_96543_ - scrollbar.width(), 35, scrollbar.width(), this.f_96544_ - 30 - 35, this.index, this.valueMap.size(), this.pageSize, scrollbar.backgroundColor());
    }

    public boolean m_6050_(double mouseX, double mouseY, double amountY) {
        int scale = (int)(-amountY);
        int next = this.index + scale;
        if (next >= 0 && next + this.pageSize <= this.valueMap.size()) {
            this.index = next;
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            return true;
        }
        return false;
    }
}

