/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.common.network.packet.server;

import cofh.core.CoFHCore;
import cofh.core.util.filter.FilterHolderType;
import cofh.core.util.filter.IFilterable;
import cofh.core.util.filter.IFilterableItem;
import cofh.lib.common.network.packet.IPacketServer;
import cofh.lib.common.network.packet.PacketBase;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class FilterableGuiTogglePacket
extends PacketBase
implements IPacketServer {
    public static byte FILTER_GUI = 0;
    public static byte GUI = 1;
    protected FilterHolderType type;
    protected int entityId = -1;
    protected BlockPos pos = BlockPos.f_121853_;
    protected byte mode;

    public FilterableGuiTogglePacket() {
        super(20, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleServer(ServerPlayer player) {
        Level world = player.f_19853_;
        switch (this.type) {
            case ITEM: {
                ItemStack held = player.m_21120_(InteractionHand.MAIN_HAND);
                Item item = held.m_41720_();
                if (!(item instanceof IFilterableItem)) break;
                IFilterableItem filterable = (IFilterableItem)item;
                if (this.mode == GUI) {
                    filterable.openGui(player, held);
                    break;
                }
                if (this.mode != FILTER_GUI) break;
                filterable.openFilterGui(player, held);
                break;
            }
            case ENTITY: {
                Entity entity = world.m_6815_(this.entityId);
                if (entity == null || entity.m_213877_()) {
                    return;
                }
                if (!(entity instanceof IFilterable)) break;
                IFilterable filterable = (IFilterable)entity;
                if (this.mode == GUI) {
                    filterable.openGui(player);
                    break;
                }
                if (this.mode != FILTER_GUI) break;
                filterable.openFilterGui(player);
                break;
            }
            case TILE: {
                if (!world.m_46749_(this.pos)) {
                    return;
                }
                BlockEntity tile = world.m_7702_(this.pos);
                if (!(tile instanceof IFilterable)) break;
                IFilterable filterable = (IFilterable)tile;
                if (this.mode == GUI) {
                    filterable.openGui(player);
                    break;
                }
                if (this.mode != FILTER_GUI) break;
                filterable.openFilterGui(player);
            }
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.type.ordinal());
        buf.m_130130_(this.entityId);
        buf.m_130064_(this.pos);
        buf.writeByte((int)this.mode);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.type = FilterHolderType.from(buf.m_130242_());
        this.entityId = buf.m_130242_();
        this.pos = buf.m_130135_();
        this.mode = buf.readByte();
    }

    public static void openGui(IFilterable filterable) {
        if (filterable instanceof BlockEntity) {
            BlockEntity tile = (BlockEntity)filterable;
            FilterableGuiTogglePacket.openGui(tile);
        } else if (filterable instanceof Entity) {
            Entity entity = (Entity)filterable;
            FilterableGuiTogglePacket.openGui(entity);
        }
    }

    public static void openFilterGui(ItemStack stack) {
        FilterableGuiTogglePacket.sendToServer(FILTER_GUI);
    }

    public static void openGui(ItemStack stack) {
        FilterableGuiTogglePacket.sendToServer(GUI);
    }

    protected static void sendToServer(byte mode) {
        FilterableGuiTogglePacket packet = new FilterableGuiTogglePacket();
        packet.type = FilterHolderType.ITEM;
        packet.mode = mode;
        packet.sendToServer();
    }

    public static void openFilterGui(BlockEntity tile) {
        FilterableGuiTogglePacket.sendToServer(tile.m_58899_(), FILTER_GUI);
    }

    public static void openGui(BlockEntity tile) {
        FilterableGuiTogglePacket.sendToServer(tile.m_58899_(), GUI);
    }

    protected static void sendToServer(BlockPos pos, byte mode) {
        FilterableGuiTogglePacket packet = new FilterableGuiTogglePacket();
        packet.type = FilterHolderType.TILE;
        packet.pos = pos;
        packet.mode = mode;
        packet.sendToServer();
    }

    public static void openFilterGui(Entity entity) {
        FilterableGuiTogglePacket.sendToServer(entity.m_19879_(), FILTER_GUI);
    }

    public static void openGui(Entity entity) {
        FilterableGuiTogglePacket.sendToServer(entity.m_19879_(), GUI);
    }

    protected static void sendToServer(int entityId, byte mode) {
        FilterableGuiTogglePacket packet = new FilterableGuiTogglePacket();
        packet.type = FilterHolderType.ENTITY;
        packet.entityId = entityId;
        packet.mode = mode;
        packet.sendToServer();
    }
}

