/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils.container;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.util.INBTSerializable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class SimpleContainer
implements Container,
INBTSerializable<CompoundTag> {
    private int size;
    private NonNullList<ItemStack> items;
    private List<ContainerListener> listeners;

    public SimpleContainer(int size) {
        this.size = size;
        this.items = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
    }

    public SimpleContainer(ItemStack ... content) {
        this.size = content.length;
        this.items = NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])content);
    }

    public void addListener(ContainerListener param0) {
        if (this.listeners == null) {
            this.listeners = Lists.newArrayList();
        }
        this.listeners.add(param0);
    }

    public void removeListener(ContainerListener param0) {
        this.listeners.remove(param0);
    }

    @NotNull
    public ItemStack m_8020_(int index) {
        return index >= 0 && index < this.items.size() ? (ItemStack)this.items.get(index) : ItemStack.f_41583_;
    }

    public List<ItemStack> removeAllItems() {
        List<ItemStack> list = this.items.stream().filter(stack -> !stack.m_41619_()).collect(Collectors.toList());
        this.m_6211_();
        return list;
    }

    @NotNull
    public ItemStack m_7407_(int index, int count) {
        ItemStack removeResult = ContainerHelper.m_18969_(this.items, (int)index, (int)count);
        if (!removeResult.m_41619_()) {
            this.m_6596_();
        }
        return removeResult;
    }

    public ItemStack removeItemType(Item item, int toExtract) {
        ItemStack nullStack = new ItemStack((ItemLike)item, 0);
        for (int reversedIndex = this.size - 1; reversedIndex >= 0; --reversedIndex) {
            ItemStack stack = this.m_8020_(reversedIndex);
            if (!stack.m_41720_().equals(item)) continue;
            int remaining = toExtract - nullStack.m_41613_();
            ItemStack splitResult = stack.m_41620_(remaining);
            nullStack.m_41769_(splitResult.m_41613_());
            if (nullStack.m_41613_() == toExtract) break;
        }
        if (!nullStack.m_41619_()) {
            this.m_6596_();
        }
        return nullStack;
    }

    public ItemStack addItem(ItemStack input) {
        ItemStack var0 = input.m_41777_();
        this.moveItemToOccupiedSlotsWithSameType(var0);
        if (var0.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.moveItemToEmptySlots(var0);
        return var0.m_41619_() ? ItemStack.f_41583_ : var0;
    }

    public boolean canAddItem(ItemStack input) {
        boolean foundEmptyOrMatching = false;
        for (ItemStack stack : this.items) {
            if (!stack.m_41619_() && (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)input) || stack.m_41613_() >= stack.m_41741_())) continue;
            foundEmptyOrMatching = true;
            break;
        }
        return foundEmptyOrMatching;
    }

    @NotNull
    public ItemStack m_8016_(int index) {
        ItemStack stack = (ItemStack)this.items.get(index);
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.items.set(index, (Object)ItemStack.f_41583_);
        return stack;
    }

    public void m_6836_(int index, ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public int m_6643_() {
        return this.size;
    }

    public boolean m_7983_() {
        return this.items.stream().allMatch(ItemStack::m_41619_);
    }

    public void m_6596_() {
        if (this.listeners != null) {
            this.listeners.forEach(listener -> listener.m_5757_((Container)this));
        }
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_6211_() {
        this.items.clear();
        this.m_6596_();
    }

    public void fillStackedContents(StackedContents stackedContents) {
        for (ItemStack stack : this.items) {
            stackedContents.m_36491_(stack);
        }
    }

    public String toString() {
        return this.items.stream().filter(stack -> !stack.m_41619_()).collect(Collectors.toList()).toString();
    }

    private void moveItemToEmptySlots(ItemStack input) {
        for (int index = 0; index < this.size; ++index) {
            ItemStack stack = this.m_8020_(index);
            if (!stack.m_41619_()) continue;
            this.m_6836_(index, input.m_41777_());
            input.m_41764_(0);
            return;
        }
    }

    private void moveItemToOccupiedSlotsWithSameType(ItemStack input) {
        for (int index = 0; index < this.size; ++index) {
            ItemStack stack = this.m_8020_(index);
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)input)) continue;
            this.moveItemsBetweenStacks(input, stack);
            if (!input.m_41619_()) continue;
            return;
        }
    }

    private void moveItemsBetweenStacks(ItemStack leftInput, ItemStack rightInput) {
        int maxTransfer = Math.min(this.m_6893_(), rightInput.m_41741_());
        int toTransfer = Math.min(leftInput.m_41613_(), maxTransfer - rightInput.m_41613_());
        if (toTransfer > 0) {
            rightInput.m_41769_(toTransfer);
            leftInput.m_41774_(toTransfer);
            this.m_6596_();
        }
    }

    public void fromTag(ListTag param0) {
        for (int var0 = 0; var0 < param0.size(); ++var0) {
            ItemStack var1 = ItemStack.m_41712_((CompoundTag)param0.m_128728_(var0));
            if (var1.m_41619_()) continue;
            this.addItem(var1);
        }
    }

    public ListTag createTag() {
        ListTag var0 = new ListTag();
        for (int var1 = 0; var1 < this.m_6643_(); ++var1) {
            ItemStack var2 = this.m_8020_(var1);
            if (var2.m_41619_()) continue;
            var0.add((Object)var2.m_41739_(new CompoundTag()));
        }
        return var0;
    }

    public void setSize(int size) {
        this.size = size;
        this.items = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        this.m_6596_();
    }

    @Override
    public CompoundTag serializeNBT() {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.items.size(); ++i) {
            if (((ItemStack)this.items.get(i)).m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            ((ItemStack)this.items.get(i)).m_41739_(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Items", (Tag)nbtTagList);
        nbt.m_128405_("Size", this.items.size());
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.setSize(nbt.m_128425_("Size", 3) ? nbt.m_128451_("Size") : this.items.size());
        ListTag tagList = nbt.m_128437_("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.m_128728_(i);
            int slot = itemTags.m_128451_("Slot");
            if (slot < 0 || slot >= this.items.size()) continue;
            this.items.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemTags));
        }
        this.m_6596_();
    }
}

