/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.utils;

import com.mojang.serialization.Codec;
import earth.terrarium.adastra.api.planets.Planet;
import earth.terrarium.adastra.common.blockentities.base.ContainerMachineBlockEntity;
import earth.terrarium.adastra.common.blocks.base.MachineBlock;
import earth.terrarium.adastra.common.config.AdAstraConfig;
import earth.terrarium.adastra.common.container.VehicleContainer;
import earth.terrarium.adastra.common.entities.vehicles.Lander;
import earth.terrarium.adastra.common.entities.vehicles.Rocket;
import earth.terrarium.adastra.common.menus.PlanetsMenu;
import earth.terrarium.adastra.common.menus.base.BaseContainerMenu;
import earth.terrarium.adastra.common.registry.ModEntityTypes;
import earth.terrarium.adastra.common.utils.PlatformUtils;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;

public final class ModUtils {
    public static <T extends ParticleOptions> void sendParticles(ServerLevel level, T particle, double x, double y, double z, int count, double deltaX, double deltaY, double deltaZ, double speed) {
        for (ServerPlayer player : level.m_6907_()) {
            level.m_8624_(player, particle, true, x, y, z, count, deltaX, deltaY, deltaZ, speed);
        }
    }

    public static Optional<ContainerMachineBlockEntity> getMachineFromMenuPacket(BlockPos pos, Player player, Level level) {
        if (!(player.f_36096_ instanceof BaseContainerMenu)) {
            return Optional.empty();
        }
        if (player.m_20238_(pos.m_252807_()) > 64.0) {
            return Optional.empty();
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof ContainerMachineBlockEntity)) {
            return Optional.empty();
        }
        ContainerMachineBlockEntity container = (ContainerMachineBlockEntity)blockEntity;
        return Optional.of(container);
    }

    public static boolean canTeleportToPlanet(Player player, Planet targetPlanet) {
        String[] planets;
        if (!(player.f_36096_ instanceof PlanetsMenu)) {
            return false;
        }
        if (player.m_7500_() || player.m_5833_() || player.m_20310_(2)) {
            return true;
        }
        for (String planet : planets = AdAstraConfig.disabledPlanets.split(",")) {
            if (!planet.equals(targetPlanet.dimension().m_135782_().toString())) continue;
            return false;
        }
        Entity entity = player.m_20202_();
        if (!(entity instanceof Rocket)) {
            return false;
        }
        Rocket rocket = (Rocket)entity;
        if (rocket.m_20186_() < (double)AdAstraConfig.atmosphereLeave) {
            return false;
        }
        return rocket.tier() >= targetPlanet.tier();
    }

    public static <T extends Enum<T>> Codec<T> createEnumCodec(Class<T> enumClass) {
        return Codec.STRING.xmap(s -> Enum.valueOf(enumClass, s.toUpperCase(Locale.ROOT)), Enum::name);
    }

    public static Direction relative(BlockEntity from, Direction to) {
        return ModUtils.relative((Direction)from.m_58900_().m_61143_((Property)MachineBlock.FACING), to);
    }

    public static Direction relative(Direction from, Direction to) {
        if (to.m_122434_().m_122478_()) {
            return to;
        }
        return switch (from) {
            case Direction.EAST -> to.m_122427_();
            case Direction.SOUTH -> to.m_122424_();
            case Direction.WEST -> to.m_122428_();
            default -> to;
        };
    }

    public static Entity teleportToDimension(Entity entity, ServerLevel level) {
        PortalInfo target = new PortalInfo(entity.m_20182_(), entity.m_20184_(), entity.m_146908_(), entity.m_146909_());
        return PlatformUtils.teleportToDimension(entity, level, target);
    }

    public static void land(ServerPlayer player, ServerLevel targetLevel, Vec3 pos) {
        Entity vehicle = player.m_20202_();
        player.m_8127_();
        player.m_20219_(pos);
        Entity teleportedPlayer = ModUtils.teleportToDimension((Entity)player, targetLevel);
        if (!(vehicle instanceof Rocket)) {
            return;
        }
        Rocket rocket = (Rocket)vehicle;
        Lander lander = (Lander)((EntityType)ModEntityTypes.LANDER.get()).m_20615_((Level)targetLevel);
        if (lander == null) {
            return;
        }
        lander.m_146884_(pos);
        targetLevel.m_7967_((Entity)lander);
        teleportedPlayer.m_20329_((Entity)lander);
        VehicleContainer rocketInventory = rocket.inventory();
        VehicleContainer landerInventory = lander.inventory();
        for (int i = 0; i < rocketInventory.m_6643_(); ++i) {
            landerInventory.m_6836_(i + 1, rocketInventory.m_8020_(i));
        }
        landerInventory.m_6836_(0, rocket.getDropStack());
        rocket.m_146870_();
    }
}

