/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.telepastries.config;

import com.mrbysco.telepastries.TelePastries;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public class TeleConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        TelePastries.LOGGER.debug("Loaded TelePastries' config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        TelePastries.LOGGER.debug("TelePastries' config just got changed on the file system!");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue explosionImmune;
        public final ForgeConfigSpec.BooleanValue ignoreHunger;
        public final ForgeConfigSpec.BooleanValue disableHopping;
        public final ForgeConfigSpec.BooleanValue resetPastry;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> resetItems;
        public final ForgeConfigSpec.BooleanValue consumeNetherCake;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> netherCakeRefillItems;
        public final ForgeConfigSpec.BooleanValue consumeEndCake;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> endCakeRefillItems;
        public final ForgeConfigSpec.BooleanValue consumeOverworldCake;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> overworldCakeRefillItems;
        public final ForgeConfigSpec.BooleanValue consumeTwilightCake;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> twilightCakeRefillItems;
        public final ForgeConfigSpec.BooleanValue consumeLostCitiesCake;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> lostCitiesCakeRefillItem;
        public final ForgeConfigSpec.BooleanValue consumeCustomCake;
        public final ForgeConfigSpec.ConfigValue<? extends String> customCakeName;
        public final ForgeConfigSpec.ConfigValue<? extends String> customCakeDimension;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> customCakeRefillItem;
        public final ForgeConfigSpec.IntValue customCakeMinY;
        public final ForgeConfigSpec.IntValue customCakeMaxY;
        public final ForgeConfigSpec.BooleanValue consumeCustomCake2;
        public final ForgeConfigSpec.ConfigValue<? extends String> customCake2Name;
        public final ForgeConfigSpec.ConfigValue<? extends String> customCake2Dimension;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> customCake2RefillItem;
        public final ForgeConfigSpec.IntValue customCake2MinY;
        public final ForgeConfigSpec.IntValue customCake2MaxY;
        public final ForgeConfigSpec.BooleanValue consumeCustomCake3;
        public final ForgeConfigSpec.ConfigValue<? extends String> customCake3Name;
        public final ForgeConfigSpec.ConfigValue<? extends String> customCake3Dimension;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> customCake3RefillItem;
        public final ForgeConfigSpec.IntValue customCake3MinY;
        public final ForgeConfigSpec.IntValue customCake3MaxY;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("General settings").push("General");
            this.explosionImmune = builder.comment("Defines if the pastries should be immune to explosions [default: false]").define("explosionImmune", false);
            this.ignoreHunger = builder.comment("Defines if the pastry usage requires hunger, when set to true it ignores hunger [default: false]").define("ignoreHunger", false);
            this.disableHopping = builder.comment("Disable placement of non-overworld cakes in dimensions that aren't the overworld (Meaning you can't go from the nether straight to the end) [default: true]").define("disableHopping", true);
            this.resetPastry = builder.comment("Defines if the pastry teleportation point can be reset with a milk bucket [default: false]").define("resetPastry", false);
            String[] resetItemsList = new String[]{"minecraft:milk_bucket"};
            this.resetItems = builder.comment("Defines the item needed to reset the pastry teleportation point [default: minecraft:milk_bucket]").defineList("resetItems", () -> Arrays.asList(resetItemsList), o -> o instanceof String);
            builder.pop();
            builder.comment("Nether settings").push("Nether");
            this.consumeNetherCake = builder.comment("Defines if the Nether Cake gets partly consumed when eaten [default: true]").define("consumeNetherCake", true);
            String[] netherItems = new String[]{"minecraft:obsidian"};
            this.netherCakeRefillItems = builder.comment("Set the refill items used by Nether Cake (Only change if you know what you're doing) [modid:itemname].").defineList("netherCakeRefillItems", () -> Arrays.asList(netherItems), o -> o instanceof String);
            builder.pop();
            builder.comment("End settings").push("End");
            this.consumeEndCake = builder.comment("Defines if the End Cake gets partly consumed when eaten [default: true]").define("consumeEndCake", true);
            String[] endItems = new String[]{"minecraft:ender_eye"};
            this.endCakeRefillItems = builder.comment("Set the refill items used by End Cake (Only change if you know what you're doing) [modid:itemname].").defineList("endCakeRefillItems", () -> Arrays.asList(endItems), o -> o instanceof String);
            builder.pop();
            builder.comment("Overworld settings").push("Overworld");
            this.consumeOverworldCake = builder.comment("Defines if the Overworld Cake gets partly consumed when eaten [default: true]").define("consumeOverworldCake", true);
            String[] overworldItems = new String[]{"minecraft:oak_sapling", "minecraft:spruce_sapling", "minecraft:birch_sapling", "minecraft:jungle_sapling", "minecraft:acacia_sapling", "minecraft:dark_oak_sapling"};
            this.overworldCakeRefillItems = builder.comment("Set the refill items used by Overworld Cake (Only change if you know what you're doing) [modid:itemname].").defineList("overworldCakeRefillItems", () -> Arrays.asList(overworldItems), o -> o instanceof String);
            builder.pop();
            builder.comment("Compat settings").push("Compat");
            this.consumeTwilightCake = builder.comment("Defines if the Twilight Forest Cake gets partly consumed when eaten [default: true]").define("consumeTwilightCake", true);
            String[] twilightItems = new String[]{"minecraft:diamond"};
            this.twilightCakeRefillItems = builder.comment("Set the refill items used by the Twilight Forest Cake (Only change if you know what you're doing) [modid:itemname]").defineList("TwilightCakeRefillItems", () -> Arrays.asList(twilightItems), o -> o instanceof String);
            this.consumeLostCitiesCake = builder.comment("Defines if the Lost Cities Cake gets partly consumed when eaten [default: true]").define("consumeLostCitiesCake", true);
            String[] lostcityItems = new String[]{"minecraft:bed"};
            this.lostCitiesCakeRefillItem = builder.comment("Set the refill items used by the Lost Cities Cake (Only change if you know what you're doing) [modid:itemname]").defineList("lostCitiesCakeRefillItem", () -> Arrays.asList(lostcityItems), o -> o instanceof String);
            builder.pop();
            builder.comment("Custom Cake settings");
            builder.push("CustomCake");
            this.consumeCustomCake = builder.comment("Defines if the Custom Cake gets partly consumed when eaten [default: true]").define("consumeCustomCake", true);
            this.customCakeName = builder.comment("Defines the name of the cake [default: \"Custom\"]").define("customCakeName", (Object)"Custom", o -> o instanceof String);
            this.customCakeDimension = builder.comment("Defines the dimension bound to the custom cake [default: \"minecraft:overworld\"]").define("customCakeDimension", (Object)"minecraft:overworld", o -> o instanceof String);
            String[] customItems = new String[]{"minecraft:cobblestone"};
            this.customCakeRefillItem = builder.comment("Set the refill items used by the Custom Cake (Only change if you know what you're doing) [modid:itemname]").defineList("customCakeRefillItem", () -> Arrays.asList(customItems), o -> o instanceof String);
            this.customCakeMinY = builder.comment("Set the minimum Y location that the cake can spawn you at [Default: 2]").defineInRange("customCakeMinY", 2, 1, 256);
            this.customCakeMaxY = builder.comment("Set the maximum Y location that the cake can spawn you at [Default: 2]").defineInRange("customCakeMaxY", 254, 1, 256);
            builder.pop();
            builder.push("CustomCake2");
            this.consumeCustomCake2 = builder.comment("Defines if the Custom Cake gets partly consumed when eaten [default: true]").define("consumeCustomCake2", true);
            this.customCake2Name = builder.comment("Defines the name of the cake [default: \"Another Custom\"]").define("customCake2Name", (Object)"Another Custom", o -> o instanceof String);
            this.customCake2Dimension = builder.comment("Defines the dimension bound to the custom cake [default: \"minecraft:overworld\"]").define("customCake2Dimension", (Object)"minecraft:overworld", o -> o instanceof String);
            String[] customItems2 = new String[]{"minecraft:cobblestone"};
            this.customCake2RefillItem = builder.comment("Set the refill items used by the Custom Cake (Only change if you know what you're doing) [modid:itemname]").defineList("customCake2RefillItem", () -> Arrays.asList(customItems2), o -> o instanceof String);
            this.customCake2MinY = builder.comment("Set the minimum Y location that the cake can spawn you at [Default: 2]").defineInRange("customCake2MinY", 2, 1, 256);
            this.customCake2MaxY = builder.comment("Set the maximum Y location that the cake can spawn you at [Default: 2]").defineInRange("customCake2MaxY", 254, 1, 256);
            builder.pop();
            builder.push("CustomCake3");
            this.consumeCustomCake3 = builder.comment("Defines if the Custom Cake gets partly consumed when eaten [default: true]").define("consumeCustomCake3", true);
            this.customCake3Name = builder.comment("Defines the name of the cake [default: \"Yet Another Custom\"]").define("customCake3Name", (Object)"Yet Another Custom", o -> o instanceof String);
            this.customCake3Dimension = builder.comment("Defines the dimension bound to the custom cake [default: \"minecraft:overworld\"]").define("customCake3Dimension", (Object)"minecraft:overworld", o -> o instanceof String);
            String[] customItems3 = new String[]{"minecraft:cobblestone"};
            this.customCake3RefillItem = builder.comment("Set the refill items used by the Custom Cake (Only change if you know what you're doing) [modid:itemname]").defineList("customCake3RefillItem", () -> Arrays.asList(customItems3), o -> o instanceof String);
            this.customCake3MinY = builder.comment("Set the minimum Y location that the cake can spawn you at [Default: 2]").defineInRange("customCake3MinY", 2, 1, 256);
            this.customCake3MaxY = builder.comment("Set the maximum Y location that the cake can spawn you at [Default: 2]").defineInRange("customCake3MaxY", 254, 1, 256);
            builder.pop();
        }
    }
}

