/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.items.upgrades;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.zeith.solarflux.api.ISolarPanelTile;
import org.zeith.solarflux.items.upgrades._base.UpgradeItem;
import org.zeith.solarflux.mixins.AbstractFurnaceBlockEntityAccessor;
import org.zeith.solarflux.util.BlockPosFace;

public class ItemFurnaceUpgrade
extends UpgradeItem {
    public ItemFurnaceUpgrade() {
        super(1);
    }

    @Override
    public void update(ISolarPanelTile tile, ItemStack stack, int amount) {
        Level lvl = tile.level();
        BlockPos pos = tile.pos().m_7495_();
        this.updateFurnaceAt(tile, lvl, pos);
        for (BlockPosFace face : tile.traversal()) {
            if (face.face != Direction.UP) continue;
            this.updateFurnaceAt(tile, lvl, face.pos);
        }
    }

    public void updateFurnaceAt(ISolarPanelTile solar, Level lvl, BlockPos pos) {
        AbstractFurnaceBlockEntity tf;
        BlockEntity blockEntity = lvl.m_7702_(pos);
        if (blockEntity instanceof AbstractFurnaceBlockEntity && (tf = (AbstractFurnaceBlockEntity)blockEntity) instanceof AbstractFurnaceBlockEntityAccessor) {
            AbstractFurnaceBlockEntityAccessor a = (AbstractFurnaceBlockEntityAccessor)tf;
            AbstractCookingRecipe irecipe = tf.m_58904_().m_7465_().m_44015_(a.getRecipeType(), (Container)tf, tf.m_58904_()).orElse(null);
            if (tf.f_58316_ <= 1 && irecipe != null && ItemFurnaceUpgrade.canSmelt(tf, irecipe) && solar.energy() >= 1000L) {
                tf.f_58316_ += 200;
                tf.f_58317_ = 200;
                solar.energy(solar.energy() - 1000L);
                if (!((Boolean)lvl.m_8055_(pos).m_61143_((Property)AbstractFurnaceBlock.f_48684_)).booleanValue()) {
                    BlockState state = (BlockState)lvl.m_8055_(pos).m_61124_((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(true));
                    lvl.m_7731_(pos, state, 3);
                    lvl.m_151543_(pos);
                    if (!state.m_60795_()) {
                        lvl.m_46717_(pos, state.m_60734_());
                    }
                }
            }
        }
    }

    public static boolean canSmelt(AbstractFurnaceBlockEntity f, @Nullable Recipe<?> recipe) {
        if (!f.m_8020_(0).m_41619_() && recipe != null) {
            ItemStack result = recipe.m_8043_(f.m_58904_().m_9598_());
            if (result.m_41619_()) {
                return false;
            }
            ItemStack curResIt = f.m_8020_(2);
            if (curResIt.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_41656_((ItemStack)curResIt, (ItemStack)result)) {
                return false;
            }
            if (curResIt.m_41613_() + result.m_41613_() <= f.m_6893_() && curResIt.m_41613_() + result.m_41613_() <= curResIt.m_41741_()) {
                return true;
            }
            return curResIt.m_41613_() + result.m_41613_() <= result.m_41741_();
        }
        return false;
    }
}

