/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.automation.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.content.automation.entity.Gravisand;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.BlockUtils;

public class GravisandBlock
extends ZetaBlock {
    public GravisandBlock(String regname, @Nullable ZetaModule module, BlockBehaviour.Properties properties) {
        super(regname, module, properties);
        if (module == null) {
            return;
        }
        this.setCreativeTab(CreativeModeTabs.f_257028_);
    }

    public void m_6807_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        this.checkRedstone(world, pos);
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos, boolean isMoving) {
        this.checkRedstone(worldIn, pos);
    }

    private void checkRedstone(Level worldIn, BlockPos pos) {
        boolean powered = worldIn.m_276867_(pos);
        if (powered) {
            worldIn.m_186460_(pos, (Block)this, 2);
        }
    }

    public boolean m_7278_(@NotNull BlockState state) {
        return true;
    }

    public int m_6782_(@NotNull BlockState blockState, @NotNull Level worldIn, @NotNull BlockPos pos) {
        return 15;
    }

    public void m_213897_(@NotNull BlockState state, ServerLevel worldIn, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        if (!worldIn.f_46443_ && this.checkFallable(state, (Level)worldIn, pos)) {
            for (Direction face : Direction.values()) {
                BlockPos offPos = pos.m_121945_(face);
                BlockState offState = worldIn.m_8055_(offPos);
                if (offState.m_60734_() != this) continue;
                worldIn.m_186460_(offPos, (Block)this, 2);
            }
        }
    }

    private boolean checkFallable(BlockState state, Level worldIn, BlockPos pos) {
        if (!worldIn.f_46443_) {
            if (this.tryFall(state, worldIn, pos, Direction.DOWN)) {
                return true;
            }
            return this.tryFall(state, worldIn, pos, Direction.UP);
        }
        return false;
    }

    private boolean tryFall(BlockState state, Level worldIn, BlockPos pos, Direction facing) {
        BlockPos target = pos.m_121945_(facing);
        if ((worldIn.m_46859_(target) || BlockUtils.canFallThrough((BlockState)worldIn.m_8055_(target))) && worldIn.m_46739_(pos)) {
            Gravisand entity = new Gravisand(worldIn, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, facing.m_122430_());
            worldIn.m_7731_(pos, state.m_60819_().m_76188_(), 3);
            worldIn.m_7967_((Entity)entity);
            return true;
        }
        return false;
    }
}

