/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.core.v1;

import fuzs.puzzleslib.api.client.core.v1.context.AdditionalModelsContext;
import fuzs.puzzleslib.api.client.core.v1.context.BlockEntityRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.BuiltinModelItemRendererContext;
import fuzs.puzzleslib.api.client.core.v1.context.ClientTooltipComponentsContext;
import fuzs.puzzleslib.api.client.core.v1.context.ColorProvidersContext;
import fuzs.puzzleslib.api.client.core.v1.context.CoreShadersContext;
import fuzs.puzzleslib.api.client.core.v1.context.DynamicBakingCompletedContext;
import fuzs.puzzleslib.api.client.core.v1.context.DynamicModifyBakingResultContext;
import fuzs.puzzleslib.api.client.core.v1.context.EntityRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.EntitySpectatorShaderContext;
import fuzs.puzzleslib.api.client.core.v1.context.ItemDecorationContext;
import fuzs.puzzleslib.api.client.core.v1.context.ItemModelPropertiesContext;
import fuzs.puzzleslib.api.client.core.v1.context.KeyMappingsContext;
import fuzs.puzzleslib.api.client.core.v1.context.LayerDefinitionsContext;
import fuzs.puzzleslib.api.client.core.v1.context.LivingEntityRenderLayersContext;
import fuzs.puzzleslib.api.client.core.v1.context.ParticleProvidersContext;
import fuzs.puzzleslib.api.client.core.v1.context.RenderTypesContext;
import fuzs.puzzleslib.api.client.core.v1.context.SearchRegistryContext;
import fuzs.puzzleslib.api.client.core.v1.context.SkullRenderersContext;
import fuzs.puzzleslib.api.core.v1.BaseModConstructor;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.context.AddReloadListenersContext;
import fuzs.puzzleslib.api.core.v1.context.ModLifecycleContext;
import fuzs.puzzleslib.api.core.v1.context.PackRepositorySourcesContext;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.client.core.ClientFactories;
import fuzs.puzzleslib.impl.core.ModContext;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.apache.logging.log4j.util.Strings;

public interface ClientModConstructor
extends BaseModConstructor {
    public static void construct(String modId, Supplier<ClientModConstructor> modConstructor) {
        ClientModConstructor.construct(modId, modConstructor, new ContentRegistrationFlags[0]);
    }

    @Deprecated(forRemoval=true)
    public static void construct(String modId, Supplier<ClientModConstructor> supplier, ContentRegistrationFlags ... flags) {
        if (Strings.isBlank((String)modId)) {
            throw new IllegalArgumentException("mod id is empty");
        }
        ClientModConstructor instance = supplier.get();
        ModContext modContext = ModContext.get(modId);
        ResourceLocation identifier = ModContext.getPairingIdentifier(modId, instance);
        modContext.scheduleClientModConstruction(identifier, () -> {
            PuzzlesLib.LOGGER.info("Constructing client components for {}", (Object)identifier);
            ContentRegistrationFlags[] builtInFlags = instance.getContentRegistrationFlags();
            Set<ContentRegistrationFlags> availableFlags = Set.of(builtInFlags.length != 0 ? builtInFlags : flags);
            Set<ContentRegistrationFlags> flagsToHandle = modContext.getFlagsToHandle(availableFlags);
            ClientFactories.INSTANCE.constructClientMod(modId, instance, availableFlags, flagsToHandle);
        });
    }

    default public void onConstructMod() {
    }

    @Deprecated(forRemoval=true)
    default public void onClientSetup(ModLifecycleContext context) {
    }

    default public void onClientSetup() {
        this.onClientSetup(Runnable::run);
    }

    default public void onRegisterEntityRenderers(EntityRenderersContext context) {
    }

    default public void onRegisterBlockEntityRenderers(BlockEntityRenderersContext context) {
    }

    default public void onRegisterClientTooltipComponents(ClientTooltipComponentsContext context) {
    }

    default public void onRegisterParticleProviders(ParticleProvidersContext context) {
    }

    default public void onRegisterLayerDefinitions(LayerDefinitionsContext context) {
    }

    @Deprecated(forRemoval=true)
    default public void onRegisterSearchTrees(SearchRegistryContext context) {
    }

    @Deprecated(forRemoval=true)
    default public void onModifyBakingResult(DynamicModifyBakingResultContext context) {
    }

    @Deprecated(forRemoval=true)
    default public void onBakingCompleted(DynamicBakingCompletedContext context) {
    }

    default public void onRegisterAdditionalModels(AdditionalModelsContext context) {
    }

    default public void onRegisterItemModelProperties(ItemModelPropertiesContext context) {
    }

    default public void onRegisterBuiltinModelItemRenderers(BuiltinModelItemRendererContext context) {
    }

    default public void onRegisterItemDecorations(ItemDecorationContext context) {
    }

    default public void onRegisterEntitySpectatorShaders(EntitySpectatorShaderContext context) {
    }

    default public void onRegisterSkullRenderers(SkullRenderersContext context) {
    }

    default public void onRegisterResourcePackReloadListeners(AddReloadListenersContext context) {
    }

    default public void onRegisterLivingEntityRenderLayers(LivingEntityRenderLayersContext context) {
    }

    default public void onRegisterKeyMappings(KeyMappingsContext context) {
    }

    default public void onRegisterBlockRenderTypes(RenderTypesContext<Block> context) {
    }

    default public void onRegisterFluidRenderTypes(RenderTypesContext<Fluid> context) {
    }

    default public void onRegisterBlockColorProviders(ColorProvidersContext<Block, BlockColor> context) {
    }

    default public void onRegisterItemColorProviders(ColorProvidersContext<Item, ItemColor> context) {
    }

    default public void onAddResourcePackFinders(PackRepositorySourcesContext context) {
    }

    default public void onRegisterCoreShaders(CoreShadersContext context) {
    }
}

