/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedexcrafting.recipe;

import com.blakebr0.extendedcrafting.api.crafting.ICombinationRecipe;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.ArrayUtils;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedauto.util.PackagePattern;
import thelm.packagedexcrafting.recipe.CombinationPackageRecipeType;
import thelm.packagedexcrafting.recipe.ICombinationPackageRecipeInfo;

public class CombinationPackageRecipeInfo
implements ICombinationPackageRecipeInfo {
    ICombinationRecipe recipe;
    ItemStack inputCore = ItemStack.f_41583_;
    List<ItemStack> inputPedestal = new ArrayList<ItemStack>();
    List<ItemStack> input = new ArrayList<ItemStack>();
    ItemStack output;
    List<IPackagePattern> patterns = new ArrayList<IPackagePattern>();

    public void load(CompoundTag nbt) {
        this.inputPedestal.clear();
        this.input.clear();
        this.output = ItemStack.f_41583_;
        this.patterns.clear();
        Recipe recipe = MiscHelper.INSTANCE.getRecipeManager().m_44043_(new ResourceLocation(nbt.m_128461_("Recipe"))).orElse(null);
        this.inputCore = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("InputCore"));
        MiscHelper.INSTANCE.loadAllItems(nbt.m_128437_("InputPedestal", 10), this.inputPedestal);
        ArrayList<ItemStack> toCondense = new ArrayList<ItemStack>(this.inputPedestal);
        toCondense.add(this.inputCore);
        if (recipe instanceof ICombinationRecipe) {
            ICombinationRecipe combinationRecipe;
            this.recipe = combinationRecipe = (ICombinationRecipe)recipe;
            SimpleContainer matrix = new SimpleContainer(this.inputPedestal.size() + 1);
            matrix.m_6836_(0, this.inputCore);
            for (int i = 0; i < this.inputPedestal.size(); ++i) {
                matrix.m_6836_(i + 1, this.inputPedestal.get(i));
            }
            this.output = this.recipe.m_5874_((Container)matrix, MiscHelper.INSTANCE.getRegistryAccess()).m_41777_();
        }
        this.input.addAll(MiscHelper.INSTANCE.condenseStacks(toCondense));
        int i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add((IPackagePattern)new PackagePattern((IPackageRecipeInfo)this, i));
            ++i;
        }
    }

    public void save(CompoundTag nbt) {
        if (this.recipe != null) {
            nbt.m_128359_("Recipe", this.recipe.m_6423_().toString());
        }
        CompoundTag inputCoreTag = this.inputCore.m_41739_(new CompoundTag());
        ListTag inputPedestalTag = MiscHelper.INSTANCE.saveAllItems(new ListTag(), this.inputPedestal);
        nbt.m_128365_("InputCore", (Tag)inputCoreTag);
        nbt.m_128365_("InputPedestal", (Tag)inputPedestalTag);
    }

    public IPackageRecipeType getRecipeType() {
        return CombinationPackageRecipeType.INSTANCE;
    }

    public boolean isValid() {
        return this.recipe != null;
    }

    public List<IPackagePattern> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    @Override
    public ItemStack getCoreInput() {
        return this.inputCore.m_41777_();
    }

    @Override
    public List<ItemStack> getPedestalInputs() {
        return Collections.unmodifiableList(this.inputPedestal);
    }

    public List<ItemStack> getInputs() {
        return Collections.unmodifiableList(this.input);
    }

    @Override
    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    @Override
    public long getEnergyRequired() {
        return this.recipe.getPowerCost();
    }

    @Override
    public int getEnergyUsage() {
        return this.recipe.getPowerRate();
    }

    @Override
    public ICombinationRecipe getRecipe() {
        return this.recipe;
    }

    public void generateFromStacks(List<ItemStack> input, List<ItemStack> output, Level level) {
        this.recipe = null;
        this.inputCore = ItemStack.f_41583_;
        this.inputPedestal.clear();
        this.input.clear();
        this.patterns.clear();
        int[] slotArray = CombinationPackageRecipeType.SLOTS.toIntArray();
        ArrayUtils.shift((int[])slotArray, (int)0, (int)25, (int)1);
        for (int i = 0; i < 49; ++i) {
            ItemStack toSet = input.get(slotArray[i]);
            if (!toSet.m_41619_()) {
                toSet.m_41764_(1);
                if (i == 0) {
                    this.inputCore = toSet.m_41777_();
                    continue;
                }
                this.inputPedestal.add(toSet.m_41777_());
                continue;
            }
            if (i != 0) continue;
            return;
        }
        SimpleContainer matrix = new SimpleContainer(this.inputPedestal.size() + 1);
        matrix.m_6836_(0, this.inputCore);
        for (int i = 0; i < this.inputPedestal.size(); ++i) {
            matrix.m_6836_(i + 1, this.inputPedestal.get(i));
        }
        ICombinationRecipe recipe = MiscHelper.INSTANCE.getRecipeManager().m_44015_((RecipeType)ModRecipeTypes.COMBINATION.get(), (Container)matrix, level).orElse(null);
        if (recipe != null) {
            this.recipe = recipe;
            ArrayList<ItemStack> toCondense = new ArrayList<ItemStack>(this.inputPedestal);
            toCondense.add(this.inputCore);
            this.input.addAll(MiscHelper.INSTANCE.condenseStacks(toCondense));
            this.output = recipe.m_5874_((Container)matrix, MiscHelper.INSTANCE.getRegistryAccess()).m_41777_();
            int i = 0;
            while (i * 9 < this.input.size()) {
                this.patterns.add((IPackagePattern)new PackagePattern((IPackageRecipeInfo)this, i));
                ++i;
            }
            return;
        }
    }

    public Int2ObjectMap<ItemStack> getEncoderStacks() {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        int[] slotArray = CombinationPackageRecipeType.SLOTS.toIntArray();
        ArrayUtils.remove((int[])slotArray, (int)24);
        map.put(40, (Object)this.inputCore);
        for (int i = 0; i < this.inputPedestal.size(); ++i) {
            map.put(slotArray[i], (Object)this.inputPedestal.get(i));
        }
        return map;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CombinationPackageRecipeInfo) {
            CombinationPackageRecipeInfo other = (CombinationPackageRecipeInfo)obj;
            return MiscHelper.INSTANCE.recipeEquals((IPackageRecipeInfo)this, (Object)this.recipe, (IPackageRecipeInfo)other, (Object)other.recipe);
        }
        return false;
    }

    public int hashCode() {
        return MiscHelper.INSTANCE.recipeHashCode((IPackageRecipeInfo)this, (Object)this.recipe);
    }
}

