/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.network.packet;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkEvent;
import thelm.packagedauto.slot.FalseCopySlot;
import thelm.packagedauto.util.MiscHelper;

public record SetItemStackPacket(short containerSlot, ItemStack stack) {
    public void encode(FriendlyByteBuf buf) {
        buf.writeShort((int)this.containerSlot);
        MiscHelper.INSTANCE.writeItemWithLargeCount(buf, this.stack);
    }

    public static SetItemStackPacket decode(FriendlyByteBuf buf) {
        return new SetItemStackPacket(buf.readShort(), MiscHelper.INSTANCE.readItemWithLargeCount(buf));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        ctx.get().enqueueWork(() -> {
            Slot slot;
            AbstractContainerMenu container = player.f_36096_;
            if (container != null && this.containerSlot >= 0 && this.containerSlot < container.f_38839_.size() && (slot = container.m_38853_((int)this.containerSlot)) instanceof FalseCopySlot) {
                FalseCopySlot fSlot = (FalseCopySlot)slot;
                ItemStackHandler handler = (ItemStackHandler)fSlot.getItemHandler();
                handler.setStackInSlot(slot.getSlotIndex(), this.stack);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

